<?php
/**
 * Template d'affichage de fiches associées en carte interactive dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3.11
 *
 */

$displayInContainer = false;
$spacingColumn = 'PETIT';
$numberColumn = (object) array(
    'xl' => 2,
    'l' => 2,
    'm' => 1,
    's' => 1,
);

// print_r($blockData->specialComponentData->data->selection->results->products);

if(is_object($blockData) && isset($blockData->parameters) && is_object($blockData->parameters)) {
    // print_r($blockData->parameters);
}
?>
<?php if (isset($blockData) && isset($fiche) && is_object($blockData) && isset($blockData->specialComponent) && $blockData->specialComponent == true && !empty($blockData->specialComponentData)): ?>
    <?php if (isset($blockData) && isset($fiche) && is_object($blockData) && isset($blockData->specialComponent) && $blockData->specialComponent == true && !empty($blockData->specialComponentHtml)): ?>
        <div id="listeSIT_fiches-associees-carte" style="display:none;">
            <?= $blockData->specialComponentHtml ?>
        </div>
    <?php  endif; ?>

    <div class="fiches_associees_carte_container <?= ($displayInContainer) ? 'uk-container' : ''; ?>">
        <div id="mapsSIT_fiches-associees-carte" class="fiches_associees_carte">

        </div>
    </div>
<?php  endif; ?>

<script type="text/javascript">
    // <!--

    window.bridgeCoupledMapOptions = {
        centerLat: '<?= $blockData->specialComponentData->mapOptions->latitude ?>',
        centerLng: '<?= $blockData->specialComponentData->mapOptions->longitude ?>',
        markerIcon: '<?= $blockData->specialComponentData->mapOptions->marker ?>',
        activeMarkerIcon: '<?= $blockData->specialComponentData->mapOptions->activeMarker ?>',
        defaultGeolocIconUrl: '<?= $blockData->specialComponentData->mapOptions->defaultGeolocIconUrl ?>'
    } ;

    window.bridgeCoupledProducts = {};

    <?php if (isset($blockData->specialComponentData->data) && isset($blockData->specialComponentData->data->selection->results) && isset($blockData->specialComponentData->data->selection->results->products) && is_array($blockData->specialComponentData->data->selection->results->products) && count($blockData->specialComponentData->data->selection->results->products) > 0): ?>
        <?php foreach($blockData->specialComponentData->data->selection->results->products as $ficheCarteAsso): ?>
            <?php if (!empty($ficheCarteAsso->latitude) && !empty($ficheCarteAsso->longitude)): ?>
                window.bridgeCoupledProducts['<?= $ficheCarteAsso->productCode ?>'] = { lat: <?= $ficheCarteAsso->latitude ?>, lon: <?= $ficheCarteAsso->longitude ?>, name: '<?= BridgeCmsAbstractLayer::esc_js($ficheCarteAsso->name) ?>' };
            <?php endif; ?>
        <?php endforeach; ?>
    <?php endif; ?>


    // Gère le javascript de la carto
    bridgeDocumentReady(function()
    {
        if (typeof window.bridge_init_carto === 'undefined') {
            window.bridge_init_carto = true;
            window.markercmpt = 0;
            window.mapCoupledService = new dncLeafletServices('mapsSIT_fiches-associees-carte');

            window.mapCoupledService.mapoptions = {
                zoom: 13, // Niveau de Zoom de départ
                centerlat: <?= $blockData->specialComponentData->mapOptions->latitude ?>, // Latitude du centre au départ
                centerlon: <?= $blockData->specialComponentData->mapOptions->longitude ?>, // Longitude du centre au départ
                maptype: 'MAPTYPE_OPENSTREETMAPS', // Type de vue : ROAD, SATTELITE, HYBRID, 3D
                gridSize: 0,
                maxZoom: 12, // Niveau de zoom à partir duquel faire la clusterisation
                scrollWheelZoom: false
            };


            var mapdivcoupled = document.getElementById("mapsSIT_fiches-associees-carte");
            bridgeRefreshCoupledMap();

            window.mapCoupledService.defaultIconOptions = {
                iconSize: [<?=  $blockData->specialComponentData->bridgeParameters->marker_map_width ?>, <?=  $blockData->specialComponentData->bridgeParameters->marker_map_height ?>],
                iconAnchor: [<?=  round($blockData->specialComponentData->bridgeParameters->marker_map_width/2) ?>, <?= round($blockData->specialComponentData->bridgeParameters->marker_map_height/2) ?>],
                popupAnchor: [0, -3]
            };

            window.mapCoupledService.init();
            window.mapCoupledService.switchToWordpress();
            window.mapCoupledService.disabledMouseWheel();
            // Pour ne pas charger plusieurs fois les points
            window.pointsAddedToCoupledMap = false;

            // On ne recharge les points que si la carte est visible
            if(jQuery('#mapsSIT_fiches-associees-carte').is(":visible")) {
                bridgeMapTotalPointsAdded = 0;
                window.mapCoupledService.delallmarkers();
                setTimeout(function() {
                    bridgeAddCoupledPointsToMap();
                }, 200);
            }
            jQuery(window).resize(function () {
                bridgeRefreshCoupledMap();
            });

            // Clic sur le bouton de passage en mode carte sur mobile : on passe sur l'onglet carte de la liste puis on ouvre en plein écran
            jQuery('.bridge-map-toggle-fullscreen').click(function (e) {
                e.preventDefault();
                if (window.mapCoupledService) {
                    // Si les points ne sont pas encore présents sur la carte, on les ajoute
                    // if (window.pointsAddedToCoupledMap === false) {
                    bridgeMapTotalPointsAdded = 0;
                    window.mapCoupledService.delallmarkers();
                    setTimeout(function() {
                        bridgeAddCoupledPointsToMap();
                    }, 200);
                    // }
                    // On passe la carte en plein écran
                    window.mapCoupledService.setZoom(14);
                    setTimeout(function () {
                        window.mapCoupledService.fitboundstomarkers();
                        // window.mapCoupledService.reDraw();
                        bridgeRefreshCoupledMap();
                        window.mapCoupledService.toggleFullScreen();
                    }, 250);
                }
            });
        }
    });

    function bridgeRefreshCoupledMap() {
        var sizeneg = (jQuery(window).width()-jQuery('#maps-loc').parents('.elementor-container').width()+100)/2;
        jQuery('#bridge-map-fiches-associees-carte').css({
            position: 'relative',
            width: '100px',
        });
    }

    // Fonction qui ajoute les points
    // Elle se rappelle elle-même jusqu'à être arrivée au bout
    function bridgeAddCoupledPointsToMap() {
        // On signale que l'init des points est faite
        window.pointsAddedToCoupledMap = true;

        jQuery(document).find('article.ficheproduit').each(function() {

            let productCode = jQuery(this).attr('data-dnc-produit');
            var popupcontent = "";
            /* var onclickf = function(mapositionId) {
                window.mapCoupledService.openinfomarker(mapositionId);
            }; */
            if(window.bridgeCoupledProducts.hasOwnProperty(productCode)) {
                // Ici on construit le contenu du popup
                popupcontent = jQuery(this).html(); // '<a class="uk-button uk-button-primary" href="' + link + '" style="font-size:11px">' + name + '</a>';
                window.mapCoupledService.addmarker(
                    productCode,
                    window.bridgeCoupledProducts[productCode].lat,
                    window.bridgeCoupledProducts[productCode].lon,
                    window.bridgeCoupledProducts[productCode].name,
                    window.bridgeCoupledMapOptions.markerIcon,
                    window.bridgeCoupledMapOptions.activeMarkerIcon,
                    popupcontent,
                    null);
            }

            // Ici on ajuste le Zoom aux points affichés
            setTimeout(function() {
                window.mapCoupledService.fitboundstomarkers();
            },500);
        });
    }


    // -->
</script>

