<?php
/**
 * Template d'affichage de fiches associées dans une page fiche détaillée
  *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3.22
 *
 */

$randomId = BridgeUtils::generateRandomString(10);
$listeContainerId = 'bridge-liste-fiches-associees-' . $randomId;
$mapsContainerId = 'mapsSIT_bridge-fiches-associees-' . $randomId;

    $displayInContainer = false;
    $spacingColumn = 'PETIT';
    $numberColumn = (object) array(
    'xl' => 2,
    'l' => 2,
    'm' => 1,
    's' => 1,
    );

    if(isset($numberColumn->xl) && $numberColumn->xl !== 'auto')
        $numberColumn->xl = '1-' . $numberColumn->xl;
    if(isset($numberColumn->l) && $numberColumn->l !== 'auto')
        $numberColumn->l = '1-' . $numberColumn->l;
    if(isset($numberColumn->m) && $numberColumn->m !== 'auto')
        $numberColumn->m = '1-' . $numberColumn->m;
    if(isset($numberColumn->s) && $numberColumn->s !== 'auto')
        $numberColumn->s = '1-' . $numberColumn->s;

$displayMode = 'LIST';

    if(is_object($blockData) && isset($blockData->parameters) && is_object($blockData->parameters)) {
        if (isset($blockData->parameters->displayMode) && !empty($blockData->parameters->displayMode)) {
            $displayMode = $blockData->parameters->displayMode;
        }
    }
// Nouveau mode CARROUSEL
$isCarousel = (strpos($displayMode, 'CARROUSEL') !== false);

    $hideList = strpos($displayMode, 'LIST') === false;
    $hasMap = !(strpos($displayMode, 'MAP') === false);
?>

<?php if (isset($blockData) && isset($fiche) && is_object($blockData) && isset($blockData->specialComponent) && $blockData->specialComponent == true && !empty($blockData->specialComponentHtml)): ?>
<div class="<?= ($displayInContainer) ? 'uk-container' : ''; ?> bridge_fiches_associees_container">

    <?php if($hasMap): ?>
        <div class="fiches_associees_carte_container">
            <div id="<?= $mapsContainerId ?>" class="fiches_associees_carte"></div>
        </div>
    <?php endif; ?>
    
    <?php if ($isCarousel): ?>
            <!-- ======= MODE CARROUSEL (UIkit Slider) ======= -->
            <div class="bridge-archive-container">
                <div class="bridge-liste" data-bridge-identifier="<?= $listeContainerId ?>" data-moteur-id="">
                    <div uk-slider="finite: true; autoplay: false" class="uk-slider-container">
                        <div class="uk-position-relative uk-visible-toggle" tabindex="-1">

                            <!-- IMPORTANT : UIkit recommande <ul><li>… -->
                            <!-- On garde l'ID existant pour compatibilité avec vos scripts/carte -->
                            <ul id="<?= $listeContainerId ?>"
                                class="uk-slider-items uk-grid uk-grid-<?= $spacingColumn; ?> uk-grid-match
                                       uk-child-width-1-1
                                       uk-child-width-1-2@m
                                       uk-child-width-1-4@l">
                                <?= $blockData->specialComponentHtml ?>
                            </ul>

                            <!-- Flèches -->
                            <a class="uk-position-center-left uk-position-small" href="#" uk-slidenav-previous uk-slider-item="previous" aria-label="Précédent"></a>
                            <a class="uk-position-center-right uk-position-small" href="#" uk-slidenav-next uk-slider-item="next" aria-label="Suivant"></a>
                        </div>

                        <!-- Puces -->
                        <ul class="uk-slider-nav uk-dotnav uk-flex-center uk-margin"></ul>
                    </div>
                </div>
            </div>

            <script type="text/javascript">
                // <!--
                bridgeDocumentReady(function () {
                    // Si le HTML inséré n'est pas en <li>, on convertit à la volée
                    (function normalizeSliderItems(){
                        var list = document.getElementById('<?= $listeContainerId ?>');
                        if (!list) return;

                        // UIkit attend <ul class="uk-slider-items"> avec des <li> directs
                        var isUL = list.tagName.toLowerCase() === 'ul';
                        if (!isUL) {
                            // Si jamais le container n'est pas un <ul>, on ne touche pas (cas rare)
                            return;
                        }

                        var children = Array.prototype.slice.call(list.children);
                        var needsWrap = children.some(function (el) { return el.tagName.toLowerCase() !== 'li'; });

                        if (needsWrap) {
                            children.forEach(function (el) {
                                if (el.tagName.toLowerCase() === 'li') return;

                                var li = document.createElement('li');
                                // préserver les classes utiles pour uk-grid-match/height-match
                                li.className = el.className || '';
                                // déplacer l'élément dans le li
                                li.appendChild(el.cloneNode(true));
                                list.replaceChild(li, el);
                            });
                        }
                    })();
                });
                // -->
            </script>

        <?php else: ?>
    <div class="bridge-archive-container" style="<?= $hideList? 'display:none;':'' ?>">
        <div class="bridge-liste listemini" data-bridge-identifier="<?= $listeContainerId ?>" data-moteur-id="">
            <div id="<?= $listeContainerId ?>" class="listeSIT uk-grid-match filter-sit uk-grid-<?= $spacingColumn; ?> uk-child-width-<?= ($numberColumn->xl) ? $numberColumn->xl.'@xl' : $numberColumn->default.'@xl' ; ?> uk-child-width-<?= ($numberColumn->l) ? $numberColumn->l.'@l' : $numberColumn->default.'@l' ; ?> uk-child-width-<?= ($numberColumn->m) ? $numberColumn->m.'@m' : $numberColumn->default.'@m' ; ?> uk-child-width-<?= ($numberColumn->s) ? $numberColumn->s.'@s' : $numberColumn->default.'@s' ; ?>" uk-grid uk-height-match="target: > div > article > .uk-card" aauk-scrollspy="target: > div; cls: uk-animation-fade; delay: 300">
                <?= $blockData->specialComponentHtml ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if($hasMap && isset($blockData->specialComponentData->mapOptions) && is_object($blockData->specialComponentData->mapOptions) && isset($blockData->specialComponentData->mapOptions->latitude)): ?>
        <script type="text/javascript">
            // <!--
            bridgeDocumentReady(function() {
                var map = new BridgeSimpleListMapLoader('<?= $listeContainerId ?>', '<?= $mapsContainerId ?>');
                map.mapOptions = {
                    centerLat: '<?= $blockData->specialComponentData->mapOptions->latitude ?>',
                    centerLng: '<?= $blockData->specialComponentData->mapOptions->longitude ?>',
                    markerIcon: '<?= $blockData->specialComponentData->mapOptions->marker ?>',
                    activeMarkerIcon: '<?= $blockData->specialComponentData->mapOptions->activeMarker ?>',
                    defaultGeolocIconUrl: '<?= $blockData->specialComponentData->mapOptions->defaultGeolocIconUrl ?>'
                };
                map.iconOptions = {
                    iconSize: [<?=  $blockData->specialComponentData->bridgeParameters->marker_map_width ?>, <?=  $blockData->specialComponentData->bridgeParameters->marker_map_height ?>],
                    iconAnchor: [<?=  round($blockData->specialComponentData->bridgeParameters->marker_map_width/2) ?>, <?= round($blockData->specialComponentData->bridgeParameters->marker_map_height/2) ?>],
                    popupAnchor: [0, -3]
                };
                map.displayMap();
                map.addHighlightedMarker('<?= $fiche->latitude ?>', '<?= $fiche->longitude ?>');
                <?php if(isset($fiche->kml) && $fiche->kml != ''): ?>
                    map.mapService.addkml('<?= $fiche->kml; ?>','fichekml1');
                <?php endif; ?>
            });
            // -->
        </script>
    <?php endif; ?>

<?php endif; ?>
