<?php
/**
 * Template d'affichage de composant galerie photos en grille
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.4.30
 *
 */

$images = BridgeblockService::extractPhotosFromBlock($blockData);
if(count($images) > 0): ?>
    <div class="uk-child-width-1-2@s uk-child-width-1-3@m uk-grid-small uk-grid-match" uk-grid uk-lightbox>
        <?php foreach($images as $image): ?>
            <div>
                <div class="uk-cover-container uk-height-medium" >
                    <a href="<?= $image->url ?>">
                        <img data-src="<?= BridgeUtils::getResizeImageLink($image->url, "tronq", "600", "400", "60") ?>" alt="" uk-img uk-cover />
                    </a>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
