<?php
/**
 * Template d'affichage de composant galerie photos en masonry
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.4.30
 *
 */

$images = BridgeblockService::extractPhotosFromBlock($blockData);
if(count($images) > 0): ?>
<div class="uk-child-width-1-2@s uk-child-width-1-3@m uk-grid-small" uk-grid="masonry: true" uk-lightbox>
    <?php foreach($images as $image): ?>
        <a href="<?= $image->url ?>">
            <img src="<?= BridgeUtils::getResizeImageLink($image->url, "tronq", "600", "400", "60") ?>" alt="" />
        </a>
    <?php endforeach; ?>
</div>
<?php endif; ?>
