<?php
/**
 * Template d'affichage de composant galerie photos en grille
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.3.5
 *
 */

$images = BridgeblockService::extractPhotosFromBlock($blockData);
if(count($images) > 0): ?>
    <div uk-slider="sets: true; autoplay: true">
        <div class="uk-position-relative uk-transition-toggle" >
            <div class="uk-slider-container uk-light">
                <ul class="uk-slider-items uk-child-width-1-2 uk-child-width-1-2@s uk-child-width-1-2@m uk-grid uk-grid-small" uk-lightbox="animation: scale">
                    <?php $i=0; foreach($images as $image) : $i++; ?>
                        <li>
                             <a href="<?= $image->url; ?>" title="<?= "&copy; ".$image->caption; ?>" data-alt="<?= "&copy; ".$image->caption; ?>" data-caption="<?= "&copy; ".$image->caption; ?>"><img data-src="<?= BridgeUtils::getResizeImageLink($image->url, "tronq", "400", "300", "60") ?>" alt="<?= "&copy; ".$image->caption; ?>"  uk-img height="400"  /></a>
                        </li>
                    <?php endforeach; ?>
                </ul>
                <a class="uk-position-center-left uk-position-small uk-hidden-hover uk-transition-slide-bottom" href="#" uk-slidenav-previous uk-slider-item="previous"></a>
                <a class="uk-position-center-right uk-position-small uk-hidden-hover uk-transition-slide-bottom" href="#" uk-slidenav-next uk-slider-item="next"></a>
            </div>
            <ul class="uk-slider-nav uk-dotnav uk-flex-center uk-margin "></ul>
        </div>
</div>
<?php endif; ?>

