<?php

$displayKml = false;
$displayGpx = true;
$displayGeoJson = false;
$buttonsColumns = (object) array('default' => 1, 'xl' => 1, 'l' => 1, 'm' => 1, 's' => 1);

$gpxTitle = BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_TRACE_GPX', 'Trace GPX','plugin-sit');
$kmlTitle = BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_TRACE_KML', 'Trace KML','plugin-sit');
$geoJsonTitle = BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_TRACE_GEOJSON', 'Trace GeoJson','plugin-sit');

if(isset($blockData->parameters) && is_object($blockData->parameters) && isset($blockData->parameters->columns))
    $buttonsColumns = $blockData->parameters->columns;
if(isset($blockData->parameters) && is_object($blockData->parameters) && isset($blockData->parameters->displayGpxButton))
    $displayGpx = $blockData->parameters->displayGpxButton;
if(isset($blockData->parameters) && is_object($blockData->parameters) && isset($blockData->parameters->displayKmlButton))
    $displayKml = $blockData->parameters->displayKmlButton;
if(isset($blockData->parameters) && is_object($blockData->parameters) && isset($blockData->parameters->displayGeoJsonButton))
    $displayGeoJson = $blockData->parameters->displayGeoJsonButton;

if(isset($buttonsColumns->xl) && $buttonsColumns->xl !== 'auto')
    $buttonsColumns->xl = '1-' . $buttonsColumns->xl;
if(isset($buttonsColumns->l) && $buttonsColumns->l !== 'auto')
    $buttonsColumns->l = '1-' . $buttonsColumns->l;
if(isset($buttonsColumns->m) && $buttonsColumns->m !== 'auto')
    $buttonsColumns->m = '1-' . $buttonsColumns->m;
if(isset($buttonsColumns->s) && $buttonsColumns->s !== 'auto')
    $buttonsColumns->s = '1-' . $buttonsColumns->s;

?>

<?php if(isset($fiche->kml) && !empty($fiche->kml)): ?>
    <div class="bridge-traces-dl uk-container uk-section uk-padding-small aauk-section-small bridge-documents">
        <?php if((isset($item) && $item->title=='') && (isset($onglet) && $onglet->title=='')): ?>
            <h3 class="uk-text-center"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_TELECHARGEMENTS', 'Téléchargements','plugin-sit'); ?></h3>
        <?php endif; ?>
        <div class="documents_inner traces_dl_inner uk-grid-small uk-grid-match uk-child-width-<?= ($buttonsColumns->xl) ? $buttonsColumns->xl.'@xl' : $buttonsColumns->default.'@xl' ; ?> uk-child-width-<?= ($buttonsColumns->l) ? $buttonsColumns->l.'@l' : $buttonsColumns->default.'@l' ; ?> uk-child-width-<?= ($buttonsColumns->m) ? $buttonsColumns->m.'@m' : $buttonsColumns->default.'@m' ; ?> uk-child-width-<?= ($buttonsColumns->s) ? $buttonsColumns->s.'@s' : $buttonsColumns->default.'@s' ; ?>" uk-grid>
            <?php if($displayGpx): ?>
                <div class="bridge-trace-button bridge-trace-gpx bridge-document ">
                    <a href="/index.php?bridge_dl_trace=1&product_code=<?= $fiche->productCode ?>&trace_format=gpx"  class="download-link uk-button uk-button-default" target="_blank" title="<?= BridgeCmsAbstractLayer::esc_attr($gpxTitle) ?>"><?= $gpxTitle ?></a>
                </div>
            <?php endif; ?>
            <?php if($displayKml): ?>
                <div class="bridge-trace-button bridge-trace-kml bridge-document">
                    <a href="/index.php?bridge_dl_trace=1&product_code=<?= $fiche->productCode ?>&trace_format=kml"  class="download-link uk-button uk-button-default" target="_blank" title="<?= BridgeCmsAbstractLayer::esc_attr($kmlTitle) ?>"><?= $kmlTitle ?></a>
                </div>
            <?php endif; ?>
            <?php if($displayGeoJson): ?>
                <div class="bridge-trace-button bridge-trace-geojson bridge-document">
                    <a href="/index.php?bridge_dl_trace=1&product_code=<?= $fiche->productCode ?>&trace_format=geojson"  class="download-link uk-button uk-button-default" target="_blank" title="<?= BridgeCmsAbstractLayer::esc_attr($geoJsonTitle) ?>"><?= $geoJsonTitle ?></a>
                </div>
            <?php endif; ?>

        </div>
    </div>
<?php endif; ?>
