<?php
/**
 * Template d'affichage de fiches à proximité dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.3.11
 *
 */
$devDN = (isset($_REQUEST['ddd']) && $_REQUEST['ddd'] == '1');
$critCapacite = 1901617;
$tabModSalles["1912277"] = ["salle" => "Salle 1", "forme" => "capaciteEnu"] ;
$tabModSalles["1912278"] = ["salle" => "Salle 1", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912279"] = ["salle" => "Salle 1", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912280"] = ["salle" => "Salle 1", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912281"] = ["salle" => "Salle 2", "forme" => "capaciteEnu"] ;
$tabModSalles["1912282"] = ["salle" => "Salle 2", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912283"] = ["salle" => "Salle 2", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912284"] = ["salle" => "Salle 2", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912285"] = ["salle" => "Salle 3", "forme" => "capaciteEnu"] ;
$tabModSalles["1912286"] = ["salle" => "Salle 3", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912287"] = ["salle" => "Salle 3", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912288"] = ["salle" => "Salle 3", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912289"] = ["salle" => "Salle 4", "forme" => "capaciteEnu"] ;
$tabModSalles["1912290"] = ["salle" => "Salle 4", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912291"] = ["salle" => "Salle 4", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912292"] = ["salle" => "Salle 4", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912293"] = ["salle" => "Salle 5", "forme" => "capaciteEnu"] ;
$tabModSalles["1912294"] = ["salle" => "Salle 5", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912295"] = ["salle" => "Salle 5", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912296"] = ["salle" => "Salle 5", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912297"] = ["salle" => "Salle 6", "forme" => "capaciteEnu"] ;
$tabModSalles["1912298"] = ["salle" => "Salle 6", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912299"] = ["salle" => "Salle 6", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912300"] = ["salle" => "Salle 6", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912301"] = ["salle" => "Salle 7", "forme" => "capaciteEnu"] ;
$tabModSalles["1912302"] = ["salle" => "Salle 7", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912303"] = ["salle" => "Salle 7", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912304"] = ["salle" => "Salle 7", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912305"] = ["salle" => "Salle 8", "forme" => "capaciteEnu"] ;
$tabModSalles["1912306"] = ["salle" => "Salle 8", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912307"] = ["salle" => "Salle 8", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912308"] = ["salle" => "Salle 8", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912309"] = ["salle" => "Salle 9", "forme" => "capaciteEnu"] ;
$tabModSalles["1912310"] = ["salle" => "Salle 9", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912311"] = ["salle" => "Salle 9", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912312"] = ["salle" => "Salle 9", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912313"] = ["salle" => "Salle 10", "forme" => "capaciteEnu"] ;
$tabModSalles["1912314"] = ["salle" => "Salle 10", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912315"] = ["salle" => "Salle 10", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912316"] = ["salle" => "Salle 10", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912317"] = ["salle" => "Salle 11", "forme" => "capaciteEnu"] ;
$tabModSalles["1912318"] = ["salle" => "Salle 11", "forme" => "capaciteCocktail"] ;
$tabModSalles["1912319"] = ["salle" => "Salle 11", "forme" => "capaciteAmphi"] ;
$tabModSalles["1912320"] = ["salle" => "Salle 11", "forme" => "capaciteBanquet"] ;
$tabModSalles["1912321"] = ["salle" => "Salle 12", "forme" => "capaciteEnu"] ; // En U
$tabModSalles["1912322"] = ["salle" => "Salle 12", "forme" => "capaciteCocktail"] ; // Caocktail
$tabModSalles["1912323"] = ["salle" => "Salle 12", "forme" => "capaciteAmphi"] ;  // Theatre
$tabModSalles["1912324"] = ["salle" => "Salle 12", "forme" => "capaciteBanquet"] ; // repas assis

// On recense les modalités par salle et par forme pour répartir enssuite les colonnes et lignes
$tabFormes = [];
$tabSalles = [];
foreach($tabModSalles as $key => $value) {
    if(! isset($tabFormes[$value["forme"]]))
        $tabFormes[$value["forme"]] = array();
    $tabFormes[$value["forme"]][] = $key;

    if(! isset($tabSalles[$value["salle"]]))
        $tabSalles[$value["salle"]] = array();
    $tabSalles[$value["salle"]][] = $key;
}

//
$capacitesLibelles = [
        'superficie' => 'Surface en m²',
        'capaciteCocktail' => 'Capacité en cocktail',
        'capaciteAmphi' => 'Capacité en théâtre',
        'capaciteClasse' => 'Capacité en classe',
        'capaciteEnu' => 'Capacité en U',
        'capaciteReunion' => 'Capacité en réunion',
        'capaciteBanquet' => 'Capacité en banquet'
    ];


$crdpCapacites = BridgeBlockService::filterModalities($fiche->modalities, [ 'criterionCode' => $critCapacite] );

$tableauCapacites = [];
if(count($crdpCapacites) > 0) {
    foreach($tabSalles as $salle => $tabModasSalle) {
        foreach($tabFormes as $forme => $tabModasForme) {
            foreach($crdpCapacites as $crdpCapacite) {
                if(in_array($crdpCapacite->modalityCode, $tabModasSalle)) {
                    //  echo "<br>Salle : " . $salle . " - Forme : " . $forme . " - ModalityCode : " . $crdpCapacite->modalityCode;
                    if(!isset($tableauCapacites[$salle]))
                        $tableauCapacites[$salle] = array();
                    if(!isset($tableauCapacites[$salle][$forme]))
                        $tableauCapacites[$salle][$forme] = '';
                    if(in_array($crdpCapacite->modalityCode, $tabModasForme)) {
                        $tableauCapacites[$salle][$forme] = $crdpCapacite->value;
                    }
                }
            }
        }
    }
}

$sallesAffectees = array_keys($tableauCapacites);

?>

<?php if (count($sallesAffectees) > 0 ): ?>

        <?php if((isset($item) && $item->title=='') && (isset($onglet) && $onglet->title=='')): ?>
            <h3 class="uk-panel-title tm-heading-underline"><?= BridgeCmsAbstractLayer::__('DISPONIBILITES','plugin-sit');?></h3>
        <?php endif; ?>
        <div class="bridge-table-capacites-salles-container">
            <table class="bridge-table-capacites-salles">
                <colgroup>
                    <col style="width:auto;"></col>
                    <?php for($i = 0; $i < count($tabFormes); $i++): ?>
                        <col style="width:50px;"></col>
                    <?php endfor; ?>
                </colgroup>
                <tr>
                    <th>Nom</th>
                    <?php foreach($tabFormes as $forme => $modas): ?>
                        <th><?= BridgeUtils::bridgeInlineSvg(BridgeUtils::getBridgeImgUrl() . '/' . $forme . '.svg', BridgeCmsAbstractLayer::__($capacitesLibelles[$forme], 'pylot-bridge')) ?></th>
                    <?php endforeach; ?>
                </tr>
                <?php foreach($tableauCapacites as $nomSalle => $capacites): ?>
                    <tr>
                        <td class="bridge-salle-nom"><?= $nomSalle ?></td>
                        <?php foreach($capacites as $forme => $capa): ?>
                            <?php if(empty($capa) && $capa !== '0'): ?>
                                <td class="bridge-salle-capacite bridge-salle-capacite-vide">-</td>
                            <?php else: ?>
                                <td class="bridge-salle-capacite"><?= $capa ?></td>
                            <?php endif; ?>

                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>

            </table>
        </div>
    <?php else: ?>
<?php  endif; ?>
<?php // } // fin dev DN ?>
