<?php

/* * *******************************************************************
 *
 *      ICI PARAMETRAGE TRES FACILE
 *      il n'y a qu'à mettre ci-dessous dans $criteres_prix
 *      la liste des critères de prix à utiliser
 *      C'EST TOUT !
 */
$criteres_prix = array(1900532, 1900531, 1900533, 1900955, 1900535, 1900536, 1900537);
/**
 *       1900532    Tarifs aub./villages de vacances (en €)
 *       1900531    Tarifs camping (en €)
 *       1900533    Tarifs chambre d'hôtes (en €)
 *       1900955    Tarifs de l'aire de camping car
 *       1900535    Tarifs gîtes/meublés/refuges (en €)
 *       1900536    Tarifs hôtels (en €)
 *       1900537    Tarifs restauration (en €)
 */


/*     * *************************************************************************************
      CONSTRUCTION DU TABLEAU DE DONNEES DE BASE PREMACHEES
      On contruit le tableau des critères / modas avec gestion automatique du mini-maxi
      Et on le met en cache car c'est un peu lourd
     * *************************************************************************************** */

    // Première passe : on ajoute les attributs mini / maxi et moda et le nom normalisé
    if (count($criteres_prix)) {

        $modalite = array();
        $tab_mod = array();
        foreach ($criteres_prix as $critere) {
            $filtre = array("criterionCode" => $critere);
            $tarifs = BridgeUtils::filterModalities($fiche->modalities, $filtre);

            if(count($tarifs) > 0) {
                foreach($tarifs as $tarif) {
                    $modalite[$tarif->modalityCode] = array();
                // On normalise le nom en minuscules et supprime les accents pour détecter les préfixes mini, maxi
                $nommod = strtolower($tarif->name);
                // "Mindestpreis " / "Höchstpreis "
                // Min. Max.

                $mini = '';
                $maxi = '';
                $modaliteseule = '';

                // On stocke mini / maxi et
                // On coupe le nom de la modalité pour enlever le préfixe mini / xai
                if (mb_strpos($nommod, 'mini ') !== false && mb_strpos($nommod, 'mini ') == 0) {
                    $mini = $tarif->value;
                    $nommodnew = mb_substr($nommod, 5);
                } elseif (mb_strpos($nommod, 'mindestpreis ') !== false && mb_strpos($nommod, 'mindestpreis ') == 0) {
                    $mini = $tarif->value;
                    $nommodnew = mb_substr($nommod, 13);
                } elseif (mb_strpos($nommod, 'min. ') !== false && mb_strpos($nommod, 'min. ') == 0) {
                    $mini = $tarif->value;
                    $nommodnew = mb_substr($nommod, 5);
                } elseif (mb_strpos($nommod, 'maxi ') !== false && mb_strpos($nommod, 'maxi ') == 0) {
                    $maxi = $tarif->value;
                    $nommodnew = mb_substr($nommod, 5);
                } elseif (mb_strpos($nommod, 'hochstpreis ') !== false && mb_strpos($nommod, 'hochstpreis ') == 0) {
                    $maxi = $tarif->value;
                    $nommodnew = mb_substr($nommod, 12);
                } elseif (mb_strpos($nommod, 'höchstpreis ') !== false && mb_strpos($nommod, 'höchstpreis ') == 0) {
                    $maxi = $tarif->value;
                    $nommodnew = mb_substr($nommod, 12);
                } elseif (mb_strpos($nommod, 'max. ') !== false && mb_strpos($nommod, 'max. ') == 0) {
                    $maxi = $tarif->value;
                    $nommodnew = mb_substr($nommod, 5);
                } else {
                    $modaliteseule = $tarif->value;
                    $nommodnew = $nommod;
                }


                $modalite[$tarif->modalityCode]['critere'] = $tarif->criterionCode;
                $modalite[$tarif->modalityCode]['mini'] = $mini;
                $modalite[$tarif->modalityCode]['maxi'] = $maxi;
                $modalite[$tarif->modalityCode]['modaliteseule'] = $modaliteseule;
                $modalite[$tarif->modalityCode]['nommod'] = ucfirst($nommodnew); // On écrase le nom avec le nom coupé + 1ère majuscule

                $nommodnew = BridgeUtils::stripAccents((string)$nommodnew);
                // PATCH Clémùent 12/02/2015
                $modalite[$tarif->modalityCode]['nommod_alias'] = $tarif->criterionCode.'-'.BridgeUtils::stripSpaces((string)$nommodnew); // On met un alias pour regrouper lees mini / maxi sur un seul élément */
            }
        }
    //print_r($modalite);
    // Deuxième passe : on créé un tableau simple avec les éléments regroupés

    if (count($tarifs)) {
        foreach ($tarifs as $key => $tarif) {
            $critere = & $tarifs[$key];
                $alias = $modalite[$critere->modalityCode]['nommod_alias'];

                // On créé l'entrée si elle n'existe pas
                if (!isset($tab_mod[$alias])) {
                    $tab_mod[$alias] = array();
                    $tab_mod[$alias]['critere'] = $tarif->criterionCode;
                    $tab_mod[$alias]['nommod'] = $modalite[$tarif->modalityCode]['nommod'];
                }
                // On complète l'entrée avec mini + maxi
                if ($modalite[$critere->modalityCode]['mini'] != '')
                    $tab_mod[$alias]['mini'] = $modalite[$critere->modalityCode]['mini'];
                elseif ($modalite[$critere->modalityCode]['maxi'] != '')
                    $tab_mod[$alias]['maxi'] = $modalite[$critere->modalityCode]['maxi'];
                elseif ($modalite[$critere->modalityCode]['modaliteseule'] != ''){
                    $tab_mod[$alias]['seule'] = $modalite[$critere->modalityCode]['modaliteseule'];

                }

            }
    }
}




/* * *************************************************************************************
  AFFICHAGE.... ENFIN !!
  On a plus qu'à parcourir les lignes où il y a au moins une valeur
 * ***************************************************************************************/

if (count($tab_mod)):
    ?>
    <div class="uk-panel">
    <table class="uk-table uk-table-striped jlei_tarifs">
        <colgroup>
            <col width="33%">
            <col width="33%">
            <col width="33%">
        </colgroup>
        <thead>
            <tr>
                <th scope="col"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_TARIFS_TITRE', 'INTITULE','plugin-sit'); ?></th>
                <th scope="col"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_MINI', 'MINI','plugin-sit'); ?></th>
                <th scope="col"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_MAXI', 'MAXI','plugin-sit'); ?></th>
            </tr>
        </thead>
        <tbody>
        <?php //print_r($tab_mod);
        foreach ($tab_mod as $val) :
            ?>
                <tr>
                    <th class="jlei_tarifs_intit" scope="row"><?= $val['nommod']; ?></th>
                    <?php if (isset($val['seule']) && !empty($val['seule'])): ?>
                        <td class="uk-text-center jlei_tarifs_valeur"><?= $val['seule']; ?></td>
                        <td class="uk-text-center jlei_tarifs_valeur"> - </td>
                    <?php endif; ?>
                    <?php if ((isset($val['mini']) && !empty($val['mini'])) || (isset($val['maxi']) && !empty($val['maxi']))): ?>
                        <td class="uk-text-center jlei_tarifs_valeur"><?php
                            if (isset($val['mini']) && !empty($val['mini']))
                                echo $val['mini'];
                            else
                                echo '-';
                            ?></td>
                        <td class="uk-text-center jlei_tarifs_valeur"><?php
                            if (isset($val['maxi']) && !empty($val['maxi']))
                                echo $val['maxi'];
                            else
                                echo '-';
                            ?></td>
                    <?php endif; ?>
                </tr>
       <?php  endforeach; ?>
        </tbody>
    </table>
    </div>
<?php endif; } ?>
