<?php
/**
 * Template d'affichage composant socialbox facebook
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/gabarits
 *
 * @version 3.3
 *
 */

$liens = array();

if(BridgeBlockService::textBlockDataIsNotEmpty($fiche, $blockData)) {
    foreach($blockData->content->fields as $index=>$section) {
        if(is_array($section->items ) && count($section->items ) > 0) {
            foreach($section->items as $indexItem=>$item) {
                if(is_array($item->subItems) && count($item->subItems) > 0) {
                    foreach ($item->subItems as $subitem) {
                        if(!empty($subitem))
                            $liens[] = $subitem;
                    }
                }
            }
        }
    }
}
// $lien = BridgeBlockService::extractBlockFirstTextValue ( $blockData);

$typeVideo = '';
if(count($liens) > 0):
    foreach($liens as $lien):

        if (mb_strpos($lien, 'vimeo')) {
            $typeVideo = 'VIMEO';
        } elseif (mb_strpos($lien, 'youtu')) {
            $typeVideo = 'YOUTUBE'; // $lien = 'https://www.youtube.com/watch?v=LZITM0KQBBk';
        } elseif (mb_strpos(strtolower($lien), 'mp4')) {
            $typeVideo = 'MP4';
        } elseif (mb_strpos(strtolower($lien), 'webm')) {
            $typeVideo = 'WEBM';
        }
        $idRand = BridgeBlockService::generateRandomString();

        ?>



        <?php if(!empty($typeVideo)): ?>
        <script src="https://cdn.plyr.io/3.7.2/plyr.js"></script>
        <link rel="stylesheet" href="https://cdn.plyr.io/3.7.2/plyr.css" />
        <?php
            switch($typeVideo) {
                case 'VIMEO': ?>
                    <div class="plyr__video-embed bridge_video" id="bridge-player-<?= $idRand ?>">
                        <iframe
                                src="<?= $lien ?>?loop=false&amp;byline=false&amp;portrait=false&amp;title=false&amp;speed=true&amp;transparent=0&amp;gesture=media"
                                allowfullscreen
                                allowtransparency
                                allow="autoplay"
                                style="width:100%;"
                        ></iframe>
                    </div>
            <?php break;
                case 'YOUTUBE': ?>
                    <div class="plyr__video-embed bridge_video" id="bridge-player-<?= $idRand ?>">
                        <iframe
                                src="<?= $lien ?>?origin=https://plyr.io&amp;iv_load_policy=3&amp;modestbranding=1&amp;playsinline=1&amp;showinfo=0&amp;rel=0&amp;enablejsapi=1"
                                allowfullscreen
                                allowtransparency
                                allow="autoplay"
                                style="width:100%;"
                        ></iframe>
                    </div>
            <?php break;
                case 'MP4': ?>
                    <video class="bridge_video" id="bridge-player-<?= $idRand ?>" playsinline controls> <?php /* data-poster="/path/to/poster.jpg" */ ?>
                        <source src="<?= $lien ?>" type="video/mp4" />
                    </video>

                    <?php break;
                case 'WEBM': ?>
                    <video class="bridge_video" id="bridge-player-<?= $idRand ?>" playsinline controls> <?php /* data-poster="/path/to/poster.jpg" */ ?>
                        <source src="<?= $lien ?>" type="video/webm" />
                    </video>
                    <?php break;
            } ?>



            <script type="text/javascript">
                const player_<?= $idRand ?> = new Plyr('#bridge-player-<?= $idRand ?>');
            </script>
        <?php endif; ?>
    <?php endforeach; ?>

<?php endif; ?>
