<?php
/**
 * Template d'affichage du graphique de tracé altimétrique dans une page fiche détaillée - modèle fiche itinéraire
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks-ficheitineraire
 *
 * @version 3.3.8
 *
 */

$randomId = BridgeUtils::generateRandomString(10);
$elevationData = $blockData->elevationData;

$valuesBackgroundColor = '#707070';
$valuesBorderColor = '#707070';
if(isset($blockData->parameters) && is_object($blockData->parameters) && isset($blockData->parameters->valuesBackgroundColor))
    $valuesBackgroundColor = $blockData->parameters->valuesBackgroundColor;
if(isset($blockData->parameters) && is_object($blockData->parameters) && isset($blockData->parameters->valuesBorderColor))
    $valuesBorderColor = $blockData->parameters->valuesBorderColor;


BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_elevation_data', $ficheData);

// print_r($blockData);

if (isset($elevationData) && is_object($elevationData) && isset($elevationData->graph) && !empty($elevationData->graph)): ?>
    <?php $graph = $elevationData->graph ; //print_r($graph); ?>

        <div class="graph uk-text-center">
            <?php /* <h3 class="uk-margin-remove-top"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_PROFIL_ALTIMETRIQUE', 'Profil altimétrique','plugin-sit') ?></h3> */ ?>
            <div style="position:relative; width:100%;" id="container-coupetopo-<?= $randomId ?>">
                <canvas id="coupetopo-<?= $randomId ?>"></canvas>
                <button id="fsButtonCoupetopo-<?= $randomId ?>" class="bridgeFsButton" title="<?= BridgeCmsAbstractLayer::esc_attr(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_PLEIN_ECRAN', 'Plein écran', 'plugin-sit)) ?>')) ?>"></button>
            </div>
            <?php //print_r($chart); ?>
            <script type="text/javascript">
                // <!--
                var ctx<?= $randomId ?> = document.getElementById("coupetopo-<?= $randomId ?>").getContext("2d");;
                jQuery(document).ready(function() {
                    // KML et elevation : mise en place
                    var data = { graph: JSON.parse('<?php echo json_encode($graph) ; ?>') };
                    var distanceTotale = data.graph[data.graph.length -1].x;
                    var altitudeMax = 0;
                    var altitudeMin = 10000;
                    for(idx in data.graph) '
                        if(data.graph[idx].y > altitudeMax) {
                            altitudeMax = data.graph[idx].y;
                        }
                        if(data.graph[idx].y < altitudeMin) {
                            altitudeMin = data.graph[idx].y;
                        }
                    }

                    // Graduation en centaines de mètres
                    window.tempGraduation = 5;
                    if(distanceTotale > 6000) {
                        window.tempGraduation  = 10;
                    }
                    if(distanceTotale > 11000) {
                        window.tempGraduation  = 20;
                    }
                    if(distanceTotale > 20000) {
                        window.tempGraduation  = 50;
                    }
                    if(distanceTotale > 50000) {
                        window.tempGraduation  = 100;
                    }

                    var tablabels = [];
                    window.tabGraduations = [];
                    var tabvalues = [];
                    var letemp ;
                    var tempMetres ;
                    for(var i=0; i< data.graph.length; i++) {
                        tempMetres = parseInt(data.graph[i].x);
                        letemp = tempMetres;
                        letemp = parseInt(data.graph[i].x);
                        letemp = Math.round(letemp / 100) * 100;
//                        letemp = letemp + '';
//                        letemp = letemp.replace('.',',');

                        tabvalues.push(data.graph[i].y );
                        if(tempMetres % tempGraduation === 0) {
                            tablabels.push(letemp);
                            window.tabGraduations.push(letemp)
                        } else {
                            tablabels.push('');
                        }
                    }

                    const graphData = {
                        labels: tablabels,
                        datasets: [
                            {
                                // label: '<?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_PROFIL_ALTIMETRIQUE', 'Profil altimétrique','plugin-sit'); ?>',
                                data: tabvalues
//                                fill: true,
//                                borderColor: '<?= $valuesBorderColor ?>',
//                                backgroundColor: '<?= $valuesBackgroundColor ?>',
                            }
                        ]
                    };

                    //var ctx = document.getElementById("profil-alti").getContext("2d");
                    const graphConfig = {
                        type: 'line',
                        data: graphData,
                        options: {
                            responsive: true,
                            maintainAspectRatio: true,
                            aspectRatio: (16/9),
                            plugins: {
                                title: {
                                    display: false,
                                    text: '<?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_PROFIL_ALTIMETRIQUE', 'Profil altimétrique','plugin-sit'); ?>'
                                },
                                legend: {
                                    display: false
                                },
                                tooltip: {
                                    callbacks: {
                                        title: function(context) {
                                            let label = '<?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ALTITUDE', 'Altitude','plugin-sit'); ?>';
                                            return label;
                                        },
                                        label: function(context) {
                                            let label = context.dataset.label || '';

                                            if (context.parsed.y !== null) {
                                                label = context.parsed.y + ' m';
                                            }
                                            return label;
                                        }
                                    }
                                }
                            },
                            interaction: {
                                mode: 'index',
                                intersect: false
                            },
                            elements: {
                                line: {
                                    tension: 0.5,
                                    fill: true,
                                    borderColor: '<?= $valuesBorderColor ?>',
                                    backgroundColor: '<?= $valuesBackgroundColor ?>',
                                },
                                point: {
                                    pointStyle: 'false'
                                }
                            },
                            scales: {
                                x: {
                                    display: true,
                                    grid: {
                                        display: true,
                                        drawOnChartArea: true,
                                        drawTicks: true,
                                    },
                                    title: {
                                        display: true,
                                        text: '<?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_DISTANCE', 'Distance','plugin-sit'); ?>'
                                    },
                                    ticks: {
                                        // For a category axis, the val is the index so the lookup via getLabelForValue is needed
                                        callback: function(val, index) {
                                            var letemp = parseInt(val * 100);
                                            letemp = Math.round(letemp / 100) ;
                                            letemp = letemp / 10;
                                            letemp = letemp + '';
                                            letemp = letemp.replace('.',',');
                                            letemp += ' km';
                                            return letemp;
                                            // N'afficher que 10 labels
                                            /// return (index % 10 === 0) ? this.getLabelForValue(val) : '';
                                            return (index % window.tempGraduation === 0) ? letemp : '';
                                        }
                                    }
                                },
                                y: {
                                    min: Math.round(Math.floor(altitudeMin * 0.0070 ) * 100), // arrondit à 100m au-dessous du min diminué de 30%
                                    max: Math.round(Math.ceil(altitudeMax * 0.0120 ) * 100), // arrondit à 100m au-dessus du max augmenté de 20%
                                    display: true,
                                    title: {
                                        display: true,
                                        text: '<?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_ALTITUDE', 'Altitude','plugin-sit'); ?>'
                                    },
                                    ticks: {
                                        // For a category axis, the val is the index so the lookup via getLabelForValue is needed
                                        callback: function (val, index) {
                                            return val + ' m';
                                        }
                                    }
                                }
                            }
                        },
                    };
                    window.elevationChart<?= $randomId ?> = new Chart(ctx<?= $randomId ?>, graphConfig);

                   jQuery(window).resize(function() {
                       window.elevationChart<?= $randomId ?>.resize();
                   });

                   jQuery('#fsButtonCoupetopo-<?= $randomId ?>').click(function() {
                       const container = document.getElementById('container-coupetopo-<?= $randomId ?>');
                       bridgeToggleFullscreen(container, this);
                   });

                    const el = document.getElementById('container-coupetopo-<?= $randomId ?>');
                    el.addEventListener("fullscreenchange", function() {
                        if (document.fullscreenElement) {
                            jQuery('#fsButtonCoupetopo-<?= $randomId ?>').addClass('bridgeIsFullScreen');
                            jQuery('#fsButtonCoupetopo-<?= $randomId ?>').attr('title', '<?= BridgeCmsAbstractLayer::esc_js(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_REDUIRE','Réduire', 'plugin-sit)) ?>')) ?>');
                        } else {
                            jQuery('#fsButtonCoupetopo-<?= $randomId ?>').removeClass('bridgeIsFullScreen');
                            jQuery('#fsButtonCoupetopo-<?= $randomId ?>').attr('title', '<?= BridgeCmsAbstractLayer::esc_js(BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_PLEIN_ECRAN','Plein écran', 'plugin-sit)) ?>')) ?>');
                        }
                    });
                });

            // -->

            </script>
        </div>

    <?php endif; ?>

<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_elevation_data', $ficheData); ?>
