<?php // Exemple : Dispos bridge - https://bridgesrv-grandvaux.pylot.fr/product/getDispos?productCode=339002702
$tmpOptions = BridgeUtils::getBridgeCredentials();
$bridgeParameters->url_bridge = $tmpOptions->urlBridge;
$json = file_get_contents( $bridgeParameters->url_bridge . '/product/getDispos?productCode=' . $fiche->productCode );
$dispo2synt = json_decode( $json );
$doDisplay = true;
if ( isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug'] == "DISPOS" ) {
    $doDisplay = true;
}

if ( $doDisplay && isset( $dispo2synt ) && is_array($dispo2synt) && count( $dispo2synt ) > 0 ): ?>


    <div id="dispos" class="bridge-calendar">


    <div class="uk-grid-divider" uk-grid>
        <div class="uk-width-3-4@m uk-width-1-1@s">
        <div class="datesheures composant-dates-calendrier ">
          <?php /**********les disponibilites*************/ ?>
            <section class="main">
                <div class="custom-calendar-wrap">
                    <div id="custom-inner" class="custom-inner">
                        <div class="custom-header clearfix">
                            <nav>
                                <span id="custom-prev" class="custom-prev"><i class="fa fa-arrow-left"></i></span>
                                <span id="custom-next" class="custom-next"><i class="fa fa-arrow-right"></i></span>
                            </nav>
                            <h4 class="custom-calendar-title"><span id="custom-month" class="custom-month"></span> <span id="custom-year" class="custom-year"></span></h4>
                        </div>
                        <div id="calendar" class="fc-calendar-container"></div>
                    </div>
                </div>
                <span class="datedemaj uk-text-center uk-width-1-1">Dernière mise à jour le <?php echo date('d/m/Y',strtotime(substr($fiche->maxUpdate->date,0,10))); ?></span>
            </section>

          <script type="text/javascript">
              // <!--
            jQuery(function() {
                  <?php
                      $i=0;
                      $strDispos = array();
                      foreach($dispo2synt as $key => $ladispo) {
                            $dateDate = date_create_from_format('Y-m-d', $ladispo->date);
                            $dateTxt = $dateDate->format('m-d-Y');
                            $content = ($ladispo->state == 1) ? BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_DISPONIBLE','Disponible', 'plugin-sit') : BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_NON_DISPONIBLE', 'Non disponible', 'plugin-sit') ;
                            $strDispos[] = "\"$dateTxt\": { statut: $ladispo->state, content:\"$content\"}";
                      }
                  ?>
                var dncdispo = {
                    <?= implode(',', $strDispos); ?>
                };

                var transEndEventNames = {
                    'WebkitTransition' : 'webkitTransitionEnd',
                    'MozTransition' : 'transitionend',
                    'OTransition' : 'oTransitionEnd',
                    'msTransition' : 'MSTransitionEnd',
                    'transition' : 'transitionend'
                },
                transEndEventName = transEndEventNames[ Modernizr.prefixed( 'transition' ) ],
                    $wrapper = jQuery( '#custom-inner' ),
                $calendar = jQuery( '#calendar' ),
                cal = $calendar.calendario( {
                    onDayClick : function( $el, $contentEl, dateProperties ) {
                        if( $contentEl.length > 0 ) {
                            showEvents( $contentEl, dateProperties );
                        }
                    },
                    weeks : [ '<?= BridgeCmsAbstractLayer::__('SUNDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MONDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('TUESDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('WEDNESDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('THURSDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('FRIDAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('SATURDAY','plugin-sit') ?>' ],
                    weekabbrs : [ '<?= BridgeCmsAbstractLayer::__('SU','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MO','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('TU','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('WE','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('TH','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('FR','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('SA','plugin-sit') ?>' ],
                    months : [ '<?= BridgeCmsAbstractLayer::__('JANUARY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('FEBRUARY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MARCH','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('APRIL','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('JUNE','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('JULY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('AUGUST','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('SEPTEMBER','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('OCTOBER','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('NOVEMBER','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('DECEMBER','plugin-sit') ?>' ],
                    monthabbrs : [ '<?= BridgeCmsAbstractLayer::__('JAN','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('FEB','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MAR','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('APR','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('MAY','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('JUN','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('JUL','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('AUG','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('SEP','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('OCT','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('NOV','plugin-sit') ?>', '<?= BridgeCmsAbstractLayer::__('DEC','plugin-sit') ?>' ],
                    caldata : dncdispo,
                    displayWeekAbbr : true,
                    consult : '<?= BridgeCmsAbstractLayer::__('Fermé','plugin-sit') ?>',
                    fermé : '<?= BridgeCmsAbstractLayer::__('Fermé','plugin-sit') ?>',
                    complet : '<?= BridgeCmsAbstractLayer::__('Fermé','plugin-sit') ?>',
                    dispo : '<?= BridgeCmsAbstractLayer::__('Ouvert','plugin-sit') ?>'
                } ),
                $month = jQuery( '#custom-month' ).html( cal.getMonthName() ),
                $year = jQuery( '#custom-year' ).html( cal.getYear() );

            jQuery( '#custom-next' ).on( 'click', function() {
                cal.gotoNextMonth( updateMonthYear );
            } );
            jQuery( '#custom-prev' ).on( 'click', function() {
                cal.gotoPreviousMonth( updateMonthYear );
            } );

            function updateMonthYear() {
                $month.html( cal.getMonthName() );
                $year.html( cal.getYear() );
            }

            // just an example..
            function showEvents( $contentEl, dateProperties ) {
                hideEvents();
                var $events = jQuery( '<div id="custom-content-reveal" class="custom-content-reveal"><h4>' + dateProperties.monthname + ' ' + dateProperties.day + ', ' + dateProperties.year + '</h4></div>' ),
                $close = jQuery( '<span class="custom-content-close"></span>' ).on( 'click', hideEvents );
                $events.append( $contentEl.html() , $close ).insertAfter( $wrapper );
                setTimeout( function() {
                    $events.css( 'top', '0%' );
                }, 25 );
            }
            function hideEvents() {

                var $events = jQuery( '#custom-content-reveal' );
                if( $events.length > 0 ) {
                    $events.css( 'top', '100%' );
                    //Modernizr.csstransitions ? $events.on( transEndEventName, function() { jQuery( this ).remove(); } ) : $events.remove();
                }
            }

        });
            // -->
        </script>
    </div>
            </div>
        <div class="legende uk-width-1-4@m uk-hidden-@s uk-text-left uk-flex uk-flex-middle">

          <ul class="uk-list uk-text-left">
            <li class="dispo statu1">
                <i class="fas  fa-circle"></i> <?= BridgeCmsAbstractLayer::__('DISPONIBLE','plugin-sit'); ?>
            </li>
            <li class="indispo statu2 ">
                <i class="fas  fa-circle"></i> <?= BridgeCmsAbstractLayer::__('COMPLET','plugin-sit'); ?>

            </li>
            <li class="indispo statu0">
                <i class="fas  fa-circle"></i> <?= BridgeCmsAbstractLayer::__('NOUS_CONSULTER','plugin-sit'); ?>
            </li>

              <li class="consulter statu3">
                <i class="fas  fa-circle"></i> <?= BridgeCmsAbstractLayer::__('Fermé','plugin-sit'); ?>
            </li>
          </ul>
        </div>
</div>
<?php endif; ?>
