<?php
/**
 * Template d'affichage des blocks personnalisés dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.1.6
 *
 */

$blocks = $fiche->ficheBlocks->custom;

// Signets pour savoir quand insérer des séparateurs
$previousGroupId = -1;
$previousBlockId = -1;

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_custom_blocks');

if (isset($blocks) && count($blocks) > 0) : ?>
    <div class="onglets">
        <?php foreach ($blocks as $blockData) : ?>
            <?php if(BridgeBlockService::blockIsNotEmpty($fiche, $blockData)): ?>
                <?php if (isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug'] == "X") : ?>
                    <code>
                        <pre><?php print_r($blockData); ?></pre>
                    </code>
                <?php endif; ?>

                <section id="custom-block-<?= $blockData->blockId ?>" class="custom-block uk-section <?= ($blockData->cssClass!='') ? $blockData->cssClass : '' ; ?>">
                    <div class="uk-container uk-container-center">
                    <?php $icon = ''; ?>
                    <?php // intitulé de groupe ?>
                    <?php if (isset($blockData->wpGroup) && is_object($blockData->wpGroup) && (!empty($blockData->wpGroup->label)  || !empty($blockData->wpGroup->wpGroupIcon)) && $previousGroupId != $blockData->wpGroup->id): ?>
                        
                        <?php if(!empty($blockData->wpGroupIcon)): ?>
                            <?php $icon = BridgeUtils::renderIcon($blockData->wpGroupIcon); ?>
                        <?php endif; ?>

                        <h2 class="uk-width-1-1 uk-text-center block-group-label"><?= $icon . $blockData->wpGroup->label ?></h2>
                       
                        <?php $previousBlockId = -1 ; // Désactive le séparateur de block comme c'est le premier ?>
                    <?php endif; ?>
                    <?php if (isset($blockData->wpGroup) && is_object($blockData->wpGroup) && (!empty($blockData->wpGroup->label)  || !empty($blockData->wpGroup->wpGroupIcon))): ?>
                        <div uk-grid>
                    <?php endif; ?>


                    <?php // intitulé de block ?>
                    <div class="content-block <?= BridgeBlockService::renderSizeBlock($blockData); ?> ">
                    
                        <?php if (! empty($blockData->blockLabel) || !empty($blockData->blockIcon)) : ?>
                            <?php if(!empty($blockData->blockIcon)): ?>
                                <?php $icon = BridgeUtils::renderIcon($blockData->blockIcon); ?>
                            <?php endif; ?>
                            <h3 class="uk-width-1-1 uk-text-center block-label"><?= $icon ?><?= $blockData->blockLabel ?></h3>
                        <?php endif; ?>
                        

                        <?php // On initialise la grille des sous-block et composants ?>
                        <div uk-grid>
                            <?php if (isset($blockData) && isset($blockData->isGabarit) && $blockData->isGabarit === true && !empty($blockData->bridgeComponent)): ?>
                            <?php print_r($blockData->wpGroup); ?>
                            <div class="containerblockSection <?= BridgeBlockService::renderSizeBlock($blockData->wpGroup).' '.$blockData->wpGroup->cssClass; ?>">
                               <?php  include BridgeUtils::bridge_locate_template('templates-bridge/fiche/gabarits/' . $blockData->bridgeComponent . '.php'); ?>
                            </div>
                            <?php else: ?>
                                     <?= BridgeBlockService::renderBlockHtml($blockData) ?>
                            <?php endif; ?>
                            <?php $previousBlockId = $blockData->blockId; ?>
                        </div>
                    </div>

                    <?php // On ferme le groupe // intitulé de groupe ?>
                    <?php if (isset($blockData->wpGroup) && is_object($blockData->wpGroup) && (!empty($blockData->wpGroup->label)  || !empty($blockData->wpGroup->wpGroupIcon))): ?>
                        </div>
                        <?php $previousGroupId = $blockData->wpGroup->id; ?>
                    <?php else: ?>
                        <?php $previousGroupId = 0; ?>
                    <?php endif; ?>


                        
                    </div>
                </section>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_custom_blocks'); ?>


<style type="text/css">
    .containerblockSection {
        display:flex;
    }
    .containerblockSection h4 {
        flex-basis: 50%;
        text-align: right;
        padding-right: 1em;
        margin:0;
    }
    .containerblockSection h4+.blockSection {
        flex-basis: 50%;
        padding-left: 1em;
        /*
        text-align: right;
        padding-right: 2em;
        margin:0; */
    }

    .custom-block.mosl-highlight > div { background-color:#333; color: #FFF; padding-bottom:2em;}
    .custom-block.mosl-highlight .uk-h1,
    .custom-block.mosl-highlight h1,
    .custom-block.mosl-highlight .uk-h2,
    .custom-block.mosl-highlight h2,
    .custom-block.mosl-highlight .uk-h3,
    .custom-block.mosl-highlight h3,
    .custom-block.mosl-highlight .uk-h4,
    .custom-block.mosl-highlight .h4,
    .custom-block.mosl-highlight .uk-h5,
    .custom-block.mosl-highlight h5
    { color: #FFF;}

    .custom-block.mosl-highlight .containerblockSection { display: block; }
    .custom-block.mosl-highlight .containerblockSection h4 { margin-top:10px; margin-bottom: 20px; text-align: left; }



</style>