<?php
/**
 * Template d'affichage du block photos dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_photos');

$images = BridgeBlockService::extractPhotos($fiche->ficheBlocks, 'photos-medias');
?>
<?php if(count($images) > 0): ?>
<div id="galerie" class="uk-position-relative uk-visible-toggle" tabindex="-1" uk-slideshow="animation: push;autoplay: true">

    <ul class="uk-slideshow-items" uk-lightbox="animation: scale">
		<?php foreach($images as $image): ?>
		<li>
            <a href="<?= $image->url ;?>" data-caption="<?= $image->caption; ?>">
				<img data-src="<?= BridgeUtils::getResizeImageLink($image->url, "tronq", "800", "500", "60") ?>" alt="" uk-cover uk-img>
            </a>
			<?php if(!empty($image->caption)): ?>
				<div class="uk-position-bottom uk-position-medium uk-text-center uk-light">
					<p class="uk-margin-remove"><?= $image->caption; ?></p>
				</div>
			<?php endif; ?>
        </li>
		<?php endforeach; ?>
    </ul>

    <div class="uk-light">
        <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous uk-slideshow-item="previous"></a>
        <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next uk-slideshow-item="next"></a>
    </div>

</div>
		
<?php endif; ?>

<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_photos'); ?>
