<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc réseaux sociaux
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */
BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_reseaux_sociaux');
if(BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "reseaux-sociaux")): ?>
    <div class="reseaux uk-text-center  <?= (string) $fiche->ficheBlocks->{'reseaux-sociaux'}->cssClass ?>">

        <div class="" uk-grid>
            <?php
            $blocks_object = $fiche->ficheBlocks;
            $block_name = "reseaux-sociaux";
            if(is_object($blocks_object) && property_exists($blocks_object, $block_name)) {
                $renderBlockData = $blocks_object->$block_name;
                if ( isset( $renderBlockData ) && is_object($renderBlockData->content) && !empty($renderBlockData->content->fields)) {
                    foreach($renderBlockData->content->fields as $index=>$section) {
                        foreach($section->items as $indexItem=>$item) {
                            // On récupère l'icon du titre
                            if (isset($item->iconClass) && is_object($item->iconClass) && !empty($item->iconClass->name)):
                                $itemIcon = BridgeUtils::renderIcon($item->iconClass);
                            endif;
                            // On récupère l'icon des éléments enfants qu'on affichera en mode column ou tags
                            if (isset($section->itemsIcons->name) && $section->itemsIcons->name != ''):
                                $rendericon = BridgeUtils::renderIcon($section->itemsIcons);
                            endif;

                            // Si l'élément inclu une image on l'ajoute
                            if (isset($item->image) && $item->image != ''):
                                $tmpOptions = BridgeUtils::getBridgeCredentials();
                                $urlBridge = $tmpOptions->urlBridge;
                                $urlImg = $urlBridge . '/media/' . $item->image;
                                if(BridgeBlockService::bridgeIsSvg($urlImg))
                                    $rendericon = BridgeBlockService::bridgeInlineSvg($urlImg);
                                else
                                    $rendericon = '<img src="' . $urlBridge . '/media/' . $item->image . '" height="30" alt="' . $item->label . '" title="' . $item->label . '" uk-tooltip />';
                            else :
                                if (!empty($itemIcon)):
                                    $rendericon = $itemIcon;
                                endif;
                                if (!empty($item->label)):
                                    $resSubItemLabel = '<span class="itemLabel"> ' . $item->label . '</span>';
                                endif;
                            endif;
                            ?>
                                <?php if(isset($item->textValue)): ?>
                                <div>
                                    <?php $link = str_replace('http://https://', 'https://', 'http://' . $item->textValue) ; ?>
                                    <?php $link = str_replace('http://http://', 'http://', 'http://' . $link) ; ?>

                                    <a href="<?= $link ?>" target="_blank">
                                        <?= $rendericon ?>
                                    </a>
                                </div>
                                <?php endif; ?>
<?php

                        }
                    }

                }
            }

            ?>
        </div>
    </div>

<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_reseaux_sociaux') ; ?>
