<?php
/**
 * Template d'affichage d'une page fiche détaillée - modèle de fiche pour Moselle Attractivité
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche-mosl/fiche-mosl.php
 *
 * @version 3.3.0
 *
 */

$images = BridgeBlockService::extractPhotos($fiche->ficheBlocks, 'photos-medias');
$htmlTitre = BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'titre-de-la-fiche');

// On traite la donnée block Custom poru l'avoir hiérarchisée
$hierarchicalCustomBlocks = array();
if(isset($fiche) && is_object($fiche) && !empty($fiche->ficheBlocks) && isset($fiche->ficheBlocks->custom) && count($fiche->ficheBlocks->custom) > 0) {
    $hierarchicalCustomBlocks = BridgeBlockService::prepareCustomBlocksDisplay($fiche, $fiche->ficheBlocks->custom, $ficheParameters);
}

?>
<div class="bridge-fiche fiche-mosl uk-width-1-1" id="detailfiche" data-dnc-produit="<?= $fiche->productCode; ?>" data-product-id="<?= $fiche->productCode; ?>">
    <header class="bridge-fiche-mosl-hero">
        <div class="uk-container uk-container-center">
            <section class="bridge-mosl-header">
                <div uk-grid class="uk-flex-middle">
                    <div class="uk-width-1-2@m">
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-1.php'); ?>
                        <?php /* if($fiche->typeName!='') : ?>
                            <span class=""><?= $fiche->typeName; ?></span>
                        <?php endif; */ ?>
                        <h1><?= $htmlTitre ?></h1>
                        <span class="localisation">

                            <i class="fa fa-map-marker"></i> <?= $fiche->city; ?>
                        </span>
                        <div class="actions uk-flex">
                            <div class="uk-width-1-2">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/mosl/blocks-mosl/telephone-s-de-contact.php'); ?>
                            </div>
                            <div class="uk-width-1-2">
                                <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/mosl/blocks-mosl/lien-de-reservation-en-ligne.php'); ?>
                            </div>
                        </div>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/mosl/blocks-mosl/extract-avis-tripadivsor.php'); ?>
                    </div>
                    <div class="uk-width-1-2@m">
                        <?php if (count($images) > 1) : ?>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header') ; ?>
                        <div class="uk-position-relative uk-visible-toggle" tabindex="-1" uk-slideshow="animation: fade;autoplay:true;">
                            <ul class="uk-slideshow-items">
                                <?php $i = 0;
                                foreach ($images as $image) : $i++; ?>
                                    <li>
                                        <img src="<?= BridgeUtils::getResizeImageLink($image->url, "tronq", "800", "600", "60") ?>"
                                             alt="<?php BridgeCmsAbstractLayer::esc_html($image->caption) ?>" uk-cover>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                            <div class="uk-light">
                                <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous uk-slideshow-item="previous"></a>
                                <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next uk-slideshow-item="next"></a>
                            </div>
                        </div>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header') ; ?>
                    <?php else: ?>
                        <?php $style = ""; ?>
                        <?php if (!empty($images)) $style = 'background:url(' . BridgeUtils::getResizeImageLink($images[0]->url, "tronq", "800", "600", "60") . ') no-repeat center center; background-size:cover;'; ?>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header') ; ?>
                        <header id="chapeau" class="uk-text-center uk-position-relative" style="<?= $style ?>">
                                <div class="uk-position-center uk-position-small uk-text-center uk-light">
                                    <h1><?= $htmlTitre ?></h1>
                                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
                                </div>
                        </header>
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header') ; ?>
                    <?php endif; ?>
                    </div>
                </div>
            </section>
            <section class="bridge-mosl-descriptif uk-margin-large">
                <div uk-grid class="uk-flex-middle">
                    <div class="uk-width-1-4@m">
                        <img src="<?= BridgeUtils::getResizeImageLink($images[1]->url, "tronq", "800", "600", "60") ?>" alt="<?php BridgeCmsAbstractLayer::esc_html($images[1]->caption) ?>" />
                    </div>
                    <div class="uk-width-3-4@m">

                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/mosl/blocks-mosl/descriptif.php'); ?>

                    </div>
                </div>
            </section>
        </div>
    </header>
    <div class="bridge-fiche-mosl-menu uk-section uk-section-muted uk-padding-remove uk-margin-large" uk-sticky>
        <ul class="uk-flex-center bridge-fiche-sommaire uk-subnav" uk-scrollspy-nav="closest: li; scroll: true">
            <?php if (count($hierarchicalCustomBlocks) > 0) : ?>
                <?php foreach ($hierarchicalCustomBlocks as $onglet) : ?>
                    <?php if($onglet->title!=''): ?>
                        <li><a href="#custom-block-<?= $onglet->blockId ?>" uk-scroll><?= $onglet->title; ?></a></li>
                    <?php endif; ?>
                <?php endforeach; ?>
            <?php endif; ?>
            <li><a href="#horaires" uk-scroll>Les horaires</a></li>
            <li><a href="#comment-venir" uk-scroll>Comment venir ?</a></li>
            <li><a href="#contact" uk-scroll>Contacs</a></li>
            <li><a href="#commentaires" uk-scroll>Commentaires</a></li>
            <li><a href="#reservation" class="uk-button uk-button-primary">Réserver</a></li>
        </ul>
    </div>
    <main class="bridge-fiche-mosl-menu uk-content">
        <?php if (count($hierarchicalCustomBlocks) > 0) : ?>
              <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/mosl/blocks-mosl/onglets.php'); ?>
        <?php endif; ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/mosl/blocks-mosl/horaires.php'); ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/mosl/blocks-mosl/comment-venir.php'); ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/mosl/blocks-mosl/contact.php'); ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/mosl/blocks-mosl/commentaires.php'); ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-4.php'); ?>
    </main>
</div>
