<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc infos supplémentaires 2
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_infos_2');
if(BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'infos-supplementaires-2')):?>
    <div class="infos-supplementaires-2 descriptif <?= (string) $fiche->ficheBlocks->{'infos-supplementaires-2'}->cssClass ?>">
        <?php if(isset($fiche->ficheBlocks->{'infos-supplementaires-2'}->blockLabel) && !empty($fiche->ficheBlocks->{'infos-supplementaires-2'}->blockLabel)): ?>
            <span class="block-label uk-h2"><?= $fiche->ficheBlocks->{'infos-supplementaires-2'}->blockLabel ?></span>
        <?php endif; ?>
        <?php $component = BridgeBlockService::getBlockComponent($fiche, $fiche->ficheBlocks, 'infos-supplementaires-2' ); ?>
        <?php if (!empty($component)): ?>
            <?php $blockData = $fiche->ficheBlocks->{'infos-supplementaires-2'}; ?>
            <?php  include BridgeUtils::bridge_locate_template('templates-bridge/fiche/gabarits/' . $component . '.php'); ?>
        <?php else: ?>
            <?= BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'infos-supplementaires-2') ?>
        <?php endif; ?>
    </div>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_infos_2') ; ?>
