<?php
/**
 * Template d'affichage d'une page fiche détaillée - modèle fiche 3
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche
 *
 * @version 3.3.25
 *
 */


$images = BridgeBlockService::extractPhotos($fiche->ficheBlocks, 'photos-medias');

// On traite la donnée block Custom poru l'avoir hiérarchisée
$hierarchicalCustomBlocks = array();
if(isset($fiche) && is_object($fiche) && !empty($fiche->ficheBlocks) && isset($fiche->ficheBlocks->custom) && count($fiche->ficheBlocks->custom) > 0) {
    $hierarchicalCustomBlocks = BridgeBlockService::prepareCustomBlocksDisplay($fiche, $fiche->ficheBlocks->custom, $ficheParameters);
}
$htmlTitre = BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'titre-de-la-fiche');

?>
<div id="ficheproduit" class="bridge-fiche fiche-otsr ficheproduit" data-product-id="<?= $fiche->productCode; ?>" data-dnc-produit="<?= $fiche->productCode; ?>">
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_header') ; ?>
    <header id="chapeau" class="uk-text-center uk-position-relative" style="background-image:url('<?= BridgeUtils::getResizeImageLink($images[0]->url, "tronq", "1600", "500", "60") ?>');height:500px;background-size:cover">
        <div class="overlay-chapeau"></div>
        <div class="uk-position-center uk-position-small uk-text-center uk-light">
            <h1><?= $htmlTitre ?></h1>
            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/classements-labels.php'); ?>
        </div>
    </header>
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_header') ; ?>

    <div id="summary" class="uk-position-relative uk-position-zindex">
        <div class="uk-container uk-container-center">
            <?php if($images[0]->caption!='') :?>
                <div class="credit uk-width-1-1 uk-text-center">&copy; <?= $images[0]->caption; ?></div>
            <?php endif; ?>
            <div id="menuSIT">
                <div class="uk-text-center uk-light breadcrumbs">
                    <?php // <?= BridgeUtils::BridgeBreadcrumbs($delimiter = '/',$home = '<i class="fa-home fa"></i>', $showCurrent = 1,$before = '<span class="current">',$after = '</span>',true); ?>
                </div>
                <div id="menuficheSIT">
                    <ul id="tabs-sit-menu" uk-tab="connect: #tabs-sit;animation: uk-animation-slide-left-medium, uk-animation-slide-right-medium;" class="uk-child-width-expand@m uk-child-width-1-3 uk-tab">
                        <li>
                            <a href="#">
                                <?php switch(pll_current_language()):
                                    case 'fr':
                                        echo 'Informations';
                                    break;
                                     case 'en':
                                        echo 'Information';
                                    break;
                                     case 'de':
                                        echo 'Informationen';
                                    break;
                                     case 'it':
                                        echo 'Informazioni';
                                    break;
                                     case 'es':
                                        echo 'Informaciónes';
                                    break;
                                endswitch; ?>
                            </a>
                        </li>
                        <?php if (count($hierarchicalCustomBlocks) > 0) : ?>
                            <?php foreach ($hierarchicalCustomBlocks as $key=>$onglet) : if($key == 0) continue;?>
                               <li><a href="#"><?= $onglet->title; ?></a></li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <main class="content uk-section uk-section-small" id="detailfiche">
        <div class="uk-container uk-container-center">
            <div class="uk-margin-medium-top bridge-fiche-main">

                <div uk-grid class="uk-flex-top">
                    <div class="uk-width-3-4@m">
                        <ul id="tabs-sit" class="uk-switcher">
                                <li>
                                    <div uk-grid class="">
                                        <div class="uk-width-2-3@m">
                                            <h2><span><?= $htmlTitre ?></span></h2>
                                        </div>
                                        <div class="uk-width-1-3@m pictogrammes-top uk-text-right">
                                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/otsr/blocks-fiche-otsr/pictogrammes.php'); ?>
                                        </div>
                                    </div>
                                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/otsr/blocks-fiche-otsr/infos-supplementaires-1.php'); ?>
                                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/otsr/blocks-fiche-otsr/descriptif.php'); ?>
                                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/otsr/blocks-fiche-otsr/infos-supplementaires-2.php'); ?>
                                    <?php if (count($hierarchicalCustomBlocks) > 0) : ?>
                                    <?php $onglet = $hierarchicalCustomBlocks[0]; ?>
                                        <?php $i = 0; ?>
                                           <div class="infosup"> <table class="uk-table uk-table-divider uk-table-responsive">
                                                <tbody>
                                            <?php foreach ($onglet->items as $item): ?>
                                                    <tr>
                                                        <?php if (!empty($item->title)): ?>
                                                            <th><?= $item->title ?></th>
                                                        <?php endif; ?>
                                                        <td>
                                                            <?php if (!empty($item->component)): ?>
                                                                <?php $blockData = $item->blockData; ?>
                                                                <?php  include BridgeUtils::bridge_locate_template('templates-bridge/fiche/gabarits/' . $item->component . '.php'); ?>
                                                            <?php else: ?>
                                                                <?= $item->html; ?>
                                                            <?php endif; ?>
                                                        </td>
                                                <?php $i++; ?>
                                                    </tr>
                                            <?php endforeach; ?>
                                            </tbody>
                                       </table></div>
                                    <?php endif; ?>
                                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-3.php'); ?>
                                </li>

                                <?php if (count($hierarchicalCustomBlocks) > 0) : ?>
                                    <?php foreach ($hierarchicalCustomBlocks as $key=>$onglet) : if($key == 0) continue;?>
                                        <li id="custom-block-<?= $onglet->blockId ?>" class="custom-block">
                                            <?php $i = 0; ?>
                                            <?php foreach ($onglet->items as $item): ?>
                                                <?php if ($i > 0): ?>
                                                    <hr class="block-separator uk-divider-icon"/>
                                                <?php endif; ?>
                                                <?php if (!empty($item->title)): ?>
                                                    <h3 class="block-label uk-h2"><span><?= $item->title ?></span></h3>
                                                <?php endif; ?>

                                                <?php if (!empty($item->component)): ?>
                                                    <?php $blockData = $item->blockData; ?>
                                                    <?php  include BridgeUtils::bridge_locate_template('templates-bridge/fiche/gabarits/' . $item->component . '.php'); ?>
                                                <?php else: ?>
                                                    <?= $item->html; ?>
                                                <?php endif; ?>
                                                <?php $i++; ?>
                                            <?php endforeach; ?>
                                        </li>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                        </ul>
                    </div>
                    <div class="uk-width-1-4@m">
                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_before_informations') ; ?>
                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/otsr/blocks-fiche-otsr/localisation.php'); ?>

                        <div class="uk-card uk-card-default uk-card-body" id="infocoord">

                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/coordonnees.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/reseaux-sociaux.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/telephone-s-de-contact.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/site-s-web.php'); ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/email-de-contact.php'); ?>
                            <?php if($fiche->productCode == "223012604"): ?>
                                <a href="<?= get_permalink(pll_get_post(114227)); ?>" class="resavisit uk-width-1-1 uk-button uk-button-primary" onclick="ga('send','event','Résa visite groupe','clic','<?= $fiche->productCode; ?>');"><?= BridgeCmsAbstractLayer::__('Réserver une visite','plugin-sit');?></a>
                            <?php endif; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/lien-de-reservation-en-ligne.php'); ?>
                            <?php if ($ficheParameters->displayCvButton): ?>
                                <div class="uak-position-z-index bridge-cv-button-container">
                                    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/button-cv.php'); ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/specifique/otsr/blocks-fiche-otsr/infos-supplementaires-4.php'); ?>

                        <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_aside_after_informations') ; ?>
                    </div>

                </div>


            </div>
        </div>
    </main>



    <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/blocks/infos-supplementaires-5.php'); ?>
</div>
