<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc coordonnées
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */
BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_coordonnees');
if(BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'coordonnees-contact')):?>
    <div class="coordonnees uk-margin-small  <?= (string) $fiche->ficheBlocks->{'coordonnees-contact'}->cssClass ?> uk-flex" itemprop="address" itemscope itemtype="https://schema.org/PostalAddress">
        <div class="uk-width-auto uk-padding-small uk-padding-remove-top uk-padding-remove-left"><i class="fa-regular fa-location-dot"></i></div>
        <div class="uk-width-expand"><?= BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'coordonnees-contact', array('sectionTitleTag' => 'h4', 'sectionsSeparator' => '<br/>', 'insertItemProps' => true)) ?></div>
    </div>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_coordonnees') ; ?>
