<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc infos supplémentaires 5
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_infos_5');
if(BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->ficheBlocks, 'infos-supplementaires-5')):?>
    <li class="infos-supplementaires-5 descriptif <?= (string) $fiche->ficheBlocks->{'infos-supplementaires-5'}->cssClass ?>">
        <?php if(isset($fiche->ficheBlocks->{'infos-supplementaires-5'}->blockLabel) && !empty($fiche->ficheBlocks->{'infos-supplementaires-5'}->blockLabel)): ?>
            <a class="block-label uk-h2 uk-accordion-title"><?= $fiche->ficheBlocks->{'infos-supplementaires-5'}->blockLabel ?></a>
        <?php endif; ?>
        <div class="uk-accordion-content">
        <?php $component = BridgeBlockService::getBlockComponent($fiche, $fiche->ficheBlocks, 'infos-supplementaires-5' ); ?>
        <?php if (!empty($component)): ?>
            <?php $blockData = $fiche->ficheBlocks->{'infos-supplementaires-5'}; ?>
            <?php  include BridgeUtils::bridge_locate_template('templates-bridge/fiche/gabarits/' . $component . '.php'); ?>
        <?php else: ?>
            <?= BridgeBlockService::renderNamedBlockHtml($fiche->ficheBlocks, 'infos-supplementaires-5') ?>
        <?php endif; ?>
        </div>
    </li>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_infos_5') ; ?>
