<?php
/**
 * Template d'affichage des blocks personnalisés dans une page fiche détaillée
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

$blocks = $fiche->ficheBlocks->custom;

$hierarchicalCustomBlocks = array();
if (isset($fiche) && is_object($fiche) && !empty($fiche->ficheBlocks) && isset($blocks) && count($blocks) > 0) {
    $hierarchicalCustomBlocks = BridgeBlockService::prepareCustomBlocksDisplay($fiche, $blocks, $ficheParameters);
}

if(isset($_REQUEST['toto'])) {
    print_r($hierarchicalCustomBlocks);
}

// Signets pour savoir quand insérer des séparateurs
$previousGroupId = -1;
$previousBlockId = -1;

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_custom_blocks');
$nbOnglets = 0;
if (count($hierarchicalCustomBlocks) > 0) : ?>
    <section class="onglet">
        <div uk-grid>
            <?php foreach ($hierarchicalCustomBlocks as $onglet) :
            $groupeactif = false; ?>
            <?php if (true): ?>
                <?php if (isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug'] == "X") : ?>
                    <code>
                        <pre><?php print_r($blockData); ?></pre>
                    </code>
                <?php endif; ?>


                <?php if ($nbOnglets > 0): ?>
                    <?php if((!empty($onglet->group) && $onglet->group == 1)): ?>
                        <hr class="block-separator group-separator uk-width-1-1 uk-divider-icon <?= $onglet->separatorClass ?>"/>
                    <?php else: ?>
                        <hr class="block-separator uk-width-1-1 uk-divider-icon <?= $onglet->items[0]->separatorClass ?>"/>
                    <?php endif; ?>
                <?php endif; ?>
                <?php $nbOnglets++; ?>
                <?php $nbItems = 0; ?>

                <?php if (!empty($onglet->group) && $onglet->group == 1): ?>
                    <div id="custom-block-<?= $onglet->blockId ?>" class="custom-block <?= $onglet->class ?>">
                        <h2 class="block-group-label"><?= $onglet->title; ?></h2>
                        <div uk-grid>
                        <?php $groupeactif = true; ?>
                <?php endif; ?>

                <?php foreach ($onglet->items as $item): ?>
                    <div <?= (!isset($onglet->group) || empty($onglet->group) || $onglet->group != 1) ? 'id="custom-block-' . $item->blockId : ''; ?>" class="custom-block <?= $item->class ?>">
                        <?php if ($nbItems > 0): ?>
                            <hr class="block-separator uk-width-1-1 uk-divider-icon <?= $item->separatorClass ?>"/>
                        <?php endif; ?>
                        <?php if (!empty($item->title)): ?>
                            <h3 class="block-label uk-h2"><span><?= $item->title ?></span></h3>
                        <?php endif; ?>

                        <?php if (!empty($item->component)): ?>
                            <?php $blockData = $item->blockData; ?>
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/fiche/gabarits/' . $item->component . '.php'); ?>
                        <?php else: ?>
                            <?= $item->html; ?>
                        <?php endif; ?>
                    <?php $nbItems++; ?>
                </div>
            <?php endforeach; ?>
            <?php if (!empty($onglet->group) && $onglet->group == 1): ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <?php endforeach; ?>
        </div>
    </section>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_custom_blocks'); ?>
