<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc site(s) web
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

$lien = '';
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "site-s-web"))
    $lien = BridgeBlockService::extractNamedBlockFirstTextValue ( $fiche->ficheBlocks, "site-s-web");
?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_site_web'); ?>
<?php if($lien !== ''): ?>
    <?php
    $lien = "http://" . $lien;
    $lien = str_replace("http://http://", "http://", $lien);
    $lien = str_replace("http://https://", "https://", $lien);
    ?>
    <a href="<?= str_replace(' ','',$lien); ?>" target="_blank" data-dnc-turl="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>" class="site-s-web  <?= (string) $fiche->ficheBlocks->{'site-s-web'}->cssClass ?>">
        <div class="uk-flex">
            <div class="uk-width-auto uk-padding-small uk-padding-remove-top uk-padding-remove-left"><i class="fa-regular fa-globe"></i></div>
            <div class="uk-width-expand"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_SITE_INTERNET','Site internet','plugin-sit'); ?> <i class="fa-solid fa-share"></i></div>
        </div>
    </a>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_site_web'); ?>
