<?php
/**
 * Template d'affichage de block dans une page fiche détaillée - bloc téléphone de contact
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/fiche/blocks
 *
 * @version 3.3
 *
 */

$tel = '';
if(BridgeBlockService::textBlockIsNotEmpty($fiche, $fiche->ficheBlocks, "telephone-s-de-contact"))
    $tel = BridgeBlockService::extractNamedBlockFirstTextValue ( $fiche->ficheBlocks, "telephone-s-de-contact");

BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_before_telephone');
if($tel != ''): ?>
    <?php if ($ficheParameters->hidePhoneWithXX == true): ?>
        <a class="phone  <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>" data-dnc-ttel="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>" uk-toggle="target: .phone">
            <div class="uk-flex">
                <div class="uk-width-auto uk-padding-small uk-padding-remove-top uk-padding-remove-left"><i class="fa-solid fa-mobile-screen-button"></i></div>
                <div class="uk-width-expand"> <?= BridgeCmsAbstractLayer::__('APPELER', 'plugin-sit') ?></div>
            </div>
        </a>
        <a href="tel:<?= str_replace(' ','',$tel); ?>" data-dnc-ttel="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>" class="phone <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>" hidden><div class="uk-flex">
                <div class="uk-width-auto uk-padding-small uk-padding-remove-top uk-padding-remove-left"><i class="fa-solid fa-mobile-screen-button"></i></div>
                <div class="uk-width-expand"> <?= $tel; ?></div>
            </div></a>
    <?php else: ?>
        <a href="tel:<?= str_replace(' ','',$tel); ?>" data-dnc-ttel="<?= $fiche->productCode ?>" data-product-code="<?= $fiche->productCode ?>" data-text-key="<?= (string) $fiche->productTextKey ?>" class="phone  <?= (string) $fiche->ficheBlocks->{'telephone-s-de-contact'}->cssClass ?>"><div class="uk-flex">
                <div class="uk-width-auto uk-margin-right"><i class="fa-solid fa-mobile-screen-button"></i></div>
                <div class="uk-width-expand"> <?= $tel; ?></div>
            </div></a>
    <?php endif; ?>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_fiche_after_telephone');  ?> 
