<?php
/*
// On prépare les javascripts
wp_enqueue_style('leaflet');
wp_enqueue_style('leaflet-fs');
wp_enqueue_style('leaflet-mc');
wp_enqueue_style('leaflet-mc-theme');
wp_enqueue_script('leaflet');
wp_enqueue_script('leaflet-fs');
wp_enqueue_script('dnc-leaflet-services');
wp_enqueue_script('leaflet-mc');
*/

?>
<script type="text/javascript">// <!--
    var urlbasemap = '<?= BridgeUtils::getAjaxURL() ?>';
    var lurlcarte = "";
    var lang = "<?= BridgeUtils::getLanguage(); ?>";
    var paramsurl = "1=1";
    var paramsurlcount = "1=1";
    var lenom = "";
    var bridgeMapTotalPointsAdded = 0;
    var bridgeMapNumPointsByCall = 100 ; // <?php //  $listInfos->limitPerPage; ?>
    var iconOptions = {};

    window.do_bridge_init_carto = function() {
        if (typeof window.bridge_init_carto === 'undefined') {
            window.bridge_init_carto = true;
            window.markercmpt = 0;
            window.mapService = new dncLeafletServices('mapsSIT');
            window.mapService.mapoptions = {
                zoom: '13', // Niveau de Zoom de départ
                centerlat: window.bridgeMapOptions.centerLat, // Latitude du centre au départ
                centerlon: window.bridgeMapOptions.centerLng, // Longitude du centre au départ
                maptype: 'MAPTYPE_OPENSTREETMAPS', // Type de vue : ROAD, SATTELITE, HYBRID, 3D
                gridSize: 0,
                maxZoom: 12, // Niveau de zoom à partir duquel faire la clusterisation
                scrollWheelZoom: true,
                loadPopupAjax: true,   // Charger le contenu du popup en Ajax
                popupAjaxUrl:'<?= BridgeUtils::getAjaxURL() ?><?= (strpos(BridgeUtils::getAjaxURL(),'?') !== false)?'&':'?' ?>action=brFiche&fiche_template=popup&product_code='
            };
            window.mapService.defaultGeolocIconUrl = window.bridgeMapOptions.defaultGeolocIconUrl;

            var mapdiv = document.getElementById("mapsSIT");
            bridgeRefreshMap();

            window.mapService.defaultIconOptions =  {
                iconSize:     [<?= $bridgeParameters->marker_map_width ?>, <?= $bridgeParameters->marker_map_height ?>],
                iconAnchor:   [<?= round($bridgeParameters->marker_map_width/2) ?>, <?= round($bridgeParameters->marker_map_height/2) ?>],
                popupAnchor:  [0, -3]
            };

            window.mapService.init();
            window.mapService.switchToWordpress();
            window.mapService.enableMouseWheel();
            // window.mapService.disabledMouseWheel();
            <?php $moteurId = ''; ?>
            <?php if(isset($moteur) && is_object($moteur)): ?>
            <?php $moteurId = $moteur->id ; ?>
            <?php endif; ?>


            // 25/08/2025 - Permet d'ajouter un bouton de géolocalisation sur les les listes Bridge si l'option est active dans l'administration
            if(window.bridgeMapOptions.activeGeoloc){
                var bridgeFollowButton = L.easyButton({
                    states: [{
                        stateName: 'suivi-inactif',        // name the state
                        icon:      'fa-location-arrow',               // and define its properties
                        title:     'Suivre ma position',      // like its title
                        onClick: function(btn, map) {       // and its callback
                            window.mapService.locate()
                            btn.state('suivi-actif');    // change state on click!
                        }
                    }, {
                        stateName: 'suivi-actif',
                        icon:      'fa-compass-slash',
                        title:     'Arrêter le suivi',
                        onClick: function(btn, map) {
                            window.mapService.stopLocate();
                            btn.state('suivi-inactif');
                        }
                    }]
                });
                bridgeFollowButton.addTo( window.mapService.mapobject );
            }


            <?php $modelsWithMap = array('liste3', 'liste4', 'liste6', 'liste7', 'liste8', 'liste9'); ?>
            // Pour ne pas charger plusieurs fois les points
            window.pointsAddedToMap = false;

            if ('<?= $moteurId ?>' != '' && window.bridgeMoteur<?= $moteurId ?> !== undefined) {
                window.bridgeMoteur<?= $moteurId ?>.addEventHandler('afterSubmit', function (moteur) { // afterCalcMoteur modifié 15/06/2022 : plus tard mais moins d'appels intempestifs
                    bridgeMapTotalPointsAdded = 0;
                    // On ne recharge les points que si la carte est visible
                    if(jQuery('#mapsSIT').is(":visible")) {
                        window.mapService.delallmarkers();
                        setTimeout(function() {
                            bridgeAddPointsToMap();
                        }, 200);

                    }
                });
                window.bridgeMoteur<?= $moteurId ?>.calcMoteur(false);
                setTimeout(function() {
                    bridgeAddPointsToMap();
                }, 200);

            } else {
                // On ne recharge les points que si la carte est visible
                if(jQuery('#mapsSIT').is(":visible")) {
                    window.mapService.delallmarkers();
                    setTimeout(function() {
                        bridgeAddPointsToMap();
                    }, 200);

                }
            }

            /* Permet de centrer sur le marker au moment du survol */
            jQuery(document).ready(function(){
                jQuery('.bridge-liste .zoom-on-hover').hover( function() {
                    var idfiche = jQuery(this).attr('data-dnc-produit');
                    if(idfiche !== '') {
                        window.mapService.activatemarker(idfiche, true, true); // window.mapService.defaultIconOptions
                        window.mapService.centeronmarker(idfiche, "15");
                        // tricherie obligatoire pour forcer le point à s'afficher la premiere fois
                        setTimeout(function() {
                            window.mapService.setZoom(15);
                        },200);
                        window.mapService.reDraw();

                    }
                });

                // setTimeout(function () {
                jQuery('.bridge-liste .zoom-on-click').click(function() {
                    var idfiche = jQuery(this).attr('data-dnc-produit');
                    if(idfiche !== '') {
                        window.mapService.activatemarker(idfiche, true, true); // window.mapService.defaultIconOptions
                        window.mapService.centeronmarker(idfiche, "15");
                        // tricherie obligatoire pour forcer le point à s'afficher la premiere fois
                        setTimeout(function() {
                            window.mapService.setZoom(15);
                        },200);
                        window.mapService.reDraw();
                    }
                });
                // }, 1500);
            });


            UIkit.util.on('.bridgeMapSwitcher', 'show', function () {
                // if(window.pointsAddedToMap === false) {
                bridgeMapTotalPointsAdded = 0;
                window.mapService.delallmarkers();
                setTimeout(function() {
                    bridgeAddPointsToMap();
                }, 200);
                // }
            });

            // bridgeAddPointsToMap();
            // window.mapService.fitboundstomarkers();

            jQuery(window).resize(function() {
                bridgeRefreshMap();
            });

            // Sur retour du mode plein écran, si on est en liste avec bascule liste/carte, on rebascule sur l'onglet liste
            if (jQuery('.bridgeMapSwitcher').length > 0) {
                window.mapService.on('mapexitfullscreen', function (e) {
                    // On laisse le temps à la carte de revenir dans la page
                    setTimeout(function () {
                        UIkit.switcher('.bridgeMapSwitcher').show('#bridgeSwitchList');
                        jQuery('#bridgeSwitchMap').removeClass('uk-active');
                        jQuery('.bridge-map-toggle').parent().removeClass('uk-active');
                        jQuery('.bridge-map-toggle').attr('aria-expanded', 'false');
                        jQuery('#bridgeSwitchList').addClass('uk-active');
                        jQuery('.bridge-list-toggle').attr('aria-expanded', 'true');
                        jQuery('.bridge-list-toggle').parent().addClass('uk-active');
                    }, 200);
                });
            }

            // Ouverture des fiches en Iframe dans le popup
            if(window.bridgeFicheIframeClick !== undefined && typeof window.bridgeFicheIframeClick === 'function') {
                window.mapService.on('ajaxpopuploaded', function (popupcontent) {
                    if(window.mapService) {
                        let container = document.getElementById(window.mapService.containerid);
                    }
                    jQuery(document).find('a.bridge_link_fiche_iframe').click(bridgeFicheIframeClick);
                });
            } else {

            }

        }
    }

    // Gère le javascript de la carto
    bridgeDocumentReady(function() {
        if(jQuery('#mapsSIT').is(":visible")) {
            do_bridge_init_carto();
        }


        // Clic sur le bouton de passage en mode carte sur mobile : on passe sur l'onglet carte de la liste puis on ouvre en plein écran
        jQuery('.bridge-map-toggle-fullscreen').click(function (e) {
            e.preventDefault();
            // Si on a un switch liste / carte, on passe d'abord sur l'onglet carte
            if (jQuery('.bridgeMapSwitcher').length > 0) {
                jQuery('.bridge-map-toggle').click();
                UIkit.switcher('.bridgeMapSwitcher').show('#bridgeSwitchMap');
            }

            if (typeof window.bridge_init_carto === 'undefined' && typeof window.do_bridge_init_carto !== 'undefined') {
                window.do_bridge_init_carto();
            }
            if (window.mapService) {
                // Si les points ne sont pas encore présents sur la carte, on les ajoute
                // if (window.pointsAddedToMap === false) {
                bridgeMapTotalPointsAdded = 0;
                window.mapService.delallmarkers();
                setTimeout(function() {
                    bridgeAddPointsToMap();
                }, 200);
                // }
                // On passe la carte en plein écran
                window.mapService.setZoom(14);
                setTimeout(function () {
                    window.mapService.fitboundstomarkers();
                    // window.mapService.reDraw();
                    bridgeRefreshMap();
                    window.mapService.toggleFullScreen();
                }, 250);
            }
        });


    });


    function bridgeRefreshMap() {
        var sizeneg = (jQuery(window).width()-jQuery('#maps-loc').parents('.elementor-container').width()+100)/2;
        jQuery('#maps-loc').css({
            position: 'relative',
            width: jQuery(window).width(),
            //left: '50%',
            marginLeft: '-'+sizeneg+'px'
        });
    }

    // Fonction qui ajoute les points
    // Elle se rappelle elle-même jusqu'à être arrivée au bout
    function bridgeAddPointsToMap() {

        // On signale que l'init des points est faite
        window.pointsAddedToMap = true;
        var rfrom = bridgeMapTotalPointsAdded + 1;
        var rto = bridgeMapTotalPointsAdded + bridgeMapNumPointsByCall + 1;
        var i = 0;
        var paramslocal = '1=1';

        // Test de la fin
        if (rfrom > bridgeTotalResults) {
            return true;  // finished
        }

        if (rto > bridgeTotalResults)
            rto = bridgeTotalResults;

        <?php $bonusFiltre = '';
        if(isset($listInfos->filter_city) && !empty($listInfos->filter_city)) $bonusFiltre = '&filter_city=' . urlencode($listInfos->filter_city);
        if(isset($listInfos->filter_lat) && !empty($listInfos->filter_lat)) $bonusFiltre = '&filter_lat=' . urlencode($listInfos->filter_lat);
        if(isset($listInfos->filter_lon) && !empty($listInfos->filter_lon)) $bonusFiltre = '&filter_lon=' . urlencode($listInfos->filter_lon);
        if(isset($listInfos->filter_rayon) && !empty($listInfos->filter_rayon)) $bonusFiltre = '&filter_rayon=' . urlencode($listInfos->filter_rayon);
        if(isset($listInfos->selection_id) && !empty($listInfos->selection_id)) $bonusFiltre = '&selection_id=' . urlencode($listInfos->selection_id);
        if(isset($listInfos->filter_criterions) && !empty($listInfos->filter_criterions)) $bonusFiltre = '&filter_criterions=' . urlencode($listInfos->filter_criterions);
        if(isset($listInfos->scoring) && !empty($listInfos->scoring)) $bonusFiltre = '&scoring=' . urlencode($listInfos->scoring);
        if(isset($listInfos->excluded_codes) && !empty($listInfos->excluded_codes)) $bonusFiltre = '&excluded_codes=' . urlencode($listInfos->excluded_codes);
        if(isset($listInfos->sort_one) && !empty($listInfos->sort_one)) $bonusFiltre = '&sort_one=' . urlencode($listInfos->sort_one);
        if(isset($listInfos->sort_two) && !empty($listInfos->sort_two)) $bonusFiltre = '&sort_two=' . urlencode($listInfos->sort_two);
        if(isset($listInfos->sort_three) && !empty($listInfos->sort_three)) $bonusFiltre = '&sort_three=' . urlencode($listInfos->sort_three);
        if(isset($listInfos->duplicate_by) && !empty($listInfos->duplicate_by)) $bonusFiltre = '&duplicate_by=' . urlencode($listInfos->duplicate_by);


        ?>
        paramslocal = "action=brListePOI&id=<?= $listInfos->webListId ?>&product_codes=<?= $listInfos->productCodes ?><?= $bonusFiltre ?>"  ;
        if('<?= $moteurId ?>' != '') {
            paramslocal += '&braf=' + window.bridgeMoteur<?= $moteurId ?>.activeFilters.join(',');
            paramslocal += '&brai=' + window.bridgeMoteur<?= $moteurId ?>.activeItems.join(',');
            // Patch 24/05/22 : les recherches par valeurs n'étaient pas prises en compte
            if(typeof window.bridgeMoteur<?= $moteurId ?>.urlParams === 'object' && window.bridgeMoteur<?= $moteurId ?>.urlParams !== null && Object.keys(window.bridgeMoteur<?= $moteurId ?>.urlParams).length > 0) {
                var keys = Object.keys(window.bridgeMoteur<?= $moteurId ?>.urlParams);
                for(idx in keys) {
                    var key = keys[idx];
                    paramslocal += '&' + key + '=' + window.bridgeMoteur<?= $moteurId ?>.urlParams[key];
                }
            }
            // Feat 25/05/22 : support du paramètre productCodes où on spécifie des fiches une par une
            if(typeof window.bridgeMoteur<?= $moteurId ?>.options === 'object' && window.bridgeMoteur<?= $moteurId ?>.options.hasOwnProperty('productCodes') ) {
                paramslocal += '&product_codes=' + window.bridgeMoteur<?= $moteurId ?>.options.productCodes ;
            }

        }
        if(window.bridgeCurrentMapRequest !== undefined) {
            window.bridgeCurrentMapRequest.abort();
        }
        window.bridgeCurrentMapRequest = jQuery.ajax({
            url: urlbasemap,
            data: paramslocal + "&minimal_select=1&first=" + rfrom + "&max=" + bridgeMapNumPointsByCall + "&lang=" + lang,
            dataType: 'json'
        }).done(function(lejson) {
            if(lejson && lejson.success && lejson.data) {
                var popupcontent = "";
                var onclickf = null ;
                /*function (mapositionId) {
                    window.mapService.openinfomarker(mapositionId);
                };

                 */
                var fiche = {};
                var tmpKml = null;

                for (var i = 0; i < lejson.data.selection.results.products.length; i++) {
                    // Ici on construit le contenu du popup AA
                    fiche = lejson.data.selection.results.products[i];
                    tmpKml = null;
                    if( !(fiche.kml === null || fiche.kml === '')) {
                        tmpKml = fiche.kml;
                    }

                    popupcontent = '<div class="uk-padding uk-text-center"> <i class="fad fa-spinner"></i> </div>';
                    if(fiche.latitude !== null && fiche.longitude !== null) {
                        window.mapService.addmarker(
                            fiche.productCode,
                            fiche.latitude,
                            fiche.longitude,
                            fiche.name,
                            window.bridgeMapOptions.markerIcon,
                            window.bridgeMapOptions.activeMarkerIcon,
                            popupcontent,
                            onclickf,
                            tmpKml);
                    }
                }
                // Ici on ajuste le Zoom aux points affichés
                window.mapService.fitboundstomarkers();
                bridgeMapTotalPointsAdded += bridgeMapNumPointsByCall;
                return bridgeAddPointsToMap();
            }
        }).fail(function(e){
            console.log(e);
        });

    }


 // -->
</script>
