<?php
/**
 * Template d'affichage de liste carousel
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/liste
 *
 * @version 3.2
 *
 */

if(isset($listParameters->numberColumn) && isset($listParameters->numberColumn->xl) && $listParameters->numberColumn->xl !== 'auto') {
    $xl = '1-' . $listParameters->numberColumn->xl;
} else {
    $xl = '1-3';
}
if(isset($listParameters->numberColumn) && isset($listParameters->numberColumn->l) && $listParameters->numberColumn->l !== 'auto') {
    $l = '1-' . $listParameters->numberColumn->l;
} else {
    $l = '1-2';
}
if(isset($listParameters->numberColumn) && isset($listParameters->numberColumn->m) && $listParameters->numberColumn->m !== 'auto') {
    $m = '1-' . $listParameters->numberColumn->m;
} else {
    $m = '1-1';
}
if(isset($listParameters->numberColumn) && isset($listParameters->numberColumn->s) && $listParameters->numberColumn->s !== 'auto') {
    $s = '1-' . $listParameters->numberColumn->s;
} else {
    $s = '1-1';
}

?>
<div class="bridge-liste carousel">
  <?php if (isset($annonceBillboard) && is_object($annonceBillboard)): ?>
        <div class="bridge-liste-annonces">
      <?php include BridgeUtils::bridge_locate_template('templates-bridge/annonces/annonceBillboard.php'); ?>
        </div>
  <?php endif; ?>
    <div uk-slider="<?= $listParameters->paramsCarousel ;?>">
      <div class="uk-position-relative uk-visible-toggle" tabindex="-1">
        <ul class="uk-slider-items uk-grid-<?= $listParameters->spacingColumn; ?> uk-child-width-<?= $xl ; ?>@xl uk-child-width-<?= $l ?>@l uk-child-width-<?= $m ; ?>@m uk-child-width-<?= $s ;?>@s uk-grid" uk-height-match="target: .bridge-match-height-target">
          <?php if (isset($data) && $listInfos->totalProducts > 0) : ?>
            <?php foreach($data->selection->results->products as $fiche) : ?>
                  <?php $photo = '' ; ?>
                  <?php $photo2 = '' ; ?>
                  <?php $images = BridgeBlockService::extractPhotos($fiche->listBlocks, 'photo') ; ?>
                  <?php if(count($images) > 0): ?>
                      <?php $photo = $images[0]->url ; ?>
                  <?php elseif(isset($listParameters->defaultImage) && isset($listParameters->defaultImage->url) && !empty($listParameters->defaultImage->url)): ?>
                      <?php $photo = $listParameters->defaultImage->url ; ?>
                  <?php endif; ?>
                  <?php if(count($images) >  1): ?>
                      <?php $photo2 = $images[1]->url ; ?>
                  <?php endif ;?>
              <li>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/gabarits/'.$listInfos->bridgeModeleListeitem.'.php'); ?>
              </li>
            <?php endforeach; ?>
          <?php else : ?>
              <b class="center"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_LISTE_AUCUN_RESULTAT', 'Aucun résultat', 'plugin-sit') ?></b>
              <p class="center"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_LISTE_VIDE_AVEC_CES_CRITERES', 'La liste est vide avec ces critères.', 'plugin-sit'); ?></p>
          <?php endif; ?>
        </ul>

        </div>
        <?php if(isset($listParameters->arrow) && $listParameters->arrow) : ?>
          <a class="uk-position-center-left-out uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous uk-slider-item="previous"></a>
          <a class="uk-position-center-right-out uk-position-small uk-hidden-hover" href="#" uk-slidenav-next uk-slider-item="next"></a>
        <?php endif; ?>
      <?php if(isset($listParameters->dots) && $listParameters->dots) : ?>
        <ul class="uk-slider-nav uk-dotnav uk-flex-center uk-margin"></ul>
      <?php endif; ?>
    </div>
</div>
