<?php
/**
 * Template d'affichage de l'item de liste carte 2
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/liste/gabarits
 *
 * @version 3.3.3
 *
 */
$itemContainerTag = (isset($bridgeParameters->tag_listitem_container) && !empty($bridgeParameters->tag_listitem_container)) ? $bridgeParameters->tag_listitem_container : 'article' ;

?>
<<?=$itemContainerTag ?> class="ficheproduit cards2 <?= $zoomonhover; ?> uk-position-relative" data-dnc-produit="<?= $fiche->productCode; ?>" data-dnc-lat="<?= $fiche->latitude; ?>" data-dnc-lon="<?= $fiche->longitude; ?>" data-dnc-name="<?= BridgeCmsAbstractLayer::esc_attr($fiche->name); ?>">
	<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_before_start',$fiche) ; ?>
	<div class="uk-card uk-card-default uk-cover-container bridge-match-height-target">
		<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_start',$fiche) ; ?>
		<?php if($photo != '' && $listParameters->showImage): ?>
			<div class="uk-card-media-top uk-cover-container uk-position-relative uk-height-medium card-media uk-background-cover" uk-img="loading: lazy" data-src="<?= BridgeUtils::getResizeImageLink($photo, "tronq", "600", "600", "60"); ?>">
				<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_media_start',$fiche) ; ?>
				<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/info-1.php'); ?>
				<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/info-2.php'); ?>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/pictogrammes.php'); ?>
				<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_media_end',$fiche) ; ?>
			</div>
		<?php endif; ?>
		<div class="bridge-body uk-card-body uk-padding-small uk-position-relative">
			<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_content_start',$fiche) ; ?>
			<?php if($listParameters->displayCvButton): ?>
				<div class="uk-position-top-right uk-position-z-index bridge-cv-button-container">
					<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/button-cv.php'); ?>
				</div>
			<?php endif; ?>
			<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/surtitre.php'); ?>
			<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/titre-de-la-fiche.php'); ?>
			<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/sous-titre.php'); ?>
			<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/commentaire.php'); ?>
			<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_content_end',$fiche) ; ?>
		</div>
        <?php if(BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->listBlocks, 'info-3') || BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->listBlocks, 'info-4')): ?>
		<div class="uk-card-footer uk-padding-small uk-position-relative uk-flex uk-flex-between card-footer">
			<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_footer_start',$fiche) ; ?>
			<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/info-3.php'); ?>
			<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/info-4.php'); ?>
			<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_footer_end',$fiche) ; ?>
		</div>
        <?php endif; ?>
		<a class="bridge_link_fiche uk-position-cover" href="<?= $fiche->link; ?>"></a>
		<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_end',$fiche) ; ?>
	</div>
	<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_after_end',$fiche) ; ?>
	<?php if($zoomonclic) :?>
		<button class="uk-button-small zoom-on-click uk-position-z-index uk-position-top-left" data-dnc-produit="<?= $fiche->productCode; ?>">
			<?= BridgeCmsAbstractLayer::__('Voir sur la carte','plugin-sit'); ?>
		</button>
	<?php endif; ?>
</<?=$itemContainerTag ?>>
