<?php
/**
 * Template d'affichage de l'item de liste liste 1
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/liste/gabarits
 *
 * @version 3.3.1
 *
 */
$itemContainerTag = (isset($bridgeParameters->tag_listitem_container) && !empty($bridgeParameters->tag_listitem_container)) ? $bridgeParameters->tag_listitem_container : 'article' ;

?>
<<?=$itemContainerTag ?> class="ficheproduit liste1 <?= $zoomonhover; ?> uk-position-relative uk-transition-toggle" data-dnc-produit="<?= $fiche->productCode; ?>" data-dnc-lat="<?= $fiche->latitude; ?>" data-dnc-lon="<?= $fiche->longitude; ?>" data-dnc-name="<?= BridgeCmsAbstractLayer::esc_attr($fiche->name); ?>">
	<div class="uk-card uk-card-default uk-grid-collapse uk-child-width-1-2@s uk-grid-match bridge-match-height-target" uk-grid>
		<?php if($photo != '' && $listParameters->showImage): ?>
			<div class="uk-card-media-left uk-cover-container uk-position-relative list-media">
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/pictogrammes.php'); ?>
				<img data-src="<?= BridgeUtils::getResizeImageLink($photo, "tronq", "400", "250", "60"); ?>" alt="<?= $fiche->name?>" uk-cover uk-img>
                <?php if(isset($photo2) && $photo2 != ''): ?>
                    <img class="uk-transition-slide-left" data-src="<?= BridgeUtils::getResizeImageLink($photo2, "tronq", "400", "250", "60"); ?>" alt="<?= $fiche->name?>" uk-cover uk-img >
                <?php endif; ?>
				<canvas width="600" height="400"></canvas>
			</div>
		<?php endif; ?>
		<div class="bridge-body uk-card-body uk-padding-small uk-position-relative">
			<?php if($listParameters->displayCvButton): ?>
				<div class="uk-position-top-right uk-position-z-index bridge-cv-button-container">
					<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/button-cv.php'); ?>
				</div>
			<?php endif; ?>
			<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/surtitre.php'); ?>
			<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/titre-de-la-fiche.php'); ?>
			<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/sous-titre.php'); ?>
			<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/commentaire.php'); ?>
            <?php if(BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->listBlocks, 'info-1') || BridgeBlockService::itemsBlockIsNotEmpty($fiche, $fiche->listBlocks, 'info-2')): ?>
                <div class="uk-card-footer uk-padding-small uk-position-relative uk-flex uk-flex-between list-footer">
				    <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/info-1.php'); ?>
					<?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/blocks/info-2.php'); ?>
    			</div>
            <?php endif; ?>
		</div>
	</div>
	<a class="bridge_link_fiche uk-position-cover" href="<?= $fiche->link; ?>"></a>
	<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_gabarit_end',$fiche) ; ?>
	<?php if($zoomonclic) :?>
		<button class="uk-button-small zoom-on-click uk-position-z-index uk-position-bottom-left" data-dnc-produit="<?= $fiche->productCode; ?>">
			<?= BridgeCmsAbstractLayer::__('Voir sur la carte','plugin-sit'); ?>
		</button>
	<?php endif; ?>
</<?=$itemContainerTag ?>>
