<?php
/**
 * Template d'affichage de liste liste 4
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/liste
 *
 * @version 3.2.6
 *
 */

$moteurId = '';
if(isset($listParameters->numberColumn) && isset($listParameters->numberColumn->xl) && $listParameters->numberColumn->xl !== 'auto')
    $listParameters->numberColumn->xl = '1-' . $listParameters->numberColumn->xl;
if(isset($listParameters->numberColumn) && isset($listParameters->numberColumn->l) && $listParameters->numberColumn->l !== 'auto')
    $listParameters->numberColumn->l = '1-' . $listParameters->numberColumn->l;
if(isset($listParameters->numberColumn) && isset($listParameters->numberColumn->m) && $listParameters->numberColumn->m !== 'auto')
    $listParameters->numberColumn->m = '1-' . $listParameters->numberColumn->m;
if(isset($listParameters->numberColumn) && isset($listParameters->numberColumn->s) && $listParameters->numberColumn->s !== 'auto')
    $listParameters->numberColumn->s = '1-' . $listParameters->numberColumn->s;

if (isset($moteur) && is_object($moteur) && !empty($moteur->id)) $moteurId = $moteur->id;
?>
<?php $moteurEnDouble = ''; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_before') ; ?>
<div class="bridge-liste liste9" id="bridge-liste-<?= $listParameters->uniqueIdentifier ?>" data-bridge-identifier="<?= $listParameters->uniqueIdentifier ?>" data-moteur-id="<?= $moteurId ?>" >
    <?php if(isset($moteur->useFirstSectionForQuickFilters) && $moteur->useFirstSectionForQuickFilters === true): ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/quick-search.php'); ?>
    <?php endif; ?>

    <div uk-grid class="uk-grid-small">
        <div class="uk-width-expand@m bridge-main-montent-liste">
            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_before_toolbar', $listData) ; ?>
            <div class="bridge-toolbar uk-padding-small">
                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_before_toolbar_inner', $listData) ; ?>
                <div uk-grid class="uk-grid-small">
                    <div class="uk-width-auto@m bridge-switchers">
                        <div class="uk-width-1-1 uk-flex uk-flex-between">
                            <?php if (isset($moteur) && is_object($moteur) && !empty($moteur->id)): ?>
                            <div class="uk-hidden@m uk-width-auto">
                                <button uk-toggle="target: #offcanvas-moteur<?= $moteur->id ?>"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_FILTRES', 'Filtres', 'plugin-sit'); ?></button>
                            </div>
                            <?php endif; ?>
                            <div class="uk-button-group uk-width-auto uk-flex uk-flex-center@m uk-flex-right@l bridge-view-toggle">
                                <button type="button" class="active uk-button-primary uk-visible@m" data-target-container="displayListe-<?= $listParameters->uniqueIdentifier ?>" data-mode="view-mixed"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_LISTE_MIXTE', 'MIXTE', 'plugin-sit') ?></button>
                                <button type="button" data-target-container="displayListe-<?= $listParameters->uniqueIdentifier ?>" data-mode="view-list"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_LISTE_LISTE', 'LISTE', 'plugin-sit') ?></button>
                                <button type="button" data-target-container="displayListe-<?= $listParameters->uniqueIdentifier ?>" data-mode="view-maps"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_LISTE_CARTE', 'CARTE', 'plugin-sit') ?></button>
                            </div>
                        </div>
                    </div>
                    <div class="uk-width-expand@s uk-flex-middle uk-flex uk-flex-between uk-grid-collapse bridge-sorts-" uk-grid>
                        <div class="uk-flex uk-flex-between uk-flex-end uk-flex-middle">
                            <div class="totals">
                                <?= sprintf(BridgeCmsAbstractLayer::_nmp('COM_PYLOT_BRIDGE_LISTE_N_RESULTATS', '<span class="listeSITCount">%s</span> résultat', '<span class="listeSITCount">%s</span> résultats', $listInfos->totalProducts, 'plugin-sit'), $listInfos->totalProducts); ?>
                            </div>
                        </div>
                        <div class="bridgeActiveFiltersDiv uk-width-expand@m uk-visible@m"></div>
                            <div class="bridge-sort uk-width-auto">
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/tris/tris.php'); ?>
                        </div>
                    </div>

                </div>
                <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_after_toolbar_inner', $listData) ; ?>
            </div>

            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_after_toolbar', $listData) ; ?>

            <div uk-grid class="uk-grid-small bridgeMapSwitcher bridgeListeToggleContentContainer" id="displayListe-<?= $listParameters->uniqueIdentifier ?>">
                <div class="uk-width-1-3@m bridge-toggling-map-container">
                    <div class="uk-overflow-hidden uk-position-relative uk-height-1-1">
                        <div id="mapsSIT" class="uk-height-viewport uk-width-1-1" uk-sticky="start: 100;end:#listSIT "></div>
                    </div>
                </div>
                <div class="uk-width-expand@m bridge-toggling-list-container" uk-filter="target: .filter-sit">
                    <?php if (isset($annonceBillboard) && is_object($annonceBillboard)): ?>
                        <div class="bridge-liste-annonces">
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/annonces/annonceBillboard.php'); ?>
                        </div>
                    <?php endif; ?>
                    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_before_results', $listData) ; ?>
                    <div class="uk-width-1-1">
                        <div id="listeSIT_<?= $listParameters->uniqueIdentifier ?>"
                             class="listeSIT uk-grid-match filter-sit uk-grid-<?= $listParameters->spacingColumn; ?> uk-child-width-<?= ($listParameters->numberColumn->xl) ? $listParameters->numberColumn->xl . '@xl' : $listParameters->numberColumn->default . '@xl'; ?> uk-child-width-<?= ($listParameters->numberColumn->l) ? $listParameters->numberColumn->l . '@l' : $listParameters->numberColumn->default . '@l'; ?> uk-child-width-<?= ($listParameters->numberColumn->m) ? $listParameters->numberColumn->m . '@m' : $listParameters->numberColumn->default . '@m'; ?> uk-child-width-<?= ($listParameters->numberColumn->s) ? $listParameters->numberColumn->s . '@s' : $listParameters->numberColumn->default . '@s'; ?>"
                             uk-grid uk-height-match="target: > div .bridge-match-height-target">
                            <?php if (isset($data) && $listInfos->totalProducts > 0) : ?>
                                <?php foreach ($data->selection->results->products as $fiche) : ?>
                                    <?php $photo = ''; ?>
                                    <?php $photo2 = ''; ?>
                                    <?php $images = BridgeBlockService::extractPhotos($fiche->listBlocks, 'photo'); ?>
                                    <?php if (count($images) > 0): ?>
                                        <?php $photo = $images[0]->url; ?>
                                    <?php elseif (isset($listParameters->defaultImage) && isset($listParameters->defaultImage->url) && !empty($listParameters->defaultImage->url)): ?>
                                        <?php $photo = $listParameters->defaultImage->url; ?>
                                    <?php endif; ?>
                                    <?php if (count($images) > 1): ?>
                                        <?php $photo2 = $images[1]->url; ?>
                                    <?php endif; ?>
                                    <div class="liste_sit_item" data-dnc-produit="<?= $fiche->productCode ?>">
                                        <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/gabarits/' . $listInfos->bridgeModeleListeitem . '.php'); ?>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <b class="center"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_LISTE_AUCUN_RESULTAT', 'Aucun résultat', 'plugin-sit') ?></b>
                                <p class="center"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_LISTE_VIDE_AVEC_CES_CRITERES', 'La liste est vide avec ces critères.', 'plugin-sit'); ?></p>
                            <?php endif; ?>

                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php if(isset($moteur) && isset($moteur->sections[1])) : ?>
            <div class="uk-width-1-5@m zone-moteur uk-visible@m">
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/moteur-body.php'); ?>
            </div>
        <?php endif; ?>
    </div>
    <?php if($listParameters->paginationType == 'PAGINATION'): ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/pagination/pagination.php'); ?>
    <?php elseif($listParameters->paginationType == 'INFINITE_SCROLL' || $listParameters->paginationType == 'INFINITE_SCROLL_AVEC_BOUTON'): ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/pagination/pagination.php'); ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/pagination/infinitescroll.php'); ?>
    <?php endif; ?>
    <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_after_results') ; ?>
    <div id="listSIT"></div>
    <?php if (isset($moteur) && is_object($moteur) && !empty($moteur->id)): ?>
        <div id="offcanvas-moteur<?= $moteur->id ?>" class=" off-canvas-moteur-mobile bridge-moteur-sit" uk-offcanvas="overlay: true">
            <div class="uk-offcanvas-bar uk-light uk-offcanvas-bar-animation uk-offcanvas-slide zone-moteur">
                <button class="uk-offcanvas-close" type="button" uk-close></button>
                <h3>
                    <?= BridgeCmsAbstractLayer::__('Rechercher', 'plugin-sit'); ?>
                </h3>
                <div class="bridgeActiveFiltersDiv uk-width-expand@m"></div>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/moteur.php'); ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_after_results', $listData) ; ?>

