<?php
// Vérification du bon paramétrage du filtre
$isOK = true;
if(!isset($filter->items) || count($filter->items) <= 0)
{
    $isOK    = false;
    $message = 'Veuillez définir au moins un élément dans le filtre';
}

$displayResults = isset($filter->parameters) && isset($filter->parameters->display_results) && $filter->parameters->display_results;
?>

<?php include bridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/filters/common/filter-header.php') ; ?>

<?php if(!$isOK): ?>
	<p>
		<b><?= BridgeCmsAbstractLayer::__('Erreur d\'affichage du filtre', 'plugin-sit') ?></b><br/>
		<?= $message ?>
	</p>
<?php else: ?>


<?php // On compte le nombre d'items
$countItems = count($filter->items);
$maxShow = 40;
if(isset($filter->parameters) && is_object($filter->parameters) && isset($filter->parameters->maxCheckboxes) && !empty($filter->parameters->maxCheckboxes)) {
    $maxShow = (int) $filter->parameters->maxCheckboxes;
}
$cmptInit = 1;
?>

    <div class="bridge-filter-checkbox" id="bridge-filter-<?= $moteurEnDouble ?><?= $filter->uniqueId ?>">
    <?php foreach($filter->items as $item): ?>
        <?php if($cmptInit <= $maxShow ) : ?>
        <label class="uk-display-block uk-width-1-1" for="chk_<?= $moteurEnDouble ?><?= $filter->uniqueId ?>-<?= $item->id ?>" data-item-id="<?= $item->id ?>">
            <input 
                type="checkbox" 
				class="uk-checkbox <?php if($displayResults && $item->count <= 0): ?>bridge-disabled<?php endif; ?>" 
                id="chk_<?= $moteurEnDouble ?><?= $filter->uniqueId ?>-<?= $item->id ?>" 
                data-item-id="<?= $item->id ?>" 
                <?php if($displayResults && $item->count <= 0): ?> disabled <?php endif; ?>
            />
            <span class="bridge-label <?php if($displayResults && $item->count <= 0): ?>bridge-disabled<?php endif; ?>">
                <?php // Nouveau 19/04/23 : images de filtres ?>
                <?php if (isset($item->image) && !empty($item->image)): ?>
                    <?php $imageUrl = $bridgeParameters->url_bridge . '/media/' . $item->image; ?>
                    <span class="bridge-engine-image-container">
                        <?= BridgeBlockService::renderEngineImage($item->image,$item->label); ?>
                    </span>
                <?php endif; ?>
                <?= $item->label ?>
                <?php if($displayResults): ?>
                    <span class="bridge-count" data-item-id="<?= $item->id ?>">(<?= $item->count ?>)</span>
                <?php endif; ?>
            </span>
        </label>
        <?php else : ?>
        <label class="uk-display-block uk-width-1-1 chk_<?= $moteurEnDouble ?><?= $filter->uniqueId ?>-hide" for="chk_<?= $moteurEnDouble ?><?= $filter->uniqueId ?>-<?= $item->id ?>" data-item-id="<?= $item->id ?>" hidden <?php if($item->count <= 0): ?> disabled <?php endif; ?>>
            <input 
                type="checkbox" 
				class="uk-checkbox <?php if($displayResults && $item->count <= 0): ?>bridge-disabled<?php endif; ?>" 
                id="chk_<?= $moteurEnDouble ?><?= $filter->uniqueId ?>-<?= $item->id ?>" 
                data-item-id="<?= $item->id ?>"
                <?php if($displayResults && $item->count <= 0): ?> disabled <?php endif; ?>
            >
            <span class="bridge-label <?php if($displayResults && $item->count <= 0): ?>bridge-disabled<?php endif; ?>">
                <?php // Nouveau 19/04/23 : images de filtres ?>
                <?php if (isset($item->image) && !empty($item->image)): ?>
                    <?php $imageUrl = $bridgeParameters->url_bridge . '/media/' . $item->image; ?>
                    <span class="bridge-engine-image-container">
                        <?= BridgeBlockService::renderEngineImage($item->image,$item->label); ?>
                    </span>
                <?php endif; ?>
                <?= $item->label ?>
                <?php if($displayResults): ?>
                    <span class="bridge-count" data-item-id="<?= $item->id ?>">(<?= $item->count ?>)</span>
                <?php endif; ?>
            </span>
        </label>
        <?php endif; ?>


        <?php $cmptInit++; ?>
    <?php endforeach; ?>
    </div>

     <?= ($countItems > $maxShow) ? '<div class="showMoreFilters"><span class="chk_'.$moteurEnDouble.$filter->uniqueId.'-hide" uk-toggle="target: .chk_'.$moteurEnDouble.$filter->uniqueId.'-hide;animation: uk-animation-slide-bottom, uk-animation-slide-top"><i class="fa fa-plus"></i></span><span class="chk_'.$moteurEnDouble.$filter->uniqueId.'-hide" uk-toggle="target: .chk_'.$moteurEnDouble.$filter->uniqueId.'-hide;animation: uk-animation-slide-bottom, uk-animation-slide-top" hidden><i class="fa fa-minus"></i></span></div>' : ''; ?>


    <?php // print_r($filter); ?>
    <?php include bridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/filters/common/js-checkbox.php') ; ?>
<?php endif; ?>
<?php  // print_r($filter); ?>
