<?php
	// Vérification du bon paramétrage du filtre
	$isOK = true;
	if (!isset($filter->items) || count($filter->items) <= 0)
	{
		$isOK    = false;
		$message = 'Veuillez définir au moins un élément dans le filtre';
	}
?>

<?php include bridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/filters/common/filter-header.php') ; ?>

<?php if(!$isOK): ?>
	<p>
		<b><?= BridgeCmsAbstractLayer::__('Erreur d\'affichage du filtre', 'plugin-sit') ?></b><br/>
		<?= $message ?>
	</p>
<?php else: ?>

	<div class="calendar uk-grid uk-child-width-1-3@m">

		<div>
			<select class="uk-select bridge-citycombo" id="sel_<?= $moteurEnDouble ?><?= $filter->uniqueId ?>">
				<option value=""><?= BridgeCmsAbstractLayer::__('Sélectionnez un nom de commune','plugin-sit'); ?></option>
				<?php foreach($filter->items as $item): ?>
					<option value="<?= $item->id ?>" id="opt_<?= $moteurEnDouble ?><?= $filter->uniqueId ?>-<?= $item->id ?>" data-item-id="<?= $item->id ?>">
						<?= $item->label ?>
					</option>
				<?php endforeach; ?>
			</select>
		</div>
        <?php include bridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/filters/common/js-select-dropdown.php') ; ?>
	</div>

<?php endif; ?>
