<?php include bridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/filters/common/filter-header.php') ; ?>
<?php $inputIdRacine = 'brflt_' . $moteurEnDouble . $filter->uniqueId ; ?>


<div class="bridge-filter-cityproxdyn" id="bridge-filter-<?= $moteurEnDouble ?><?= $filter->uniqueId ?>">
    <input type="hidden" id="<?= $inputIdRacine ?>_lat" name="latitude" />
    <input type="hidden" id="<?= $inputIdRacine ?>_lon" name="longitude" />
    <div class="bridge-input-geolocation" style="display:flex; flex-direction:row;">
        <input class="bridge-dropdown" autocomplete="off" type="text" id="<?= $inputIdRacine ?>_city" name="city" placeholder="<?= BridgeCmsAbstractLayer::__('Entrez un nom de commune','plugin-sit'); ?>" />
        <button class="bridge_get_user_location" title="<?= BridgeCmsAbstractLayer::esc_attr(BridgeCmsAbstractLayer::__('Ma position','plugin-sit')) ?>" uk-tooltip="<?= BridgeCmsAbstractLayer::esc_attr(BridgeCmsAbstractLayer::__('Ma position','plugin-sit')) ?>"><i class="fa far fa-location-crosshairs"></i></button>
    </div>

    <div class="bridge-gps-distance">
        <label for="<?= $inputIdRacine ?>_dist"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_DISTANCE', 'Distance','plugin-sit'); ?> : <span id="bridge_dist_<?= $moteurEnDouble . $filter->uniqueId ?>_display" class="light"></span></label>
        <input type="range" id="<?= $inputIdRacine ?>_dist" name="distance" min="1000" max="50000" step="1000"/>

    </div>
</div>

<script type="text/javascript">
    // <!--
    bridgeDocumentReady(function() {

        if (!navigator.geolocation) {
            jQuery('.bridge_get_user_location').attr('disabled', 'true');
        } else {
            navigator.geolocation.getCurrentPosition(function(position) {
                window.bridgeCurrentGeolocation = position;
            });
        }
        // Click sur bouton de geolocalisation
        jQuery('#bridge-filter-<?= $moteurEnDouble ?><?= $filter->uniqueId ?> .bridge_get_user_location').click(function (e) {
            e.preventDefault();
            if (navigator.geolocation) {
                if(window.bridgeCurrentGeolocation === undefined) {
                    var ret = navigator.geolocation.getCurrentPosition(function (position) {
                        window.bridgeCurrentGeolocation = position;
                        jQuery('#<?= $inputIdRacine ?>_lat').val(position.coords.latitude);
                        jQuery('#<?= $inputIdRacine ?>_lon').val(position.coords.longitude);
                        jQuery('#<?= $inputIdRacine ?>_city').val('<?= BridgeCmsAbstractLayer::esc_js(BridgeCmsAbstractLayer::__('Ma position', 'plugin-sit')) ?>');
                        jQuery("#<?= $inputIdRacine ?>_city").trigger("change") ;
                        bridgeRefreshGeoSearch<?= $moteurEnDouble ?><?= $filter->uniqueId ?>(window.bridgeCurrentGeolocation.coords.latitude, window.bridgeCurrentGeolocation.coords.longitude);
                    });
                } else {
                    jQuery('#<?= $inputIdRacine ?>_lat').val(window.bridgeCurrentGeolocation.coords.latitude);
                    jQuery('#<?= $inputIdRacine ?>_lon').val(window.bridgeCurrentGeolocation.coords.longitude);
                    jQuery('#<?= $inputIdRacine ?>_city').val('<?= BridgeCmsAbstractLayer::esc_js(BridgeCmsAbstractLayer::__('Ma position', 'plugin-sit')) ?>');
                    jQuery("#<?= $inputIdRacine ?>_city").trigger("change") ;
                    bridgeRefreshGeoSearch<?= $moteurEnDouble ?><?= $filter->uniqueId ?>(window.bridgeCurrentGeolocation.coords.latitude, window.bridgeCurrentGeolocation.coords.longitude);
                }
            } else {
                jQuery('.bridge_get_user_location').attr('disabled', 'true');
            }
        });


        // Màj du label de distance
        jQuery('#<?= $inputIdRacine ?>_dist').on('input', function(e){
            // Evénement pour mettre à jour les étiquettes en temps réel (on input)
            var valuem = parseInt(jQuery(this).val());
            var displayValue = (valuem / 1000) + ' km';
            jQuery("#bridge_dist_<?= $moteurEnDouble . $filter->uniqueId ?>_display").html(displayValue);
            return true;
        });


        window.bridgeCities = [];
        window.cityComboDynOptions<?= $moteurEnDouble ?> = {
            selector: '#<?= $inputIdRacine ?>_city',
            wrapper: true,
            data: {
                src: '', // window.bridgeCities,
                keys: ["label"],
                cache: true
            },
            threshold: 0,
            diacritics: true,
            submit: true,
            trigger: (query) => {
                return true ;  // query.replace(/ /g, "").length; // Returns "Boolean"
            },
            resultsList: {
                maxResults: 1000
            },
            // ouvrir sur clie
            events: {
                input: {
                    focus() {
                        bridgeCityAutocomplete<?= $moteurEnDouble ?>.start();
                        bridgeCityAutocomplete<?= $moteurEnDouble ?>.open();
                    },
                },
            }
        };

        window.ajaxPostData = { action: 'brListCities', get_as_label_array: '1', filter_id: '<?= $filter->id ?>' } ;
        <?php if(isset($listInfos)) : ?>
            window.ajaxPostData.id = '<?= (!empty($listInfos->webListId)) ? $listInfos->webListId : ''; ?>';
            window.ajaxPostData.product_codes = '<?= (!empty($listInfos->productCodes)) ? $listInfos->productCodes : '';?>';
            window.ajaxPostData.item_template = '<?= (isset($listInfos->bridgeModeleListeitem) && !empty($listInfos->bridgeModeleListeitem)) ? $listInfos->bridgeModeleListeitem : '';?>';
            <?php $dynParams = ['filter_city','filter_lat','filter_lon','filter_rayon','selection_id','filter_criterions','scoring','excluded_codes','sort_one','sort_two','sort_three','duplicate_by']; ?>
            <?php foreach ($dynParams as $dynpar): ?>
                window.ajaxPostData['<?= $dynpar ?>'] = '<?= (isset($listInfos->$dynpar) && !empty($listInfos->$dynpar)) ? BridgeCmsAbstractLayer::esc_js($listInfos->$dynpar) : '' ?>';
            <?php endforeach; ?>
        <?php endif; ?>

        window.ajaxPostData.braf = window.bridgeMoteur<?= $moteurId ?>.activeFilters.join(',');
        window.ajaxPostData.brai = window.bridgeMoteur<?= $moteurId ?>.activeItems.join(',');
        // Patch 24/05/22 : les recherches par valeurs n'étaient pas prises en compte
        if(typeof window.bridgeMoteur<?= $moteurId ?>.urlParams === 'object' && window.bridgeMoteur<?= $moteurId ?>.urlParams !== null && Object.keys(window.bridgeMoteur<?= $moteurId ?>.urlParams).length > 0) {
            var keys = Object.keys(window.bridgeMoteur<?= $moteurId ?>.urlParams);
            for(idx in keys) {
                var key = keys[idx];
                window.ajaxPostData[key] = window.bridgeMoteur<?= $moteurId ?>.urlParams[key];
            }
        }
        // Feat 25/05/22 : support du paramètre productCodes où on spécifie des fiches une par une
        if(typeof window.bridgeMoteur<?= $moteurId ?>.options === 'object' && window.bridgeMoteur<?= $moteurId ?>.options.hasOwnProperty('productCodes') ) {
            window.ajaxPostData.product_codes = window.bridgeMoteur<?= $moteurId ?>.options.productCodes ;
        }
        // Evolution 13/02/23 : beaucoup plus de paramètres dynamiques à passer
        const dynParams = ['item_template','filter_city','filter_lat','filter_lon','filter_rayon','selection_id','filter_criterions','scoring','excluded_codes','sort_one','sort_two','sort_three','duplicate_by'];
        for (let i = 0; i < dynParams.length ; i++) {
            if(typeof window.bridgeMoteur<?= $moteurId ?>.options === 'object' && window.bridgeMoteur<?= $moteurId ?>.options.hasOwnProperty(dynParams[i]) ) {
                window.ajaxPostData[dynParams[i]] = window.bridgeMoteur<?= $moteurId ?>.options[dynParams[i]] ;
            }
        }
        jQuery.ajax({
            url: window.bridgeMoteur<?= $moteur->id ?>.options.bridgeAjaxUrl,
            data: ajaxPostData,
            dataType: 'json'
        }).done(function(lejson) {
            window.bridgeCities = lejson;
            // Si une geolocalisation est autorisée, on ajoute "Ma position" à la liste
            if(window.bridgeCurrentGeolocation !== undefined) {
                window.bridgeCities.unshift({
                    label: '<?= BridgeCmsAbstractLayer::esc_js(BridgeCmsAbstractLayer::__('Ma position', 'plugin-sit')) ?>',
                    lat: window.bridgeCurrentGeolocation.coords.latitude,
                    lon: window.bridgeCurrentGeolocation.coords.longitude
                });
            }
            window.cityComboDynOptions<?= $moteurEnDouble ?>.data.src = window.bridgeCities;
            if(typeof window.bridgeCityAutocomplete<?= $moteurEnDouble ?> === 'object') {
                window.bridgeCityAutocomplete<?= $moteurEnDouble ?>.unInit();
            }

            window.bridgeCityAutocomplete<?= $moteurEnDouble ?> = new autoComplete(window.cityComboDynOptions<?= $moteurEnDouble ?>);
            document.querySelector("#<?= $inputIdRacine ?>_city").addEventListener("selection", function (event) {
                if(event.detail && event.detail.selection && event.detail.selection.value && event.detail.selection.value !== '') {
                    jQuery("#<?= $inputIdRacine ?>_city").val(event.detail.selection.value.label);
                    jQuery("#<?= $inputIdRacine ?>_lat").val(event.detail.selection.value.lat);
                    jQuery("#<?= $inputIdRacine ?>_lon").val(event.detail.selection.value.lon);
                    jQuery("#<?= $inputIdRacine ?>_city").trigger("change") ;
                    bridgeRefreshGeoSearch<?= $moteurEnDouble ?><?= $filter->uniqueId ?>(event.detail.selection.value.lat, event.detail.selection.value.lon);
                }
            });

        });


        // Recalculer les villes après une modification du moteur
        /* Problème : après avoir sélectionné une ville, si on active ce code, la liste devient torp restreinte
        window.bridgeMoteur<?= $moteur->id ?>.addEventHandler('beforeSubmit', function(bridgeMoteur) {
            window.ajaxPostData = { action: 'brListCities', get_as_label_array: '1' } ;
            <?php if(isset($listInfos)) : ?>
            window.ajaxPostData.id = '<?= $listInfos->webListId ?>';
            window.ajaxPostData.product_codes = '<?= $listInfos->productCodes ?>';
            <?php endif; ?>

            window.ajaxPostData.braf = window.bridgeMoteur<?= $moteurId ?>.activeFilters.join(',');
            window.ajaxPostData.brai = window.bridgeMoteur<?= $moteurId ?>.activeItems.join(',');
            // Patch 24/05/22 : les recherches par valeurs n'étaient pas prises en compte
            if(typeof window.bridgeMoteur<?= $moteurId ?>.urlParams === 'object' && window.bridgeMoteur<?= $moteurId ?>.urlParams !== null && Object.keys(window.bridgeMoteur<?= $moteurId ?>.urlParams).length > 0) {
                var keys = Object.keys(window.bridgeMoteur<?= $moteurId ?>.urlParams);
                for(idx in keys) {
                    var key = keys[idx];
                    window.ajaxPostData[key] = window.bridgeMoteur<?= $moteurId ?>.urlParams[key];
                }
            }
            // Feat 25/05/22 : support du paramètre productCodes où on spécifie des fiches une par une
            if(typeof window.bridgeMoteur<?= $moteurId ?>.options === 'object' && window.bridgeMoteur<?= $moteurId ?>.options.hasOwnProperty('productCodes') ) {
                window.ajaxPostData.product_codes = window.bridgeMoteur<?= $moteurId ?>.options.productCodes ;
            }

            jQuery.ajax({
                url: window.bridgeMoteur<?= $moteur->id ?>.options.bridgeAjaxUrl,
                data: ajaxPostData,
                dataType: 'json'
            }).done(function(lejson) {
                window.bridgeCities = lejson;
                window.cityComboDynOptions<?= $moteurEnDouble ?>.data.src = window.bridgeCities;
                if(typeof window.bridgeCityAutocomplete<?= $moteurEnDouble ?> === 'object') {
                    window.bridgeCityAutocomplete<?= $moteurEnDouble ?>.unInit();
                }
                window.bridgeCityAutocomplete<?= $moteurEnDouble ?> = new autoComplete(window.cityComboDynOptions<?= $moteurEnDouble ?>);
            }).error(function(e){
                console.error(e);
            });
        });
        */

    });

    // -->
</script>
<?php include bridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/filters/common/js-input-gps.php') ; ?>
