<?php
// Vérification du bon paramétrage du filtre
$isOK = true;
if(!isset($filter->items) || count($filter->items) <= 0)
{
	$isOK    = false;
	$message = 'Veuillez définir au moins un élément dans le filtre';
}

$displayResults = isset($filter->parameters) && isset($filter->parameters->display_results) && $filter->parameters->display_results;

?>
<?php if(!$isOK): ?>
    <p>
        <b>Erreur d'affichage du filtre</b><br/>
		<?= $message ?>
    </p>
<?php else: ?>

    <?php include bridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/filters/common/filter-header.php') ; ?>

    <div class="bridge-filter-onoff" id="bridge-filter-<?= $moteurEnDouble ?><?= $filter->uniqueId ?>">
		<?php foreach($filter->items as $item): ?>
            <label for="chk_<?= $moteurEnDouble ?><?= $filter->uniqueId ?>-<?= $item->id ?>" data-item-id="<?= $item->id ?>">
                <div class="bridge-onoff-toggle">
                    <input 
                        class="bridge-onoff-toggle-state <?php if($displayResults && $item->count <= 0): ?>bridge-disabled<?php endif; ?>"
                        type="checkbox" 
                        id="chk_<?= $moteurEnDouble ?><?= $filter->uniqueId ?>-<?= $item->id ?>" 
                        data-item-id="<?= $item->id ?>" 
                        <?php if($displayResults && $item->count <= 0): ?> disabled <?php endif; ?>
                    />
                    <div class="bridge-onoff-toggle-inner <?php if($displayResults && $item->count <= 0): ?>bridge-disabled<?php endif; ?>">
                        <div class="bridge-onoff-indicator"></div>
                    </div>
                    <div class="bridge-onoff-active-bg"></div>
                </div>
                <div class="bridge-label" <?php if($displayResults && $item->count <= 0): ?>bridge-disabled<?php endif; ?>>
                    <?php // Nouveau 19/04/23 : images de filtres ?>
                    <?php if (isset($item->image) && !empty($item->image)): ?>
                        <span class="bridge-engine-image-container">
                            <?= BridgeBlockService::renderEngineImage($item->image,$item->label); ?>
                        </span>
                    <?php endif; ?>
                    <?= $item->label ?>
                    <?php if($displayResults): ?>
						<span class="bridge-count" data-item-id="<?= $item->id ?>">(<?= $item->count ?>)</span>
					<?php endif; ?>
                </div>
            </label>
		<?php endforeach; ?>
    </div>

    <?php include bridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/filters/common/js-checkbox.php') ; ?>
	<?php // print_r($filter); ?>
<?php endif; ?>
