<?php
/**
 * Template d'affichage de contenu de moteur d'affinage dans les listes
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/liste/moteur
 *
 * @version 3.3.22
 *
 */

$moteurSectionContainerTag = (isset($bridgeParameters->tag_moteur_titre_section) && !empty($bridgeParameters->tag_moteur_titre_section)) ? $bridgeParameters->tag_moteur_titre_section : 'h4' ;
$moteurSubSectionContainerTag = (isset($bridgeParameters->tag_moteur_titre_subsection) && !empty($bridgeParameters->tag_moteur_titre_subsection)) ? $bridgeParameters->tag_moteur_titre_subsection : 'h5' ;


$modeMultiMoteur = false;
$indexSwitchMultiMoteur = 1;
$multiMoteursAfficherSections = false;
$moteurSections = array();
if(isset($listParameters) && isset($listParameters->modeMultiMoteurs) && $listParameters->modeMultiMoteurs === true) {
    $modeMultiMoteur = true;
    $multiMoteursAfficherSections = $listParameters->multiMoteursAfficherSections;
    $indexSwitchMultiMoteur = (int) $listParameters->multiMoteursIndexfiltreSwitch;
    foreach ($moteur->sections as $section) {
        $moteurSections[] = $section->id;
    }
}

$idxSection = 1 ;

foreach ($moteur->sections as $section):  if(isset($_GET['dncdebug']) && $_GET['dncdebug']=="Y") print_r($section->sectionWidth); ?>
    <?php $idxFiltreSection = 1 ; ?>


    <?php $shownByItemsChecked = []; ?>
    <?php $shownByItemsUnchecked = []; ?>
    <?php $hiddenByItemsChecked = []; ?>
    <?php $hiddenByItemsUnchecked = []; ?>
    <?php if(is_array($section->displayConditions) && count($section->displayConditions) > 0): ?>
    <?php foreach($section->displayConditions as $displayCondition): ?>
    <?php  if($displayCondition->operator->value == 'checked' && $displayCondition->action == 'Montrer' && !in_array($displayCondition->itemId, $shownByItemsChecked)) $shownByItemsChecked[] = $displayCondition->itemId ?>
    <?php  if($displayCondition->operator->value == 'notchecked' && $displayCondition->action == 'Montrer' && !in_array($displayCondition->itemId, $shownByItemsUnchecked)) $shownByItemsUnchecked[] = $displayCondition->itemId ?>
    <?php  if($displayCondition->operator->value == 'checked' && $displayCondition->action == 'Masquer' && !in_array($displayCondition->itemId, $hiddenByItemsChecked)) $hiddenByItemsChecked[] = $displayCondition->itemId ?>
    <?php  if($displayCondition->operator->value == 'notchecked' && $displayCondition->action == 'Masquer' && !in_array($displayCondition->itemId, $hiddenByItemsUnchecked)) $hiddenByItemsUnchecked[] = $displayCondition->itemId ?>
    <?php endforeach; ?>
    <?php endif; ?>
    <?php $styleSection = ''; ?>
    <?php if($modeMultiMoteur && !$multiMoteursAfficherSections && $idxSection > 1) $styleSection = 'display:none;'; ?>
    <div class="bridge-moteur-section moteur-section-<?= $section->id; ?> uk-inline" style="<?= $styleSection ?>" data-section-id="<?= $section->id ?>"
            data-bridge-sbic="|<?= implode('|', $shownByItemsChecked) ?>|"
            data-bridge-hbic="|<?= implode('|', $hiddenByItemsChecked) ?>|"
            data-bridge-sbiu="|<?= implode('|', $shownByItemsUnchecked) ?>|"
            data-bridge-hbiu="|<?= implode('|', $hiddenByItemsUnchecked) ?>|"
            data-bridge-hiddendefault="<?= $section->hiddenByDefault ? 'true' : 'false' ?>">
        <?php if(!empty($section->label)): ?>
        <a class="uk-button uk-button-default uk-margin-left">
            <?= $section->label; ?>
        </a>
        <?php endif; ?>
        <div uk-dropdown="boundary: !.bridge-toolbar; stretch: x;animation: slide-top; animate-out: true; duration: 300;pos: bottom-center;flip:false">
        <div uk-grid class="<?= BridgeUtils::getChildColumns($section->sectionColumns); ?>">
            <?php foreach ($section->subSections as $subsection): ?>
                <div class="subsection <?= 'ssmoteur-' . $subsection->id; ?> <?= BridgeBlockService::renderWidth($subsection->subSectionWidth) ?>">
                    <?php if (!empty($subsection->label)): ?>
                        <<?= $moteurSubSectionContainerTag ?> class="moteur-section-label moteur-subsection-label uk-heading-line">
                            <span><?= $subsection->label; ?></span>
                        </<?= $moteurSubSectionContainerTag ?>>
                    <?php endif; ?>
                    <div uk-grid class="<?= BridgeUtils::getChildColumns($subsection->subSectionColumns); ?>">
                        <?php foreach ($subsection->filters as $filter) : ?>
                            <div>
                                <?php
                                $template = bridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/filters/' . $filter->displayType . '.php');
                                if (!file_exists($template))
                                    echo "ERREUR : template de filtre non trouvé : " . $filter->displayType;
                                else
                                    include $template;
                                ?>
                            </div>
                            <?php $idxFiltreSection++ ; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        </div>
    </div>
    <?php $idxSection++; ?>
<?php endforeach; ?>
