<?php
/**
 * Template d'affichage de moteur d'affinage dans les listes
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/liste/moteur
 *
 * @version 3.2.6
 *
 */
?>
<?php $moteurEnDouble = ''; ?>

<?php if (count($moteur->sections) > 0) : ?>
    <section class="bridge-moteur-sit moteurs" data-bridge-moteur-id="<?= $moteur->id ?>">
        <input type="hidden" name="bridge_active_filters_<?= $moteur->id ?>" value=""/>
        <?php // Ce moteur nexiste que pour la versoin responsive des listes où il y a un moteur affiché directement ?>
        <?php // On l'enlève des listes où le moteur est nativement en off-canvas ?>
        <?php // update : on a sorti le gabarit moteur-mobile pour pouvoir l'insérer directement dans liste1 et liste2 ?>
        <?php $listesAvecMoteurMobileSepare = array ('liste1', 'liste2'); ?>

        <?php $moteurEnDouble = 'M2'; ?>
        <?php // Pour les listes avec moteur off-canvas natif ?>
        <?php if(!isset($listInfos->bridgeModeleListe) || !in_array($listInfos->bridgeModeleListe, $listesAvecMoteurMobileSepare)): // , $listesSansMoteurMobile) ?>
            <div class="uk-width-1-1">
                <div class="uk-width-1-1 uk-h3 uk-text-center bridge-moteur-titre">
                    <?= BridgeCmsAbstractLayer::__('Rechercher', 'plugin-sit'); ?>
                </div>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/moteur-body.php'); ?>
            </div>
        <?php else: ?>
            <?php // Listes sans off-canvas natif ?>
            <div class="boundary-align uk-visible@m uk-width-1-1 uk-panel bridge-moteur-side">
                <div class="uk-width-1-1 uk-h3 uk-text-left bridge-moteur-titre">
                    <?= BridgeCmsAbstractLayer::__('Rechercher', 'plugin-sit'); ?>
                </div>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/moteur-body.php'); ?>
            </div>
        <?php endif; ?>
    </section>
<?php endif; ?>
