<?php
/**
 * Template d'affichage de pagination infinite scroll
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/liste/pagination
 *
 * @version 3.2.6
 *
 */

?>
<div class="bridge-view-more-button-container uk-text-center">
    <button class="bridge-view-more-button uk-button" id="bridge_view_more_<?= $listParameters->uniqueIdentifier ?>" style="display:none;">
        <?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_VOIR_PLUS', 'Voir plus', 'plugin-sit') ?>
    </button>
</div>
<div class="scroll-status uk-margin-bottom" id="infinite_spinner_<?= $listParameters->uniqueIdentifier ?>">
    <div class="loader-ellips infinite-scroll-request">
        <span class="loader-ellips__dot"></span>
        <span class="loader-ellips__dot"></span>
        <span class="loader-ellips__dot"></span>
        <span class="loader-ellips__dot"></span>
    </div>
    <p class="infinite-scroll-error" style="display:none;"><?= BridgeCmsAbstractLayer::__mp('COM_PYLOT_BRIDGE_TOUT_EST_CHARGE','Tout est chargé','plugin-sit'); ?></p>
</div>

<?php

/*
<div class="infinite-scroll-last uk-margin uk-text-center" style="display:none;"><?= BridgeCmsAbstractLayer::__('Fin des résultats','plugin-sit'); ?></div>
*/ ?>

<script type="text/javascript">
    // <!--

    bridgeDocumentReady(function() {
        jQuery('#bridge-liste-<?= $listParameters->uniqueIdentifier ?>').find('.bridge-pagination').hide();

        window.bridgeActivateInfiniteScroll_<?= $listParameters->uniqueIdentifier ?> = function (total) {

            <?php if($listParameters->paginationType == 'INFINITE_SCROLL_AVEC_BOUTON'): ?>
            jQuery('#bridge-liste-<?= $listParameters->uniqueIdentifier ?>').find('.bridge-view-more-button').show();
            jQuery('#bridge-liste-<?= $listParameters->uniqueIdentifier ?>').find('.bridge-view-more-button-container').show();
            <?php endif; ?>

            if (!total || total == undefined) {
                window.bridgeTotalResults = <?= $listInfos->totalProducts; ?>;
            } else {
                window.bridgeTotalResults = total;
                if(total == 0 && window.bridgeInfiniteScroll_<?= $listParameters->uniqueIdentifier ?> !== undefined) {
                    window.bridgeInfiniteScroll_<?= $listParameters->uniqueIdentifier ?>.unbind();
                }
            }

            if(window.bridgeInfiniteScroll_<?= $listParameters->uniqueIdentifier ?> !== undefined) {
                window.bridgeInfiniteScroll_<?= $listParameters->uniqueIdentifier ?>.unbind();
            }

            var nextSelector = '.bridge-next-ajax';
            if(jQuery(nextSelector).length > 1) {
                nextSelector = '#bridge_next_ajax_<?= $listParameters->uniqueIdentifier ?>';
            }
            window.bridgeInfiniteScroll_<?= $listParameters->uniqueIdentifier ?> = new InfiniteAjaxScroll('#listeSIT_<?= $listParameters->uniqueIdentifier ?>', {
                item: '.liste_sit_item',
                <?php if($listParameters->paginationType == 'INFINITE_SCROLL_AVEC_BOUTON'): ?>
                    prefill: false,
                    next: nextSelector,
                <?php else: ?>
                    prefill: true,
                    next: nextSelector,
                <?php endif; ?>
                spinner: '#infinite_spinner_<?= $listParameters->uniqueIdentifier ?>',
                <?php if($listParameters->paginationType == 'INFINITE_SCROLL_AVEC_BOUTON'): ?>
                trigger: document.getElementById('bridge_view_more_<?= $listParameters->uniqueIdentifier ?>'),
                <?php endif; ?>
                pagination: '.bridge-pagination',
                logger: false
            });
            window.bridgeInfiniteScroll_<?= $listParameters->uniqueIdentifier ?>.on('page', (event) => {
                /*
                // update the title
                document.title = event.title;

                // update the url
                let state = history.state;
                history.replaceState(state, event.title, event.url);
                 */
            });

            window.bridgeInfiniteScroll_<?= $listParameters->uniqueIdentifier ?>.on('appended', (event) => {
                // Lors de l'ajout d'éléments, on ajoute les actions javascript sur les nouveaux éléments
                var $items = jQuery(event.parent);

                if(window.mapService) {
                    $items.find('.zoom-on-hover').hover(function () {
                        var zoomLevel = 14;
                        var testZoomLevel = jQuery(this).attr('data-dnc-zoom-level');
                        if (testZoomLevel !== null && testZoomLevel !== '')
                            zoomLevel = parseInt(testZoomLevel);
                        var idfiche = jQuery(this).attr('data-dnc-produit');
                        if (idfiche !== '') {
                            window.mapService.activatemarker(idfiche, true, true); // window.mapService.defaultIconOptions
                            window.mapService.centeronmarker(idfiche, zoomLevel);
                            // tricherie obligatoire pour forcer le point à s'afficher la premiere fois
                            setTimeout(function () {
                                window.mapService.setZoom(zoomLevel);
                            }, 500);
                            window.mapService.reDraw();

                        }
                    });
                    $items.find('.zoom-on-click').click(function () {
                        var zoomLevel = 14;
                        var testZoomLevel = jQuery(this).attr('data-dnc-zoom-level');
                        if (testZoomLevel !== null && testZoomLevel !== '')
                            zoomLevel = parseInt(testZoomLevel);
                        var idfiche = jQuery(this).attr('data-dnc-produit');
                        if (idfiche !== '') {
                            window.mapService.activatemarker(idfiche, true, true); // window.mapService.defaultIconOptions
                            window.mapService.centeronmarker(idfiche, zoomLevel);
                            // tricherie obligatoire pour forcer le point à s'afficher la premiere fois
                            setTimeout(function () {
                                window.mapService.setZoom(zoomLevel);
                            }, 500);
                            window.mapService.reDraw();

                        }
                    });
                }

                <?php if($bridgeParameters->fiches_iframe == '1'): ?>
                // Ouverture de la fiche en iframe
                var $items = jQuery(event.parent);
                $items.find('article.ficheproduit a').click(function(e) {
                    e.preventDefault();
                    e.stopImmediatePropagation();
                    jQuery('.bridge-loader').fadeIn({ duration: 100 });
                    var link = jQuery(this).attr('href');
                    var iframejQuery = jQuery('#bridge-iframe-fiche-<?= $listParameters->uniqueIdentifier ?>');
                    // On repositionne le scroll sur le haut de l'iframe
                    jQuery([document.documentElement, document.body]).animate({
                        scrollTop: jQuery('#bridge-iframe-fiche-<?= $listParameters->uniqueIdentifier ?>').offset().top
                    }, 500);
                    iframejQuery.show();
                    iframejQuery.attr('src', link);
                });
                <?php endif; ?>
            });

            window.bridgeInfiniteScroll_<?= $listParameters->uniqueIdentifier ?>.on('last', () => {
                jQuery('.infinite-scroll-last').show();
                jQuery('#bridge_view_more_<?= $listParameters->uniqueIdentifier ?>').hide();
            })

        };

        <?php if($listInfos->lastPage > $listInfos->currentPage): ?>
            // Important : si l'infinite scroll est déclenché trop tôt et que la carte est masquée, on peut avoir des comportement bizarres de leaflet avec des quantités énormes de chargement de tuiles
            setTimeout(function() {
                window.bridgeActivateInfiniteScroll_<?= $listParameters->uniqueIdentifier ?>();
            }, 3500);

        <?php endif; ?>
    });
    // -->
</script>
