<?php
/**
 * Template d'affichage de pagination
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/liste/pagination
 *
 * @version 3.2.6
 *
 */

// Nombre de liens de pages à afficher de part et d'autre de la page courante
$nbLinks = 1 ;

$start      = ( ( $listInfos->currentPage - $nbLinks ) > 0 ) ? $listInfos->currentPage - $nbLinks : 1;
$end        = ( ( $listInfos->currentPage + $nbLinks ) < $listInfos->lastPage ) ? $listInfos->currentPage + $nbLinks : $listInfos->lastPage;

$currentUrl = $bridgeParameters->currentUrl ; //  '&limit=' . $listInfos->limitPerPage ;
$paginationUrlParams = $bridgeParameters->paginationUrlParams ;
$separator = '&';
if(empty($paginationUrlParams)) {
    $separator = '?';
}
$additionalParams = '';

if(strpos($paginationUrlParams, 'product_codes') === false)
    $additionalParams = 'product_codes=' . $listInfos->productCodes . '&';
if(strpos($paginationUrlParams, 'item_template') === false)
    $additionalParams .= 'item_template=' . $listInfos->bridgeModeleListeitem . '&';

$dynParams = ['filter_city','filter_lat','filter_lon','filter_rayon','selection_id','filter_criterions','scoring','excluded_codes','sort_one','sort_two','sort_three','duplicate_by'];
foreach ($dynParams as $dynpar) {
    if(isset($listInfos->$dynpar) && !empty($listInfos->$dynpar) && strpos($paginationUrlParams, $dynpar) === false) {
        $additionalParams .= $dynpar . '=' . urlencode($listInfos->$dynpar) . '&';
    }
}

$infiniteParams = '';
if(strpos($paginationUrlParams, 'action=brListeInfinite') === false) {
    $infiniteParams = 'action=brListeInfinite&id=' . $listInfos->webListId . '&' . $additionalParams ;
}

if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug'] == 'PAGINATION') {
    echo "paginationUrlParams : $paginationUrlParams <br/>\n";
    echo "additionalParams : $additionalParams <br/>\n";
    echo "infiniteParams : $infiniteParams <br/>\n";
    echo "currentUrl : $currentUrl <br/>\n";
}

$paginationContainerTag = (isset($bridgeParameters->tag_list_pagination) && !empty($bridgeParameters->tag_list_pagination)) ? $bridgeParameters->tag_list_pagination : 'div' ;


// On test si il y a plus qu'une page
if($listInfos->totalProducts > $listInfos->limitPerPage):
?>
<<?= $paginationContainerTag ?> id="bridge-pagination-container-<?= $listParameters->uniqueIdentifier ?>" class="bridge-pagination-container uk-margin-top">
    <ul class="bridge-pagination uk-pagination uk-flex-center" uk-margin>

        <?php if($listInfos->currentPage == 1 ): ?>
            <li class="uk-disabled">
                <a class="bridge-pagination-link pager__previous bridge-prev" data-page="1" href="#nogo"><span uk-pagination-previous></span></a>
            </li>
        <?php else: ?>
            <li class="">
                <a class="bridge-pagination-link bridge-prev" data-page="<?= ( $listInfos->currentPage - 1 ) ?>" href="<?= $currentUrl . $paginationUrlParams . $separator . $additionalParams ?>brpa=<?= ( $listInfos->currentPage - 1 ) ?>"><span uk-pagination-previous></span></a>
            </li>
        <?php endif; ?>

        <?php if ( $start > 1 ): ?>
            <li class="uk-visible@m"><a class="bridge-pagination-link" data-page="1" href="<?= $currentUrl . $paginationUrlParams . $separator . $additionalParams?>brpa=1">1</a></li>
            <li class="uk-disabled nolink"><span>...</span></li>
        <?php endif; ?>

        <?php for ( $i = $start ; $i <= $end; $i++ ): ?>
            <?php if ($listInfos->currentPage == $i): ?>
                <li class="uk-active"><a class="bridge-pagination-link" data-page="<?= $i ?>" href="#nogo"><?= $i ?></a></li>
            <?php else: ?>
                <li class=""><a class="bridge-pagination-link" data-page="<?= $i ?>" href="<?= $currentUrl . $paginationUrlParams . $separator . $additionalParams ?>brpa=<?= $i ?>"><?= $i ?></a></li>
            <?php endif; ?>
        <?php endfor; ?>

        <?php if ( $end < $listInfos->lastPage ): ?>
            <li class="uk-disabled nolink"><span>...</span></li>
            <li class="uk-visible@m"><a class="bridge-pagination-link" data-page="<?= $listInfos->lastPage ?>" href="<?= $currentUrl . $paginationUrlParams . $separator . $additionalParams?>brpa=<?= $listInfos->lastPage ?>"><?= $listInfos->lastPage ?></a></li>
        <?php endif; ?>

        <?php if($listInfos->currentPage == $listInfos->lastPage  ): ?>
            <li class="uk-disabled">
                <a class="bridge-pagination-link" data-page="" id="bridge_next_<?= $listParameters->uniqueIdentifier ?>" <?php // href="{#nogo}" ?>><span uk-pagination-next></span>&nbsp;</a>
                <?php /* <a class="bridge-pagination-link" data-page="" id="bridge_next_ajax_<?= $listParameters->uniqueIdentifier ?>" href="{#nogo}" style="display:none;"><span uk-pagination-next></span>&nbsp;</a> */ ?>
            </li>
        <?php else: ?>
            <li class="">
                <a class="bridge-pagination-link bridge-next" id="bridge_next_<?= $listParameters->uniqueIdentifier ?>" data-page="<?= ( $listInfos->currentPage + 1 ) ?>" href="<?= $currentUrl . $paginationUrlParams . $separator . $additionalParams ?>brpa=<?= ( $listInfos->currentPage + 1 ) ?>"><span uk-pagination-next></span></a>
                <a class="bridge-pagination-link bridge-next-ajax" id="bridge_next_ajax_<?= $listParameters->uniqueIdentifier ?>" rel="nofollow" data-page="<?= ( $listInfos->currentPage + 1 ) ?>" href="<?= $listInfos->bridgeAjaxUrl . $paginationUrlParams . ((strpos($listInfos->bridgeAjaxUrl . $paginationUrlParams, '?') === false?'?':'&')) . $infiniteParams ?>brpa=<?= ( $listInfos->currentPage + 1 ) ?>" style="display:none;"><span uk-pagination-next></span></a>
            </li>
        <?php endif; ?>



    </ul>
</<?= $paginationContainerTag ?>>
<?php endif; ?>
