<?php
/**
 * Template d'affichage de liste liste 4
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/liste
 *
 * @version 3.2.0
 *
 */
?>
<?php $moteurEnDouble = ''; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_before') ; ?>
    <div class="bridge-quick-search">
        <?php $minSection=1; $maxSection=1; ?>
        <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/specifique/mosl/moteur-body-mosl.php'); ?>
    </div>

    <div class="bridge-liste liste4"  uk-grid>
        <div class="uk-width-2-3@m" uk-filter="target: .filter-sit">
            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_before_toolbar') ; ?>
            <div class="bridge-toolbar uk-padding-small">
                <div>
                    <div class="uk-width-1-1 uk-flex-between uk-grid-collapse" uk-grid>
                        <div class="bridge-filtre uk-flex uk-flex-between">
                            <div>
                            <?php if (isset($moteur) && is_object($moteur) && !empty($moteur->id)): ?>
                                <a class="filters uk-margin-left" href="#"
                                   uk-toggle="target: #offcanvas-moteur<?= $moteur->id ?>"><?php /* <i class="fa fa-filter"></i> */ ?>
                                    <?= BridgeCmsAbstractLayer::__('Filtres', 'plugin-sit'); ?>
                                </a>
                            <?php endif; ?>
                            </div>
                            <div class="uk-margin-left">

                            </div>

                        </div>
                        <div class="bridge-sort uk-visible@m">
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/tris/tris.php'); ?>
                        </div>
                        <div class="bridge-sort uk-hidden@m">
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/tris/tris-dropdown.php'); ?>
                        </div>
                        <div class="uk-flex uk-flex-between uk-flex-end uk-flex-middle">
                            <div class="totals uk-visible@m">
                                <?= sprintf(BridgeCmsAbstractLayer::_n('<span class="listeSITCount">%s</span> résultat', '<span class="listeSITCount">%s</span> résultats', $listInfos->totalProducts, 'plugin-sit'), $listInfos->totalProducts); ?>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="bridgeActiveFiltersDiv uk-width-1-1"></div>
            </div>
            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_after_toolbar') ; ?>
            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_before_results') ; ?>
            <div id="listeSIT"
                 class="listeSIT uk-grid-match filter-sit uk-grid-<?= $listParameters->spacingColumn; ?> uk-child-width-1-<?= ($listParameters->numberColumn->xl) ? $listParameters->numberColumn->xl . '@xl' : $listParameters->numberColumn->default . '@xl'; ?> uk-child-width-1-<?= ($listParameters->numberColumn->l) ? $listParameters->numberColumn->l . '@l' : $listParameters->numberColumn->default . '@l'; ?> uk-child-width-1-<?= ($listParameters->numberColumn->m) ? $listParameters->numberColumn->m . '@m' : $listParameters->numberColumn->default . '@m'; ?> uk-child-width-1-<?= ($listParameters->numberColumn->s) ? $listParameters->numberColumn->s . '@s' : $listParameters->numberColumn->default . '@s'; ?>"
                 uk-grid uk-height-match="target: > div > article > .uk-card"
                 aauk-scrollspy="target: > div; cls: uk-animation-fade; delay: 300">
                <?php if (isset($data) && $listInfos->totalProducts > 0) : ?>
                    <?php foreach ($data->selection->results->products as $fiche) : ?>
                        <?php $photo = ''; ?>
                        <?php $photo2 = ''; ?>
                        <?php $images = BridgeBlockService::extractPhotos($fiche->listBlocks, 'photo'); ?>
                        <?php if (count($images) > 0): ?>
                            <?php $photo = $images[0]->url; ?>
                        <?php elseif (isset($listParameters->defaultImage) && isset($listParameters->defaultImage->url) && !empty($listParameters->defaultImage->url)): ?>
                            <?php $photo = $listParameters->defaultImage->url; ?>
                        <?php endif; ?>
                        <?php if (count($images) > 1): ?>
                            <?php $photo2 = $images[1]->url; ?>
                        <?php endif; ?>
                        <div class="liste_sit_item" data-dnc-produit="<?= $fiche->productCode ?>">
                            <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/gabarits/' . $listInfos->bridgeModeleListeitem . '.php'); ?>
                        </div>
                    <?php endforeach; ?>
                <?php else : ?>
                    <h4 class="center"><?= BridgeCmsAbstractLayer::__('Aucun résultat', 'plugin-sit') ?></h4>
                    <p class="center"><?= BridgeCmsAbstractLayer::__('La liste est vide avec ces critères.', 'plugin-sit'); ?></p>
                <?php endif; ?>
            </div>
            <?php if($listParameters->paginationType == 'PAGINATION'): ?>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/pagination/pagination.php'); ?>
            <?php elseif($listParameters->paginationType == 'INFINITE_SCROLL'): ?>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/pagination/pagination.php'); ?>
                <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/pagination/infinitescroll.php'); ?>
            <?php endif; ?>
            <?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_after_results') ; ?>
        </div>
        <div class="uk-width-1-3@m uk-visible@m">
            <div id="maps" class="uk-overflow-hidden uk-position-relative uk-height-1-1">
                <div id="mapsSIT" class="uk-height-viewport uk-width-1-1" uk-sticky="top: true;bottom:#listSIT "></div>
            </div>
        </div>
    </div>
    <div id="listSIT"></div>

<?php // OFF CANVAS PARTIEL ?>
<?php if (isset($moteur) && is_object($moteur) && !empty($moteur->id)): ?><div id="offcanvas-moteur<?= $moteur->id ?>" class="zone-moteur off-canvas-moteur-mobile bridge-moteur-sit" uk-offcanvas="mode: none; overlay: false; ">
        <div class="uk-offcanvas-bar uk-light uk-offcanvas-bar-animation uk-offcanvas-slide">
            <button class="uk-offcanvas-close" type="button" uk-close></button>
            <h3>
                <?= BridgeCmsAbstractLayer::__('Rechercher', 'plugin-sit'); ?>
            </h3>
            <?php $minSection=2; $maxSection=999; ?>
            <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/specifique/mosl/moteur-body-mosl.php'); ?>
        </div>
    </div>


<?php /* OFF CANVAS MOBILE ?>
<?php $moteurEnDouble = 'M2'; ?>
    <?php $minSection=1; $maxSection=999; ?>
    <div id="offcanvas-moteur<?= $moteur->id ?>-mobile" class="zone-moteur off-canvas-moteur-mobile bridge-moteur-sit" uk-offcanvas="overlay: true">
        <div class="uk-offcanvas-bar uk-light uk-offcanvas-bar-animation uk-offcanvas-slide">
            <button class="uk-offcanvas-close" type="button" uk-close></button>
            <h3>
                <?= BridgeCmsAbstractLayer::__('Rechercher', 'plugin-sit'); ?>
            </h3>
            <?php $minSection=1; $maxSection=999; ?>
            <?php include BridgeUtils::bridge_locate_template('templates-bridge/liste/specifique/mosl/moteur-body-mosl.php'); ?>
        </div>
    </div>
*/ ?>
<?php endif; ?>
<?php BridgeCmsAbstractLayer::doDisplayHook('bridge_liste_after_results') ; ?>

<style type="text/css">
    .uk-offcanvas-bar { width: 28vw; }
    @media (min-width: 960px)
        .uk-offcanvas-bar {
            width:100vw;
        }
</style>
