<?php
/**
 * Template d'affichage de contenu de moteur d'affinage dans les listes
 *
 * Ce template peut être overridé individuellement en le copiant dans le dossier du thème actif
 * MonTheme/plugin-sit/templates/templates-bridge/liste/moteur
 *
 * @version 3.2
 *
 */

$modeMultiMoteur = false;
$indexSwitchMultiMoteur = 1;
$moteurSections = array();
if(isset($listParameters) && isset($listParameters->modeMultiMoteurs) && $listParameters->modeMultiMoteurs === true) {
    $modeMultiMoteur = true;
    $indexSwitchMultiMoteur = (int) $listParameters->multiMoteursIndexfiltreSwitch;
    foreach ($moteur->sections as $section) {
        $moteurSections[] = $section->id;
    }
}

$idxSection = 1 ;

foreach ($moteur->sections as $section): ?>
    <?php
    // Spécifique Moselle : couper le moteur en deux parties
    if($modeMultiMoteur && isset($minSection) && $minSection > $idxSection) {
        echo '<div class="bridge-moteur-section moteur-section-'.$section->id . '" style="display:none;"></div>';
        $idxSection++;
        continue;
    }

    if ($modeMultiMoteur && isset($maxSection) && $maxSection < $idxSection) {
        $idxSection++;
        continue;
    }
    $attrSections = '';
    if($modeMultiMoteur && $idxSection == 1 ) $attrSections='uk-grid';

    ?>

    <?php $idxFiltreSection = 1 ; ?>
    <span class="bridgeActiveFiltersDivSection bridgeActiveFiltersDivSection<?= $section->id ?>" data-section-id="<?= $section->id ?>"></span>
    <?php $styleSection = ''; ?>
    <?php if($modeMultiMoteur && $idxSection > 1) $styleSection = 'display:none;'; ?>
    <div class="bridge-moteur-section moteur-section-<?= $section->id; ?> uk-margin" style="<?= $styleSection ?>">
        <?php if(!empty($section->label)): ?>
        <h4 class="moteur-section-label">
            <?= $section->label; ?>
        </h4>
        <?php endif; ?>
        <div uk-grid class="<?= BridgeUtils::getChildColumns($section->sectionColumns); ?>">
            <?php foreach ($section->subSections as $subsection): ?>
                <div class="subsection <?= 'ssmoteur-' . $subsection->id; ?> <?= BridgeBlockService::renderWidth($subsection->subSectionWidth) ?>">
                    <?php if (!empty($subsection->label)): ?>
                        <h5 class="moteur-section-label uk-heading-line">
                            <span><?= $subsection->label; ?></span>
                        </h5>
                    <?php endif; ?>
                    <div uk-grid class="<?= BridgeUtils::getChildColumns($subsection->subSectionColumns); ?>">
                        <?php foreach ($subsection->filters as $filter) : ?>
                            <div>
                                <?php
                                $template = bridgeUtils::bridge_locate_template('templates-bridge/liste/moteur/filters/' . $filter->displayType . '.php');
                                if (!file_exists($template))
                                    echo "ERREUR : template de filtre non trouvé : " . $filter->displayType;
                                else
                                    include $template;
                                ?>
                            </div>
                            <?php $idxFiltreSection++ ; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php $idxSection++; ?>
<?php endforeach; ?>