<?php if(!isset($bridge_scripts_tris_deja_charges)): ?>
<script type="text/javascript">
    // <!--
    /**
     * Affichage des tris par l'utilisateur
     */

    bridgeDocumentReady(function() {

        // On note s'il y a un moteur associé à la liste ou non
        const moteurId = '<?= $moteurToUse->id ?>';

        let activeSort = '';
        let sortDirection = '';
        let sortParams = '';
        let sortOrder = [];

        // si l'URL contient déjà des paramètres de tri avec une valeur associée, on les récupère
        const urlParams = window.location.search;
        const params = new URLSearchParams(urlParams);

        if (/(?:bras=)\d/.test(params)) {
            const urlActiveSorts = params.getAll('bras');
            const urlActiveDirections = params.getAll('brsd');

            // On efface les éventuelles flèches qui seraient là mais normalement c'est inutile car on est au chargement
            jQuery('.bridge-sort-direction').removeClass('fa-chevron-down').removeClass('fa-chevron-up').hide();
            jQuery('.bridge-sort-btn').removeClass('active').attr('data-sort-direction', '');

            // On parcours les tris passés en URL pour allumer les boutons visuellement et stocker les tris et sens dans les variables activeSorts et sortDirections
            // Pour info, on n'en prend en compte un car les tris sont en annule et remplace : on ne gère qu'un champ de tri à la fois, un point c'est tout !
            urlActiveSorts.forEach(urlActiveSort => {
                const i = urlActiveSorts.indexOf(urlActiveSort);
                activeSort = urlActiveSort;
                sortDirection = urlActiveDirections[i];
                jQuery(".bridge-sort-btn[data-sort-id='" + urlActiveSort + "']").addClass('active');
                jQuery(".bridge-sort-btn[data-sort-id='" + urlActiveSort + "']").attr('data-sort-direction',sortDirection);

                if (sortDirection === 'asc') {
                    jQuery('.bridge-sort-direction[data-sort-id=\'' + urlActiveSort + '\']').addClass('fa-chevron-up');
                } else {
                    jQuery('.bridge-sort-direction[data-sort-id=\'' + urlActiveSort + '\']').addClass('fa-chevron-down');
                }
                jQuery('.bridge-sort-direction[data-sort-id=\'' + urlActiveSort + '\']').show() ; // style.display = 'block';
            });
        }

        // Masquer les boutons sur click sur le bouton de basculer vers carte - 26/04/2022 : ben non
        /*
        jQuery('.bridge-map-toggle').click(function(e) {
            document.querySelector('.bridge-sort-bar').style.display = 'none';
        });
         */


        // réafficher les tris sur clic sur bouton de bascule vers liste
        jQuery('.bridge-list-toggle').click(function(e) {
            document.querySelector('.bridge-sort-bar').style.display = 'flex';
        })

        // Clic sur un bouton de tri par l'utilisateur
        jQuery('.bridge-sort-btn').click(function(e) {
            // Le bouton de tri qui porte les données
            let sortButton ;
            // Lorsqu'on clique sur l'icône, le jQuery(this) nous renvoit le <i> de l'icône, on doit donc remonter au bouton parent
            if(jQuery(this).hasClass('bridge-sort-direction')) {
                sortButton = jQuery(this).closest('.bridge-sort-btn');
            } else {
                sortButton = jQuery(this);
            }

            activeSort = parseInt(sortButton.attr('data-sort-id'));
            let activeSortDirection = sortButton.attr('data-sort-direction');
            // On désactive tous les tris car un clic sur un tri annule et remplace tout, un point c'est tout !
            deactivateAllSorts();

            // Il peut y avoir plusieurs boutons (version mobile, version desktop), d'où la boulce
            jQuery('.bridge-sort-btn[data-sort-id=\'' + activeSort + '\']').each(function (index) {
                // Si le bouton est déjà actif dans le sens croissant, on le passe en décroissant
                if (activeSortDirection === 'asc') {
                    jQuery(this).find('.bridge-sort-direction').removeClass('fa-chevron-up').addClass('fa-chevron-down');
                    sortDirection = 'desc';
                } else {
                    jQuery(this).find('.bridge-sort-direction').addClass('fa-chevron-up');
                    sortDirection = 'asc';
                }
                jQuery(this).attr('data-sort-direction', sortDirection);
                jQuery(this).addClass('active');
                jQuery(this).find('.bridge-sort-direction').show(); // style.display = 'block';
            });

            // si un moteur est associé à la liste, on passe par bridge-moteur.js pour s'insérer dans la même requête ajax
            if (moteurId != '') {
                window['bridgeMoteur' + moteurId].setSortsAndSortDirections([activeSort], [sortDirection]);
                window['bridgeMoteur' + moteurId].calcMoteur(true);
            } else {
                // si pas de moteur associé, on fait la requête avec juste les tris
                let urlParams = getUrlParams();
                updateUrl();
                sortAjax();
            }
        });

        /**
         * Désactive tous les tris visuellement
         */
        function deactivateAllSorts() {
            jQuery('.bridge-sort-direction').removeClass('fa-chevron-down').removeClass('fa-chevron-up').hide();
            jQuery('.bridge-sort-btn').removeClass('active').attr('data-sort-direction', '');
        }

        function getUrlParams() {
            sortParams = 'bras=' + activeSort;
            sortParams += '&brsd=' + sortDirection;
            return sortParams;
        }

        function updateUrl() {
            let urlParams = '';
            if (activeSort !== '') {
                urlParams = { bras: activeSort, brsd: sortDirection };
                Object.keys(urlParams).forEach(function(key,index) {
                    urlParams[key] = sortParams[key];
                });
            }

            let stateObj = JSON.parse(JSON.stringify(urlParams));
            let newUrl = '';
            if (sortParams !== '') {
                newUrl = '?' + getUrlParams();
            }
            history.replaceState(stateObj, jQuery(document).find("title").text(), newUrl);
        }

        /**
         * Provoque la réactualisation de la liste avec les tris indiqués, si celle-ci n'a pas de moteur
         */
        function sortAjax() {

            let urlParams = '&' + sortParams;
            jQuery('.bridge-loader').fadeIn(100);
            jQuery.ajax({
                type: 'GET',
                dataType: 'json',
                url: '<?= BridgeUtils::getAjaxURL() ?>',
                data: 'action=brListe&id=' + <?= $data->id ?> + '&first=0&max=' + urlParams,
                success: function(data) {
                    if (data.total && data.html) {
                        jQuery('#bridge-liste-<?= $listParameters->uniqueIdentifier ?>').find('.listeSITCount').html(data.total);
                        let $items = jQuery(data.html);
                        jQuery('#listeSIT_<?= $listParameters->uniqueIdentifier ?>').html($items);
                        window.bridgeTotalResults = data.total;

                        if (window.bridgeActivateInfiniteScroll_<?= $listParameters->uniqueIdentifier ?> != undefined) {
                            window.bridgeActivateInfiniteScroll_<?= $listParameters->uniqueIdentifier ?>(data.total);
                        }
                        jQuery('.bridge-loader').fadeOut({ duration: 500 });
                    }
                },
                error: function(data) {
                    jQuery('.bridge-loader').fadeOut({ duration: 500 });
                    console.error('Erreur lors de la requête AJAX');
                    console.error(data);
                }
            });
        }
    });
    // -->
</script>
 <?php
    $bridge_scripts_tris_deja_charges = true;
    endif; ?>
