<?php
namespace Bridge\Weblibs;



interface BridgeClientContentInterface
{

    /**
     *  Retourne L'id d'une fiche Bridge pour un produit lui même
     * @param int|string $productCode
     * @param int|string $idFicheBridge
     * @return int|string id fiche issu de l'API Bridge ou '' si non trouvé
     */
    public function getIdficheBridge($productCode='', $idFicheBridge='');

	/**
	 * Retourne l'objet term du CMS courant associé à une liste Bridge
	 * @param int $webListId ID de weblist issu de l'appel à Bridge
	 * @param string $lang langue de récupération
	 * @return object|null Objet term du CMS
	 */
	public function getTermFromListId(int $webListId, string $lang = '');

	/**
	 * Retourne l'objet term du CMS courant associé à une liste Bridge
	 * @param int $webListId ID de weblist issu de l'appel à Bridge
	 * @param string $lang langue de récupération
	 * @return object|null Objet term du CMS
	 */
	public function getTermFromId(int $id, string $lang = '') ;

	public function getWebListIdFromTermObject($term) ;

	public function deleteTermObject(object $term) ;

	public function getAllTerms($langfilter = '');

	/**
	 * Créé un nouveau terme dans le CMS
	 * @param   string  $termName
	 * @param   string  $termSlug
	 * @param   string|null  $termDescription
	 * @param   object  $webList
	 * @param   string  $lang
	 *
	 * @return mixed objet term du CMS
	 *
	 * @since version 1.0.0
	 */
	public function createTerm(string $termName, string $termSlug, $termDescription, object $webList, $permalink = '', string $lang = 'fr');

	public function updateTermFromWebList(object $term, string $termName, string $termSlug, $termDescription, object $webList, $permalink = '', string $lang = 'fr');

    /**
     * Retourne le chemin URL d'une liste Bridge (pour créer des liens vers les fiches et vers les listes)
     * @param object $webList objet weblist issu de l'appel à Bridge
     * @return array|string|string[] Portion d'URL de la liste
     */
    public function getListPermalink(object $webList);

    /**
     * Permet de récupérer l'url d'une fiche d'après son productCode
     * @param int|string $productCode champ productCode de Bridge
     * @return string URL de la fiche
     */
    public function getPostLinkFromProductCode($productCode);


    /**
     * Permet de récupérer un Id de post à partir d'un numéro de produit SIT
     * @param string|int $productCode champ productCode de Bridge
     * @return string URL de la fiche
     */
    public function getPostIdFromProductCode($productCode);

    /**
     * Permet de récupérer le lien d'une fiche dans sa rubrique principale
     * @param int $productCode code SIT de la fiche
     * @param string $productSlug slug de la fiche (pour éviter une récupération en BDD si on l'a sous la main)
     * @return string Lien vers la fiche dans sa rubrique principale ou lien par défaut sinon
     */
    public function getMainTermLinkFromProductCode($productCode, $productSlug = '') ;

    /**
     * Permet de récupérer le lien vers une fiche)
     * @param int $productCode code SIT de la fiche
     * @param string $productSlug slug de la fiche (pour éviter une récupération en BDD si on l'a sous la main)
     * @param string $permalink Permalink de la liste courante (Wordpress réécritures d'URL)
     * @return string Lien vers la fiche dans sa rubrique principale ou lien par défaut sinon
     */
    public function getProductStandardLink($productCode, $productSlug = '', $permalink = '') ;

    /**
     * Alias de get_query_var pour wordpress
     * @param string $var
     * @return mixed
     */
    public function getQueryVar(string $var);

    /**
     * Récupère le post courant (Wordpress)
     * @return mixed
     */
    public function getCurrentPostId();

    /**
     * Retourne le code produit d'un post
     * get_post_meta($postId, 'bridge_productCode', true);
     * @param int $postId
     * @return mixed
     */
    public function getProductCodeFromPostId(int $postId);

    /**
     * Retourne l'ID de la fiche Bridge associée à un post
     *
     * @param int $postId
     * @return mixed
     */
    public function getFicheIdFromPostId(int $postId);


	public function getPostObjectFrom($field, $value, $lang);

	public function createPostFromBridgeProduct($product, $lang) ;

	public function updatePostFromBridgeProduct($postId, $product, $lang);

	public function deletePost($postId) ;


}
