<?php
namespace Bridge\Weblibs;

use Bridge\Weblibs\BridgeApiService;
use Bridge\Weblibs\BridgeClientParamsInterface;
use Bridge\Weblibs\BridgeClientRendererInterface;
use Bridge\Weblibs\BridgeCmsAbstractLayerInterface;
use Bridge\Weblibs\BridgeClientContentInterface;
use Bridge\Weblibs\BridgeFrontEndAjaxInterface;
use Bridge\Weblibs\BridgeRequestServiceInterface;
use Bridge\Weblibs\BridgeDataGetter;

class BridgeFrontEndAjaxService implements BridgeFrontEndAjaxInterface
{
	private BridgeClientParamsInterface $clientParams;

	private BridgeRequestServiceInterface $requestService;
	private BridgeApiService $bridgeApiService;

	private BridgeClientContentInterface $bridgeClientContent;

	private BridgeClientRendererInterface $bridgeClientRenderer;

	private BridgeCmsAbstractLayerInterface $bridgeCmsAbstractLayer;

	private BridgeDataGetter $bridgeDataGetter;

	private $listRequestVars = ['id', 'product_codes', 'max', 'first', 'itemTemplate', 'item_template', 'change', 'minimal_select', 'filter_city', 'filter_criterions', 'scoring', 'filter_lat', 'filter_lon', 'filter_rayon', 'selection_id', 'excluded_codes', 'sort_one', 'sort_two', 'sort_three', 'duplicate_by', 'filter_id', 'dncdebug'];
	public function __construct(BridgeClientParamsInterface $clientParams, BridgeClientContentInterface $bridgeClientContent, BridgeCmsAbstractLayerInterface $bridgeCmsAbstractLayer, BridgeRequestServiceInterface $requestService, BridgeApiService $bridgeApiService, BridgeClientRendererInterface $bridgeClientRenderer, BridgeDataGetter $bridgeDataGetter)
	{
		$this->bridgeCmsAbstractLayer = $bridgeCmsAbstractLayer;
		$this->clientParams = $clientParams;
		$this->bridgeClientContent = $bridgeClientContent;
		$this->requestService = $requestService;
		$this->bridgeApiService = $bridgeApiService;
		$this->bridgeClientRenderer = $bridgeClientRenderer;
		$this->bridgeDataGetter = $bridgeDataGetter;
	}

	/**
	 * Nouvelle liste ajax
	 */
	public function listeAjax()
	{

		// On crée un tableau d'attributs pour l'affichage Ajax
		$attributes = [];
		foreach ($this->listRequestVars as $requestVar) {
			if ($this->requestService->get($requestVar, null) !== null) {
				$attributes[$requestVar] = $this->requestService->get($requestVar, null);
			}
		}

		if (!isset($attributes['max']))
			$attributes['max'] = '';

		ob_start();
		$preData = $this->bridgeDataGetter->getListData($attributes);
		$listData = $this->bridgeDataGetter->prepareListDataForRender($preData);
		$template = $this->bridgeClientRenderer->bridge_locate_template('templates-bridge/ajax.php');
		include($template);
		$html = ob_get_clean();
		ob_end_flush();

		$res = array(
			'max' => $attributes['max'],
			'total' => null,
			'message' => null,
			'html' => null,
			'moteur' => null
		);

		// $lang = BridgeUtils::getLanguage();

		if (!empty($preData) && isset($preData['success']) && (isset($preData['message']) || isset($preData['total']))) {
			if(!empty($preData['data']) && isset($preData['data']->moteur)) {
				$res['moteur'] = $preData['data']->moteur;
			}

			// si erreur
			if ($preData['success'] === false) {
				$res['message'] = $preData['message'];

				// si success mais aucun résultat
			} elseif ($preData['total'] === 0) {
				$res['total'] = $preData['total'];
				$res['message'] = $preData['message'];

				// si success et résultats
			} else {
				$res['total'] = $preData['total'];
				$res['html'] = $html;

				// $res['lang'] = $lang;

				if (isset($listData['listInfos']->cityComboDynList)) {
					$res['cityComboDynList'] = $listData['listInfos']->cityComboDynList;
				}

				if (isset($listData['listInfos']->lastPage)) {
					$res['lastPage'] = $listData['listInfos']->lastPage;
				}
			}
		} else {
			$res['message'] = 'Une erreur est survenue';
		}

		if(!headers_sent())
			header('Content-Type: application/json');
		echo json_encode($res);
		die();
	}

	/**
	 * liste ajax pour infinite scroll
	 */
	public function listeAjaxInfinite()
	{
		// On crée un tableau d'attributs pour l'affichage Ajax
		$attributes = [];
		foreach ($this->listRequestVars as $requestVar) {
			if ($this->requestService->get($requestVar, null) !== null) {
				$attributes[$requestVar] = $this->requestService->get($requestVar, null);
			}
		}
		if (!isset($attributes['max']))
			$attributes['max'] = '';

		ob_start();
		$preData = $this->bridgeDataGetter->getListData($attributes);
		$listData = $this->bridgeDataGetter->prepareListDataForRender($preData);
		$template = $this->bridgeClientRenderer->bridge_locate_template('templates-bridge/liste.php');
		include($template);
		$html = ob_get_clean();
		ob_end_flush();
		die($html);
	}

	/**
	 * Récupération des POI à mettre sur la carte à côté de la liste
	 */
	public function listeAjaxPOI()
	{
		// On crée un tableau d'attributs pour l'affichage Ajax
		$attributes = [];
		foreach ($this->listRequestVars as $requestVar) {
			if ($this->requestService->get($requestVar, null) !== null) {
				$attributes[$requestVar] = $this->requestService->get($requestVar, null);
			}
		}
		if (!isset($attributes['max']))
			$attributes['max'] = '';

		// Pour réduire le nombre de champs retournés par bridge
		$attributes['minimal_select'] = '1';

		$res = array(
			'success' => false,
			'max' => $attributes['max'],
			'total' => null,
			'message' => '',
			'data' => null
		);

		try {
			$dataReturned = $this->bridgeDataGetter->getListData($attributes, true);
		} catch (\Exception $e) {
			$res['message'] = 'Une erreur est survenue : ' . $e->getMessage();
			$this->bridgeCmsAbstractLayer->sendJson($res);
			die();
		}

		// $lang = BridgeUtils::getLanguage();
		if (empty($dataReturned) || !isset($dataReturned['success']) || !isset($dataReturned['message']) || !isset($dataReturned['total'])) {
			if (isset($dataReturned['message']))
				$res['message'] = $dataReturned['message'];
			else
				$res['message'] = 'Une erreur est survenue';
			$this->bridgeCmsAbstractLayer->sendJson($res);
			die();
		}

		// si erreur
		if ($dataReturned['success'] === false) {
			$res['message'] = $dataReturned['message'];
			$this->bridgeCmsAbstractLayer->sendJson($res);
			die();
		}

		$res['success'] = true;
		$res['data'] = $dataReturned['data'];
		$this->bridgeCmsAbstractLayer->sendJson($res);
		die();
	}

	/**
	 * Récupération des POI à mettre sur la carte à côté de la liste
	 */
	public function listeAjaxCities()
	{
		// On crée un tableau d'attributs pour l'affichage Ajax
		$attributes = [];
		foreach ($this->listRequestVars as $requestVar) {
			if ($this->requestService->get($requestVar, null) !== null) {
				$attributes[$requestVar] = $this->requestService->get($requestVar, null);
			}
		}
		if (!isset($attributes['max']))
			$attributes['max'] = '';

		$res = array(
			'success' => false,
			'max' => $attributes['max'],
			'total' => null,
			'message' => '',
			'data' => null
		);

		try {
			$dataReturned = $this->bridgeDataGetter->getCitiesData($attributes, true);
		} catch (\Exception $e) {
			$res['message'] = 'Une erreur est survenue : ' . $e->getMessage();
			$this->bridgeCmsAbstractLayer->sendJson($res);
			die();
		}

		// $lang = BridgeUtils::getLanguage();
		if (empty($dataReturned) || !isset($dataReturned['success']) || !isset($dataReturned['data'])) {
			if (isset($_REQUEST['get_as_label_array'])) {
				$res = array();
			} else {
				$res['success'] = true;
				$res['data'] =array();
			}
			$this->bridgeCmsAbstractLayer->sendJson($res);
			die();
		}

		// si erreur
		if ($dataReturned['success'] === false) {
			$res['message'] = $dataReturned['message'];
			$this->bridgeCmsAbstractLayer->sendJson($res);
			die();
		}

		if ($this->requestService->get('get_as_label_array', null) !== null) {
			$res = array();
			for($i = 0 ; $i < count($dataReturned['data']) ; $i++) {
				$res[] = (object) array('label' => $dataReturned['data'][$i]->city, 'lat' => $dataReturned['data'][$i]->latitude, 'lon' => $dataReturned['data'][$i]->longitude);
			}
		} else {
			$res['success'] = true;
			$res['data'] = $dataReturned['data'];
		}
		$this->bridgeCmsAbstractLayer->sendJson($res);
		die();
	}

	// carnet de voyage
	public function bridge_add_fiche_to_session_cv()
	{
		try {
			if (session_status() === PHP_SESSION_NONE) {
				session_start();
			}
			if (!isset($_SESSION["cv"])) {
				$_SESSION["cv"] = array();
			}
			foreach ($_SESSION["cv"] as $fiche) {
				if ($fiche["id"] == $_POST["id"]) {
					// ND 07.11.23 Patch sessions bloquantes
					session_write_close();
					return $this->bridgeCmsAbstractLayer->sendJsonError("Fiche déjà dans le CV " . var_export($_SESSION, true), 400);
				}
			}
			if(!isset($_POST["id"]) || !isset($_POST["name"]) || !isset($_POST["city"])) {
				// ND 07.11.23 Patch sessions bloquantes
				$ret = unserialize(serialize($_SESSION));
				session_write_close();
				return $this->bridgeCmsAbstractLayer->sendJsonSuccess($ret);
			}
			$_SESSION["cv"][] = array(
				"id" => $_POST["id"],
				"name" => str_replace('\\"', '"', str_replace("\\'", "'", $_POST["name"])),
				"city" => $_POST["city"]
			);

			$ret = unserialize(serialize($_SESSION));
			// ND 07.11.23 Patch sessions bloquantes
			session_write_close();

			return $this->bridgeCmsAbstractLayer->sendJsonSuccess($ret);
		} catch (Exception $e) {
			session_write_close();
			return $this->bridgeCmsAbstractLayer->sendJsonError("Erreur lors de l'ajout " . $e->getMessage(), 400);
		}
	}

	/**
	 * Appelé en ajax - retire une fiche du carnet de voyages
	 * @return mixed
	 */
	public function bridge_remove_fiche_from_session_cv()
	{
		if (session_status() === PHP_SESSION_NONE) {
			session_start();
		}

		if (!isset($_SESSION["cv"])) {
			// ND 07.11.23 Patch sessions bloquantes
			session_write_close();
			return $this->bridgeCmsAbstractLayer->sendJsonError("Rien dans le cv", 404);
		}

		for ($i = 0; $i <= count($_SESSION["cv"]); $i++) {
			if ($_SESSION["cv"][$i]["id"] == $_POST["id"]) {
				array_splice($_SESSION["cv"], $i, 1);
				// ND 07.11.23 Patch sessions bloquantes
				session_write_close();
				return $this->bridgeCmsAbstractLayer->sendJsonSuccess("Done");
			}
		}
		// ND 07.11.23 Patch sessions bloquantes
		session_write_close();

		return $this->bridgeCmsAbstractLayer->sendJsonError("Fiche invalide", 404);
	}

	/**
	 * Fonction pour demander le démarrage de l'import au prochain passage du cron
	 */
	public function start_import() {
		$numrows = $this->clientParams->setNeedToImport('oui');
		$this->bridgeCmsAbstractLayer->sendJsonSuccess(array( 'message' => "L'import sera lancé dans quelques instants...", "numrows" => $numrows));
	}


	/**
	 * Appelée en AJAX au chargement d'une carte interactive ou lorsque des items de la légende sont sélectionnés
	 * Renvoie la liste des produits à afficher selon les items choisis, avec quelques infos (code, coordonnées, label)
	 */
	public function webmap_get_products_to_show()
	{
		$lang = $this->requestService->get('lang', '');
		$webMapItems = $this->requestService->get('activatedItems', '');
		$errorMsg = '';

		$tmp = $this->bridgeDataGetter->getWebMapProductsToShow($webMapItems, $lang);
		if (!$tmp || !isset($tmp['success'])) {
			$errorMsg = 'Erreur à la récupération des produits';
			$this->bridgeCmsAbstractLayer->sendJsonError(($errorMsg));
		} else {
			if ($tmp['success'] && isset($tmp['data']) && !isset($tmp['message'])) {
				$this->bridgeCmsAbstractLayer->sendJsonSuccess($tmp['data']);
			} elseif ($tmp['success'] && isset($tmp['data']) && isset($tmp['message'])) {
				$response = [$tmp['data'], $tmp['message']];
				$this->bridgeCmsAbstractLayer->sendJsonSuccess($response);
			} else {
				$errorMsg = $tmp['message'];
				$this->bridgeCmsAbstractLayer->sendJsonError($errorMsg);
			}
		}
	}

	/**
	 * webmap_get_product_data
	 * Appelée en AJAX au clic sur le marqueur d'une carte interactive
	 * Renvoie les infos du produit associé (blocks, etc.) pour les afficher dans un pop-up
	 */
	public function webmap_get_product_data()
	{
		$lang = $this->requestService->get('lang', '');
		$webMapId = $this->requestService->get('map', '');
		$productCode = $this->requestService->get('product', '');
		$popupTemplate = $this->requestService->get('popup', '');

		$preData = $this->bridgeDataGetter->getWebMapProductData($webMapId, $lang, $productCode, $popupTemplate);

		$popupPreparedData = $this->bridgeDataGetter->prepareMapPopupDataForRender($preData);

		include $this->bridgeClientRenderer->bridge_locate_template('templates-bridge/init-variables-globales-map-popup.php');
		// $blocks = $popupData->mapPopupBlocks;

		$template = $this->bridgeClientRenderer->bridge_locate_template('templates-bridge/carto/popups/' . $popupTemplate . '.php');
		ob_start();
		include($template);
		$html = ob_get_clean();
		$this->bridgeCmsAbstractLayer->sendJsonSuccess($html);
	}

	public function bridge_fiche_ajax() {
		$html = '';
		$productCode = $this->requestService->get('product_code', null);
		if(!isset($productCode)) {
			$this->bridgeCmsAbstractLayer->sendJsonError('Paramètre product_code manquant');
			die();
		}

		// Récupération des données de la fiche SIT
		$preData = $this->bridgeDataGetter->getDataFiche($productCode);

		$ficheTemplate = $this->requestService->get('fiche_template', $preData->ficheTemplate);

		if (!empty($preData)) {
			if (isset($preData->product) && is_object($preData->product)) {
				if (!empty($preData->product->comment)) {
					if (mb_strlen($preData->product->comment) > 150) {
						$preData->product->shortComment = mb_substr($preData->product->comment, 0, 150) . '...';
					} else {
						$preData->product->shortComment = $preData->product->comment;
					}
				} else {
					$preData->product->shortComment = '';
				}

				// Lien
				$link = $this->bridgeClientContent->getPostLinkFromProductCode($preData->product->productCode);
				$preData->product->link = $link;
			}
		}

		// On prépare les donnée spour utilisation dans les templates
		$ficheData = $this->bridgeDataGetter->prepareFicheDataForRender($preData);

		if (!empty($ficheData)) {
			ob_start();
			include $this->bridgeClientRenderer->bridge_locate_template('templates-bridge/init-variables-globales-fiche.php');
			// include $this->bridgeClientRenderer->bridge_locate_template('templates-bridge/fiche/bridge-document-ready.php');
			include $this->bridgeClientRenderer->bridge_locate_template('templates-bridge/fiche/'.$ficheTemplate.'.php');
			$html = ob_get_clean();
			$this->bridgeCmsAbstractLayer->sendJsonSuccess($html);
		} else {
			$this->bridgeCmsAbstractLayer->sendJsonError('Pas de données');
			die();
		}
		die();
	}

	/**
	 * Appelée en ajax sur envoi d'un formulaire de contact dans la fiche : vérifie le token Recaptcha V3 et envoie le mail au prestataire
	 */
	public function bridge_send_email_recaptcha() {

		$productcode = $this->requestService->get('productCode', '');
		$webPageId = $this->requestService->get('webPageId', '');
		$token = $this->requestService->get('token', '');
		$name = $this->requestService->get('name', '');
		$phone = $this->requestService->get('phone', '');
		$email = $this->requestService->get('email', '');
		$message = $this->requestService->get('message', '');
		$subject = $this->requestService->get('subject', '');
		$dest = $this->requestService->get('dest', '');

		// On vérifie que l'appel est correct
		if(empty($dest) || empty($productcode) || empty($webPageId) || empty($name) || empty($email) || empty($message) || empty($token) || empty($subject) ) {
			$this->bridgeCmsAbstractLayer->sendJsonError('Erreur : appel incorrect');
			die();
		}

		try {
			// On vérifie le token Recaptcha V3
			$dataFiche = $this->bridgeDataGetter->getDataFiche($productcode, $webPageId);
			$body = '';
			if(!empty($dataFiche->parameters->emailPrestBody ))
				$body = $dataFiche->parameters->emailPrestBody;

			if(empty($subject)) {
				$subject = $subject .' - Fiche : '.$dataFiche->product->name;
			}
			if(empty($body)) {
				$body = "Bonjour, \n\nUne demande de renseignements a été envoyée depuis le site " . $this->bridgeCmsAbstractLayer->get_site_url() .' sur votre fiche : '.$dataFiche->product->name;
			}
			$emailBody = $body . "\n";
			$emailBody .= "\nNom : ". stripcslashes($name) ;
			$emailBody .= "\nEmail : $email";
			if($phone!='')
				$emailBody .= "\nTéléphone : $phone";

			$emailBody .= "\nMessage : " . stripcslashes($message);
			if(!empty($dataFiche->parameters->emailPrestBodyEnd ))
				$emailBody .= "\n\n" . $dataFiche->parameters->emailPrestBodyEnd;

			// Vérification recaptcha
			if ($dataFiche->parameters->emailFormAntispam == 'RECAPTCHAV2') {
				$recaptchaSecretKey = $dataFiche->parameters->recaptchav2_secret_key;
				$recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
				$recaptcha = file_get_contents($recaptcha_url . '?secret=' . $recaptchaSecretKey . '&response=' . $token);
				$recaptcha = json_decode($recaptcha);
				if($recaptcha->success === true) {
					$headers = array (
						'Reply-To: ' . stripcslashes($name) . '<' . $email . '>',
					);
					// apply_filters( 'wp_mail_from_name', stripcslashes($name), 99);
					$this->bridgeCmsAbstractLayer->sendMail($dest, $subject, $emailBody, $headers);
					$this->bridgeCmsAbstractLayer->sendJsonSuccess(__('Message envoyé avec succès', 'plugin-sit'));
				} else {
					$prop = 'error-codes';
					$message = __('La vérification antispam a échoué', 'plugin-sit');
					if(isset($recaptcha->$prop) && is_array($recaptcha->$prop)) {
						$message .= ' ' . implode (' - ', $recaptcha->$prop);
					}
					$this->bridgeCmsAbstractLayer->sendJsonError($message);
				}
			} elseif ($dataFiche->parameters->emailFormAntispam == 'RECAPTCHAV3') {
				$recaptchaSecretKey = $dataFiche->parameters->recaptchav3_secret_key;
				$recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
				$recaptcha = file_get_contents($recaptcha_url . '?secret=' . $recaptchaSecretKey . '&response=' . $token);
				$recaptcha = json_decode($recaptcha);
				// Selon le score recaptcha on envoie le mail ou pas
				if ($recaptcha->score >= 0.5) {
					$headers = array(
						'Reply-To: ' . stripcslashes($name) . '<' . $email . '>',
					);
					$this->bridgeCmsAbstractLayer->sendMail($dest, $subject, $emailBody, $headers);
					$this->bridgeCmsAbstractLayer->sendJsonSuccess(__('Message envoyé avec succès', 'plugin-sit'));
				} else {
					$prop = 'error-codes';
					$message = __('La vérification antispam a échoué', 'plugin-sit');
					if(isset($recaptcha->$prop) && is_array($recaptcha->$prop)) {
						$message .= ' ' . implode (' - ', $recaptcha->$prop);
					}
					$this->bridgeCmsAbstractLayer->sendJsonError($message);
				}
			} else {
				$this->bridgeCmsAbstractLayer->sendJsonError(__('Mode de vérification captcha non supporté', 'plugin-sit'));
			}

		} catch (\Exception $e) {
			$this->bridgeCmsAbstractLayer->sendJsonError(__('Erreur lors de l\'envoi de l\'email', 'plugin-sit'));
		}
	}


}
