<?php

namespace Bridge\Weblibs\Joomla;

use Bridge\Weblibs\BridgeClientContentInterface;
use Bridge\Weblibs\BridgeCmsAbstractLayerInterface;
use Bridge\Weblibs\BridgeClientParamsInterface;
use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;
use Joomla\CMS\Router\Route;

class BridgeClientContentJoomla implements BridgeClientContentInterface
{

	private BridgeCmsAbstractLayerInterface $bridgeCmsAbstractLayer;
	private BridgeClientParamsInterface $clientParams;

	public function __construct(BridgeCmsAbstractLayerInterface $bridgeCmsAbstractLayer, BridgeClientParamsInterface $clientParams) {
		$this->bridgeCmsAbstractLayer = $bridgeCmsAbstractLayer;
		$this->clientParams = $clientParams;
	}
    /**
     *  Retourne L'id d'une fiche Bridge pour un produit lui même
     * @param int|string $productCode
     * @param int|string $idFicheBridge
     * @return int|string id fiche issu de l'API Bridge ou '' si non trouvé
     */
    public function getIdficheBridge($productCode='', $idFicheBridge='') {
		// TODO voir si utilisé sur Joomla
        return true;
    }

    /**
     * Retourne le chemin URL d'une liste Bridge (pour créer des liens vers les fiches et vers les listes)
     * @param object $webList objet weblist issu de l'appel à Bridge
     * @return array|string|string[] Portion d'URL de la liste
     */
    public function getListPermalink(object $webList) {
        // TODO : gérer les langues
        $deb = '';
        $lang = $this->bridgeCmsAbstractLayer->getCurrentLanguage();
        $term = null;

        // Update 23/01/2023 : on supporte les listes sans id créées à la volée => lien automatique
        if(!isset($webList->id) || empty($webList->id) || $webList->permalinkUrl == 'RUBRIQUE_PRINCIPALE') {
            return 'RUBRIQUE_PRINCIPALE';
        }

		$term = $this->getTermFromListId($webList->id, $lang);

        if(isset($term)) {
            $permalink = $this->bridgeCmsAbstractLayer->getPermalinkFromTermId($term->id, $lang);
            if(isset($_REQUEST['EETR'])) {
                echo "PERMALINK : $permalink";
            }
            return $permalink;
        } else {
            $termid = 'pas de terme => veuillez lancer un import';
            return "#err" . $webList->id . "#" . $termid . "#";
        }
    }

	/**
	 * Retourne l'objet term du CMS courant associé à une liste Bridge
	 * @param int $webListId ID de weblist issu de l'appel à Bridge
	 * @param string $lang langue de récupération
	 * @return object|null Objet term du CMS
	 */
	public function getTermFromListId(int $webListId, string $lang = '') {
		return $this->getTermFrom('list_id', $webListId, $lang);
	}

	/**
	 * Retourne l'objet term du CMS courant associé à une liste Bridge
	 * @param int $webListId ID de weblist issu de l'appel à Bridge
	 * @param string $lang langue de récupération
	 * @return object|null Objet term du CMS
	 */
	public function getTermFromId(int $id, string $lang = '') {
		return $this->getTermFrom('id', $id, $lang);
	}

	private function getTermFrom($field, $value, $lang = '') {
		if(empty($lang)) {
			$lang = $this->bridgeCmsAbstractLayer->getCurrentLanguage();
		}

		$term = null;

		$db    = Factory::getContainer()->get('DatabaseDriver');
		$query = "SELECT * FROM #__pylot_bridge_rubriques WHERE " . $field . "=" . $db->quote($value) . " AND lang=" . $db->quote($lang) . ";";
		$db->setQuery($query);
		// Load the results
		$terms = $db->loadObjectList();
		if(count($terms) > 0)
		{
			$term = $terms[0];
		}
		return $term;
	}

	/**
	 * Créé un nouveau terme dans le CMS
	 * @param   string  $termName
	 * @param   string  $termSlug
	 * @param   string|null  $termDescription
	 * @param   object  $webList
	 * @param   string  $lang
	 *
	 * @return mixed objet term du CMS
	 *
	 * @since version 1.0.0
	 */
	public function createTerm(string $termName, string $termSlug, $termDescription, object $webList, $permalink = '', string $lang = 'fr')
	{
		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$query = $db->getQuery(true);
		$query->insert('#__pylot_bridge_rubriques');
		$query->columns('name, slug, list_id, permalink, lang, fiche_id, permalink_is_canonical, destination_weblist_id');
		$query->values($db->quote($termName) . ',' . $db->quote($termSlug) . ',' . $db->quote($webList->id) . ',' . $db->quote($permalink) . ',' . $db->quote($lang) . ',' . $db->quote((int) $webList->ficheId) . ',' . $db->quote((int) $webList->permalinkIsCanonical) . ',' . $db->quote($webList->destinationWebListId));
		$db->setQuery($query);
		$db->execute();
		$termId = $db->insertid();
		return $this->getTermFromId($termId, $lang);
	}

	public function updateTermFromWebList(object $term, string $termName, string $termSlug, $termDescription, object $webList, $permalink = '', string $lang = 'fr')
	{
		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$query = $db->getQuery(true);
		$fields = array(
			$db->quoteName('name') . ' = ' . $db->quote($termName),
			$db->quoteName('slug') . ' = ' . $db->quote($termSlug),
			$db->quoteName('list_id') . ' = ' . $db->quote($webList->id),
			$db->quoteName('permalink') . ' = ' . $db->quote($permalink),
			$db->quoteName('lang') . ' = ' . $db->quote($lang),
			$db->quoteName('fiche_id') . ' = ' . $db->quote((int) $webList->ficheId),
			$db->quoteName('permalink_is_canonical') . ' = ' . $db->quote((int) $webList->permalinkIsCanonical),
			$db->quoteName('destination_weblist_id') . ' = ' . $db->quote($webList->destinationWebListId),
		);

		$query->update('#__pylot_bridge_rubriques')
		->set($fields)
		->where('id=' . $term->id);

		// $sql = $query->__toString();
		// die($sql);
		$db->setQuery($query);
		$db->execute();
		return $this->getTermFromId($term->id, $lang);
	}

	public function getAllTerms($langfilter = '') {
		$db    = Factory::getContainer()->get('DatabaseDriver');
		$query = "SELECT * FROM #__pylot_bridge_rubriques ";
		if(!empty($langfilter)) {
			$query .= " WHERE lang=" . $db->quote($langfilter);
		}
		$query .= ";";
		$db->setQuery($query);
		// Load the results
		return $db->loadObjectList();
	}

	public function getWebListIdFromTermObject($term)
	{
		return $term->list_id;
	}

	public function deleteTermObject(object $term) {
		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$query = $db->getQuery(true);
		$query->delete('#__pylot_bridge_rubriques');
		$query->where('id=' .$term->id);
		$db->setQuery($query);
		return $db->execute();
	}

    /**
     * Permet de récupérer l'url d'une fiche non réécrite d'après son productCode
     * @param int|string $productCode champ productCode de Bridge
     * @return string URL de la fiche
     */
    public function getPostLinkFromProductCode($productCode, $lang = '') {

		if(empty($lang))
		    $lang = $this->bridgeCmsAbstractLayer->getCurrentLanguage();
	    $permalink = '';
		$postId = $this->getPostIdFromProductCode($productCode, $lang);

	    if(isset($permalink) && $permalink!='')
		    return $permalink;

		// Si on arrive ici, c'est qu'on a aucun lien de menu pour cette fiche, on se rabat sur le chemin par défaut
	    if(isset($postId) && !empty($postId))
	    {
			$defaultMenuId = $this->clientParams->getFicheRootUrl();
		    // $app = Factory::getApplication();
		    // $sitemenu = $app->getMenu();
			// $allListMenuItem = $sitemenu->getItem($defaultMenuId);

			if(!empty($allListMenuItem)) {
				$post = $this->getPostObjectFrom('id', $postId, $lang);
				// return $allListMenuItem->link . '/' . $defaultMenuId . '-' . $post->slug;
				// return Route::_("index.php?Itemid=" . $defaultMenuId) . '/' . $defaultMenuId . '-' . $post->slug;
				return Route::_("index.php?Itemid=" . $defaultMenuId . "&option=com_pylot_bridge&view=bridgefichessit&id=" . $postId);
			}

			// Pas bon, car ça pointe sur n'importe quelle liste Bridge
		    // return "/index.php?option=com_pylot_bridge&view=bridgefichessit&id=" . $postId;
		    if(isset($postId) && !empty($postId)) {
			    $permalink = $this->bridgeCmsAbstractLayer->getPostPermalink($postId);
		    }
		    if(!empty($permalink))
			    return $permalink;
	    }
	    return "#ErrorPermaLink#$lang";

    }

    /**
     * Permet de récupérer un ID de post de post à partir d'un numéro de produit SIT
     * @param string|int $productCode champ productCode de Bridge
     * @return string URL de la fiche
     */
    public function getPostIdFromProductCode($productCode, $lang = '') {

		if(empty($lang))
		{
			// attention en ligne de commande chz moi c'est en anglais
			$lang = $this->bridgeCmsAbstractLayer->getCurrentLanguage();
		}
		$post = $this->getPostObjectFrom('product_code', $productCode, $lang);
	    if(is_object($post)) {
			return $post->id;
	    }
		return null;
	}

	/**
	 * Permet de récupérer un objet post à partir d'un champ de la table et d'une valeur discriminante
	 * @param $field
	 * @param $value
	 * @param $lang
	 *
	 * @return mixed|null
	 *
	 * @since version
	 */
	public function getPostObjectFrom($field, $value, $lang) {

		if(empty($lang))
		{
			$lang = $this->bridgeCmsAbstractLayer->getCurrentLanguage();
		}
		$db    = Factory::getContainer()->get('DatabaseDriver');
		$query = "SELECT * FROM #__pylot_bridge_fiches_sit WHERE $field=" . $db->quote($value) . " AND lang='" . $lang . "';";
		$db->setQuery($query);

		// Load the results
		$posts = $db->loadObjectList();
		if(count($posts) > 0) {
			return $posts[0];
		}
		return null;
	}

    /**
     * Wordpress : Permet de récupérer le lien de la rubrique principale d'une fiche
     * @param int $productCode code SIT de la fiche
     * @param string $productSlug slug de la fiche (pour éviter une récupération en BDD si on l'a sous la main)
     * @return string Lien vers la fiche dans sa rubrique principale ou lien par défaut sinon
     */
    public function getMainTermLinkFromProductCode($productCode, $productSlug = '', $lang = '') {



		if(empty($lang))
		    $lang = $this->bridgeCmsAbstractLayer->getCurrentLanguage();
	    $db    = Factory::getContainer()->get('DatabaseDriver');
	    $query = "SELECT * FROM #__pylot_bridge_fiches_sit WHERE product_code=" . $productCode . " AND lang='" . $lang . "';";
	    $db->setQuery($query);
	    $products = $db->loadObjectList();
	    $link = '';
	    $listPermalink = '';
		if(count($products) > 0) {
			$mainTermId = $products[0]->rubrique_principale;
			if(!empty($mainTermId)) {
				if(empty($productSlug)) {
					$productSlug = $products[0]->slug;
				}
				$listPermalink = $this->bridgeCmsAbstractLayer->getPermalinkFromTermId($mainTermId, $lang);
				$link = str_replace('//', '/', '/' . $listPermalink . '/' . $productSlug);
			}
		}

        // Voiture balais : s'il n'existe pas de liste cochée 'Rubrique principale' contenant cette fiche
        // On renvoit le permalien par défaut de la fiche
        if(empty($listPermalink)) {
            $link = $this->getPostLinkFromProductCode($productCode, $lang);
        }
        return $link;
    }

    /**
     * Permet de récupérer le lien vers une fiche)
     * @param int $productCode code SIT de la fiche
     * @param string $productSlug slug de la fiche (pour éviter une récupération en BDD si on l'a sous la main)
     * @param string $permalink Permalink de la liste courante (Wordpress réécritures d'URL)
     * @return string Lien vers la fiche dans sa rubrique principale ou lien par défaut sinon
     */
    public function getProductStandardLink($productCode, $productSlug = '', $permalink = '') {
        if(!empty($productSlug) && !empty($permalink)) {
            // Cas normal d'utilisation pour wordpress
            return '/'.$permalink. $productSlug;
        } else {
            // Sinon lien par défaut
            return $this->getPostLinkFromProductCode($productCode);
        }
    }

    /**
     * Retourne l'ID de la fiche Bridge associée à un post
     *
     * @param int $postId
     * @return nuull|int id de fiche Bridge reliée au post (préférence pour la rubrique principale)
     */
    public function getFicheIdFromPostId(int $postId) {
	    $ret = null;
        $post = $this->getPostObjectFrom('id', $postId, $this->bridgeCmsAbstractLayer->getCurrentLanguage());
		if(is_object($post)) {
			$termId = null;
			if(!empty($post->rubrique_principale)) {
				$termId = $post->rubrique_principale;
			} elseif(!empty($post->rubriques)) {
				$terms = explode(',', $post->rubriques);
				$termId = $terms[0];
			}
			if(isset($termId)) {
				$term = $this->getTermFromId($termId);
				if(is_object($term)) {
					$ret = $term->fiche_id;
				}
			}
		}
		return $ret;
    }

    /**
     * Alias de get_query_var pour wordpress
     * @param string $var
     * @return mixed
     */
    public function getQueryVar(string $var) {
	    // TODO : Voir si besoin pour Joomla
		return '';
    }

    /**
     * Retourne le code produit d'un post ous la forme de chaine
     * @param int $postId
     * @return string code produit
     */
    public function getProductCodeFromPostId(int $postId) {
	    $lang = $this->bridgeCmsAbstractLayer->getCurrentLanguage();
	    $db    = Factory::getContainer()->get('DatabaseDriver');
	    $query = "SELECT * FROM #__pylot_bridge_fiches_sit WHERE id=" . $postId . " AND lang='" . $lang . "';";
	    $db->setQuery($query);
	    $products = $db->loadObjectList();
	    if(count($products) > 0) {
			return $products[0]->product_code;
	    }
		return '';
    }

	public function createPostFromBridgeProduct($product, $lang) {

		$content = '';
		if (isset($product->commentHtml) && $product->commentHtml !== '' && $product->commentHtml != null) {
			$content = strip_tags($product->commentHtml, '<br>');
		}
		elseif ($product->comment != '') {
			$content = $product->comment;
		}
		elseif ($product->comment1 != '') {
			$content = $product->comment1;
		}
		$metadesc = ((mb_strlen($content) > 127) ? mb_substr($content, 0, 127) . '...' : $content);
		$metatitle = $product->name . ' - ' . $product->city;
		$datmaj = '';
		if (is_object($product->updatedAt) && isset($product->updatedAt->date)) {
			$datmaj = $product->updatedAt->date;
		}
		else {
			$datmaj = (string)$product->updatedAt;
		}
		if(empty($datmaj))
			$datmaj = '1980-01-01 00:00:00';

		$blob_search = '';
		if(isset($product->document) && !empty($product->document)) {
			$blob_search = $product->document;
		}

		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$query = $db->getQuery(true);
		$query->insert('#__pylot_bridge_fiches_sit');
		$query->columns('name, slug, product_code, city, lang, content, meta_description, meta_title, updated_at, search_blob');
		$query->values($db->quote($product->name) . ',' . $db->quote($product->slug) . ',' . $db->quote((string)$product->productCode) . ',' . $db->quote($product->city) . ',' . $db->quote($lang) . ',' . $db->quote($content) . ',' . $db->quote($metadesc) . ',' . $db->quote($metatitle) . ',' . $db->quote($datmaj) . ',' . $db->quote($blob_search));
		// echo "\n Quyery : " . (string) $query;
		$db->setQuery($query);
		$db->execute();
		$postId = $db->insertid();
		return $this->getPostObjectFrom('id', $postId, $lang);

		// TODO Gérer les métas
		// $metadesc = ((strlen($product->comment) > 127) ? substr(strip_tags($product->comment), 0, 127) . '...' : strip_tags($product->comment));
		// $metatitle = $product->name . ' - ' . $product->city;
		// Ensuite, on met à jour les champs de post
		$content = '';
		if (isset($product->commentHtml) && $product->commentHtml !== '' && $product->commentHtml != null) {
			$content = strip_tags($product->commentHtml, '<br>');
		}
		elseif ($product->comment != '') {
			$content = $product->comment;
		}
		elseif ($product->comment1 != '') {
			$content = $product->comment1;
		}

		$metadesc = ((strlen($content) > 127) ? substr($content, 0, 127) . '...' : $content);

		$datmaj2 = '';
		if (is_object($product->updatedAt) && isset($product->updatedAt->date)) {
			$datmaj2 = $product->updatedAt->date;
		}
		else {
			$datmaj2 = (string)$product->updatedAt;
		}
	}

	public function updatePostFromBridgeProduct($postId, $product, $lang) {

		$content = '';
		if (isset($product->commentHtml) && $product->commentHtml !== '' && $product->commentHtml != null) {
			$content = strip_tags($product->commentHtml, '<br>');
		}
		elseif ($product->comment != '') {
			$content = $product->comment;
		}
		elseif ($product->comment1 != '') {
			$content = $product->comment1;
		}
		$metadesc = ((mb_strlen($content) > 127) ? mb_substr($content, 0, 127) . '...' : $content);
		$metatitle = $product->name . ' - ' . $product->city;
		$datmaj = '';
		if (is_object($product->updatedAt) && isset($product->updatedAt->date)) {
			$datmaj = $product->updatedAt->date;
		}
		else {
			$datmaj = (string)$product->updatedAt;
		}
		if(empty($datmaj))
			$datmaj = '1980-01-01 00:00:00';

		$blob_search = '';
		if(isset($product->document) && !empty($product->document)) {
			$blob_search = $product->document;
		}



		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$query = $db->getQuery(true);
		$query->update('#__pylot_bridge_fiches_sit');
		$query->set('name=' . $db->quote($product->name))
			->set('slug=' . $db->quote($product->slug))
			->set('product_code=' . $db->quote((string)$product->productCode))
			->set('city=' . $db->quote($product->city))
			->set('lang=' . $db->quote($lang))
			->set('content=' . $db->quote($content))
			->set('meta_description=' . $db->quote($metadesc))
			->set('meta_title=' . $db->quote($metatitle))
			->set('updated_at=' . $db->quote($datmaj))
			->set('search_blob=' . $db->quote($blob_search))
			->where('id=' . $postId);
		$db->setQuery($query);
		$db->execute();
		return $this->getPostObjectFrom('id', $postId, $lang);

		// TODO Gérer les métas
		// $metadesc = ((strlen($product->comment) > 127) ? substr(strip_tags($product->comment), 0, 127) . '...' : strip_tags($product->comment));
		//
		// Ensuite, on met à jour les champs de post


	}

	public function deletePost($postId) {
		$db = Factory::getContainer()->get(DatabaseInterface::class);
		$query = $db->getQuery(true);
		$query->delete('#__pylot_bridge_fiches_sit');
		$query->where('id=' .$postId);
		$db->setQuery($query);
		return $db->execute();
	}

	/**
	 * Permet de récupérer le post courant (Wordpress)
	 * @return null|int id du post courant
	 */
	public function getCurrentPostId() {
		// Joomla, utilisé lorsqu'on a des url génériques du type option=com_pylot_bridge&view=bridgefichessit&id=117
		// On va chercher l'id de la fiche dans la table de correspondance
		$input = Factory::getApplication()->input;
		$currentComponent = $input->get('option');
		$currentView = $input->get('view');
		$currentId = $input->get('id');
		if($currentComponent == 'com_pylot_bridge' && $currentView == 'bridgefichessit' && !empty($currentId)) {
			return $currentId;
		}
		return null;
	}

}
