<?php

namespace Bridge\Weblibs;

use Bridge\Weblibs\BridgeClientParamsInterface;

class BridgeApiService
{
    private BridgeClientParamsInterface $clientParams;

    public function __construct(BridgeClientParamsInterface $clientParams)
    {
        $this->clientParams = $clientParams;
    }

    /**
     * Effectue un appel à l'API Bridge
     *
     * @param string $method méthode HTTP
     * @param string $entryPoint nom du point d'entrée d'API
     * @param array $data données à passer à l'API (tableau associatif clé => valeur)
     * @param int|null $timeout temps d'attente avant expiration de la requête
     * @param bool $useCache indique si on doit utiliser le cache pour le token
     * @param int $cacheTimeMinutes durée de vie du cache en minutes
     * @return false|mixed objet de la réponse de Bridge ou false si échec
     */
    public function callBridgeApi($method = 'GET', $entryPoint = '', $data = array(), $timeout = 40, $useCache = false, $cacheTimeMinutes = 120)
    {

        $tmpOptions = $this->clientParams->getBridgeCredentials();
        $urlBridge = $tmpOptions->urlBridge;
        $debug = false;
        if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug']=='Y') {
            $debug = true;
        }
        $token = '';

        try {
            $token = $this->clientParams->getBridgeToken($useCache);
        }
        catch(\Exception $ex) {
            if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug']=='Y') {
                echo "Exception call api Bridge : " . $ex->getMessage();
            }
            return false;
        }
        $urlparams = '';
        if (strtoupper($method) == 'GET') {
            if (is_array($data) && count($data) > 0) {
                $urlparams = '?';
                if($debug) {
                    $data['dncdebug'] = 'Y';
                }
                foreach ($data as $key => $val)
                    $urlparams .= $key . "=" . $val . "&";
            } elseif(!is_array($data)) {
                $urlparams = '?';
                $urlparams .= $data ;
                if($debug) {
                    $data .= "&dncdebug=Y";
                    $urlparams .= "&dncdebug=Y";
                }
            }
        } else {
            if($debug) {
                $data['dncdebug'] = 'Y';
            }
        }
        if ($token == '') {
            if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug']=='Y') {
                echo "Call api Bridge token vide";
            }
            return false;
        }

        $options = array(
            'http' => array(
                'method' => $method,
                'header' => array("Content-Type: application/json", "Authorization: Bearer " . $token),
                'ignore_errors' => true,
                'timeout' => $timeout,
                'content' => json_encode($data),
            ),
        );
        try {
            $urlAppel = $urlBridge . $entryPoint . $urlparams;


            if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug']=='BRIDGE_API') {
                echo "\n<br>Token : " . $token;
                echo "\n<br>Params : " . json_encode($data);
                die("\n<br>URL appel : " . $urlAppel);
            }
            $context = stream_context_create($options);
            if($useCache) {
                $rawData = $this->clientParams->cachedFileGetContent($urlAppel, false, $options, $cacheTimeMinutes);
                if(!empty($rawData) && isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug']=='BRIDGE_API_CACHE') {
                    echo "\n<br>Call api Bridge - données issues du cache pour l'URL : " . $urlAppel;
                    echo "\n<br>rawData : " . $rawData;
                }
                if(!empty($rawData)) {
                    $res = json_decode($rawData);
                    if (isset($res)) {
                        return $res;
                    }
                }
            }
            $rawData = file_get_contents($urlAppel, false, $context);
            $res = json_decode($rawData);
            if (isset($res)) {
                // die('AIAIAI');
                return $res;
            } else {

                if( $debug) {
                    print_r($data);
                    echo " |||";
                    echo "Call api Bridge donne vide ou mal formatee JSON URL : " . $urlBridge . $entryPoint . $urlparams . " Raw data : " . $rawData;
                }
                return false;
            }
        } catch (Exception $e) {
            if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug']=='Y') {
                echo "Call api Bridge - erreur réponse Bridge : " . $e->getMessage();
            }
            return false;
        }
        if(isset($_REQUEST['dncdebug']) && $_REQUEST['dncdebug']=='Y') {
            echo "Call api Bridge - on ne devrait pas etre ici";
        }

        return false;
    }
}
