<?php
namespace Bridge\Weblibs;



interface BridgeClientRendererInterface
{
    /**
     * Localise un fichier template PHP demandé (prend en compte les dossiers d'override du theme)
     * Pour wordpress, le recherche s'effectue dans cet ordre :
     * 1. /themes/theme/templates/$template_name
     * 2. /themes/theme/$template_name
     * 3. /plugins/plugin/templates/$template_name.
     *
     * @param   string  $template_name          Template to load.
     * @param   string  $string $template_path  Path to templates.
     * @param   string  $default_path           Default path to template files.
     * @return  string                          Path to the template file.
     */
    public function bridge_locate_template( $template_name, $template_path = '', $default_path = '' );

    /**
     * Effectue le rendu d'un template avec des données passées
     * @param string $template
     * @param array $data
     * @return string Code HTML du rendu
     */
    public function renderTemplate(string $template, array $data = array());

    /**
     * Effectue le rendu d'un template de liste Ajax avec des données passées
     * @param array $data
     * @return string Code HTML du rendu
     */
    public function renderListeAjaxTemplate(array $listData = array());

	/**
	 * Effectue le rendu d'un template de liste Ajax avec des données passées
	 * @param array $data
	 * @return string Code HTML du rendu
	 */
	public function renderListeTemplate(array $listData = array());

	/**
	 * Effectue le rendu d'un template de liste Ajax avec des données passées
	 * @param array $data
	 * @return string Code HTML du rendu
	 */
	public function renderFicheTemplate(array $ficheData = array());

    /**
     * Wordpress : Permet de localiser une feuille de style dynamique dans /public/bridgewebfrontlibs/css
     *
     * @param   string  $styleFileName          Feuille de style recherchée
     * @param   string  $styleFilePath          Chemin des styles
     * @param   string  $default_path           Chemin des styles par défaut
     * @return  string                          Chemin de la feuille de style recherchée
     */

    public function bridge_locate_style($styleFileName, $styleFilePath = '', $default_path = '');


    /**
     * Charge une feuille de style css dans la page
     * @param string $handle : id texte du css
     * @param string $src : url du css
     * @param array $deps : tableau de dépendances (liste d'id texte)
     * @param string|bool $ver : version
     * @param string $media
     * @return mixed
     */
    public function BridgeEnqueueStyle($handle, $src = "", $deps = array(), $ver = false, $media = 'all');

    /**
     * Charge un script js dans la page
     * @param string $name identifiant texte du script
     * @param string $link URL du script
     * @return bool
     */
    public function BridgeEnqueueScript($handle, $src = "", $deps = array(), $ver = false, $in_footer = false ) ;

    /**
     * Retourne le header du theme front-end du site pour affichage avant le code de la fichede détail (WordPress)
     * @return mixed
     */
    public function getHeaderBridge($arg = null);

    /**
     * Retourne le footer du theme front-end du site pour affichage après le code de la fichede détail (WordPress)
     * @return mixed
     */
    public function getFooterBridge();

    /**
     * Wordpress : Enregistre tous les scripts utilisés par Bridge pour traiter l'affichage
     * Ils seront chargés plus tard
     */
    public function registerAllStyles();

    /**
     * WORDPRESS : Enregistre tous les scripts utilisés par Bridge pour traiter l'affichage
     * Ils seront chargés plus tard
     */
    public function registerAllScripts();

    /**
     * Wordpress : Retourne un tableau des librairies Js utilisée pour afficher les listes / moteurs
     * @return array
     */
    public function getListScripts();

    /**
     * Wordpress : Retourne un tableau des librairies css utilisée pour afficher les listes / moteurs
     * @return array
     */
    public function getListStyles();

    /**
     * Wordpress : Charge tous les scripts et styles utilisés sur les listes
     */
    public function loadListScriptsAndStyles();

    /**
     * Wordpress : Retourne un tableau des librairies Js utilisée pour afficher une fiche de détail
     * @return array
     */
    public function getFicheScripts();

    /**
     * Wordpress : Retourne un tableau des librairies CSS utilisée pour afficher une fiche de détail
     * @return array
     */
    public function getFicheStyles();

    /**
     * Wordpress : Charge tous les scripts et styles utilisés sur les listes
     */
    public function loadFicheScriptsAndStyles();

	/**
	 * Permet de déclarer une fonction de callback pour retrvailler du contenu dans les vues Bridge sans avoir à les overrider
	 * éuivalent à wordpress apply_filter
	 * @param $hookName : nom du hook
	 * @param $callBack : fonction de callback
	 * @param int $priority : priorité
	 * @param int $acceptedArgs : nombre d'arguments acceptés
	 */
	public function applyFilters($hookName, $callBack, $priority = 10, $acceptedArgs = 1);

	/**
	 * prepareListViewRenderer : utile uniquement pour Drupal et Symfony (pour le moment)
	 * Prépare l'affichage d'une liste dans une page (non ajax)
	 * Attache les scripts et CSS et retourne un tableau associatif contenant toutes les données qui seront utilisées dans les vues
	 * $data Objet data tel que renvoyé par BridgeUtils::prepareListdataForRender
	 * $theme nom du fichier twig initial à charger
	 * @return array tableau associatif contenant toutes les données qui seront utilisées dans les vues
	 */
	public function prepareListViewRenderer($data, $theme = 'liste_sit') ;

	/**
	 * prepareFicheViewRenderer : utile uniquement pour Drupal et Symfony (pour le moment)
	 * Prépare l'affichage d'une fiche dans une page (non ajax)
	 * Attache les scripts et CSS et retourne un tableau associatif contenant toutes les données qui seront utilisées dans les vues
	 * @param $dataFiche Objet data tel que renvoyé par BridgeUtils::prepareFichedataForRender
	 * @param $theme nom du fichier twig initial à charger
	 * @return array tableau associatif contenant toutes les données qui seront utilisées dans les vues
	 */
	public function prepareFicheViewRenderer($datafiche, $theme = 'fiche_sit_ajax');

}
