<?php

/**
 * BridgeUtils
 * Utilistaires pour le plugin Bridge
 */
class BridgeUtils
{
    /**
     * Génère une suite de 10 lettres et chiffres servant d'identifiant probablement unique à chaque instance de carte créée
     * @return string
     */
    public static function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    /**
     * Transforme une chaine de caractèes accentuée en slug sans espaces ni accents ni carctères spéciaux
     * @param $string chaine à slugifier
     * @param string $delimiter caractère délimiteur pour remplacer les accents et caractères spéciaux
     * @return string
     */
    public static function slugify($string, $delimiter = '-') {
        $oldLocale = setlocale(LC_ALL, '0');
        setlocale(LC_ALL, 'en_US.UTF-8');
        $clean = iconv('UTF-8', 'ASCII//TRANSLIT', $string);
        $clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
        $clean = strtolower($clean);
        $clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);
        $clean = trim($clean, $delimiter);
        setlocale(LC_ALL, $oldLocale);
        return $clean;
    }

    /**
     * strReplaceAccent
     * Supprime les accents d'une chaine de caractères
     * @param $chaine chaine dont on veut remplacer les accents
     * @return string chaine sans accents
     * @deprecated utiliser slugify à la place
     */
    public static function strReplaceAccent($chaine) {
        return self::slugify($chaine);
    }

    /**
     * Supprime un dossier et tout son contenu
     * @param string $dirPath : chemin du dossier à supprimer
     */
    public static function deleteDir($dirPath) {
        $files = glob($dirPath . "/*");
        if (!empty($files)) {
            foreach ($files as $file){
                if (is_dir($file)) {
                    self::deleteDir($file);
                }
                if (is_file($file)) {
                    unlink($file);
                }
            }
            rmdir($dirPath);
        }
    }

    /**
     * Remplace les caractères accentués par des verions non accentués
     * @param $texte texte dont on souhaite retirer les accents
     * @return string chaine traitée
     */
    public static function stripAccents($texte){
        return strtr($texte,'àáâãäçèéêëìíîïñòóôõöùúûüýÿÀÁÂÃÄÇÈÉÊËÌÍÎÏÑÒÓÔÕÖÙÚÛÜÝ','aaaaaceeeeiiiinooooouuuuyyAAAAACEEEEIIIINOOOOOUUUUY');
    }

    /**
     * Remplace les espaces d'une chaine par des _
     * @param $texte texte dont on veut retirer les espace
     * @return array|string|string[] chaine triatée
     */
    public static function stripSpaces($texte){
        return str_replace(' ','_',$texte);
    }


    /**
     * Remplace les espaces d'une chaine par des _
     * @param $texte texte dont on veut retirer les espace
     * @return array|string|string[] chaine triatée
     */
    public static function stripForceHttps($texte){
        $texte = "http://" . $texte;
        $texte = str_replace("http://http://", "//", $texte);
        $texte = str_replace("http://https://", "https://", $texte);
        return $texte;
    }

    /**
     * Permet de faire un effet Ken Burns Aléatoire (utilisé dans le template de fiche 4)
     */
    public static function randomKenBurns(){
        $i = rand(1,8);
        switch($i) {
            case '1':
                $return = 'uk-transform-origin-top-left';   //The transition originates from the top left.
                break;
            case '2':
                $return = 'uk-transform-origin-top-center'; //The transition originates from the top.
                break;
            case '3':
                $return = 'uk-transform-origin-top-right';  //The transition originates from the top right.
                break;
            case '4':
                $return = 'uk-transform-origin-center-left';    //The transition originates from the left.
                break;
            case '5':
                $return = 'uk-transform-origin-center-right';   //The transition originates from the right.
                break;
            case '6':
                $return = 'uk-transform-origin-bottom-left';    //The transition originates from the bottom left.
                break;
            case '7':
                $return = 'uk-transform-origin-bottom-center';  //The transition originates from the bottom.
                break;
            case '8':
            default:
                $return = 'uk-transform-origin-bottom-right'; //The transition originates from the bottom right.
                break;
        }
        return $return;
    }


	/**
	 * COMPATIBILITE ASCENDANTE AVEC LES TEMPLATES
	 */

	public static function bridge_locate_template( $template_name, $template_path = '', $default_path = '' ) {
		return $GLOBALS['bridgeClientRenderer']->bridge_locate_template($template_name, $template_path, $default_path);
	}
	public static function bridge_locate_style( $styleFileName, $styleFilePath = '', $default_path = '') {
		return $GLOBALS['bridgeClientRenderer']->bridge_locate_style($styleFileName, $styleFilePath, $default_path);
	}

	public static function loadFicheScriptsAndStyles() {
		return $GLOBALS['bridgeClientRenderer']->loadFicheScriptsAndStyles();
	}
	public static function loadListScriptsAndStyles() {
		return $GLOBALS['bridgeClientRenderer']->loadListScriptsAndStyles();
	}
	public static function getHeaderBridge() {
		return $GLOBALS['bridgeClientRenderer']->getHeaderBridge();
	}
	public static function getFooterBridge() {
		return $GLOBALS['bridgeClientRenderer']->getFooterBridge();
	}
	public static function getAjaxURL() {
		return $GLOBALS['bridgeClientParams']->getAjaxURL();
	}

	public static function getResizeImage() {
		return $GLOBALS['bridgeClientParams']->getResizeImage();
	}

	public static function getBridgeParameters() {
		return $GLOBALS['bridgeClientParams']->getBridgeParameters();
	}

	public static function getMapsDefaultSettings() {
		return $GLOBALS['bridgeClientParams']->getMapsDefaultSettings();
	}

	public static function getLanguage() {
		return $GLOBALS['bridgeCmsAbstractLayer']->getCurrentLanguage();
	}

	public static function getChildColumns($object) {
		return $GLOBALS['bridgeBlockService']->getChildColumns($object);
	}

    public static function bridgeInlineSvg(string $urlImage, $imageTitle = '') {
		return $GLOBALS['bridgeBlockService']->bridgeInlineSvg($urlImage, $imageTitle);
	}

	public static function bridgeDirUrl() {
		return $GLOBALS['bridgeClientParams']->bridgeDirUrl();
	}

	public static function bridgeDirPath() {
		return $GLOBALS['bridgeClientParams']->bridgeDirPath();
	}

	public static function getLanguageLocale() {
		return $GLOBALS['bridgeClientParams']->getLanguageLocale();
	}

	public static function getResizeImageLink($url, $mode = "ajust", $width = "150", $height = "150", $quality = "60", $timeToCache = "1800")  {
		return $GLOBALS['bridgeClientParams']->getResizeImageLink($url, $mode, $width, $height, $quality , $timeToCache ) ;
	}

	public static function getIdFicheBridge() {
		return $GLOBALS['bridgeClientContent']->getIdFicheBridge();
	}

	public static function getPostPermalinkFromProductCode($productCode, $productSlug = '',  $lang = '') {
		return $GLOBALS['bridgeClientContent']->getMainTermLinkFromProductCode($productCode, $productSlug, $lang);
	}
	public static function filterModalities($mods, $filters = array()) {
		return $GLOBALS['bridgeBlockService']->filterModalities($mods, $filters);
	}
	public static function renderIcon($icon, $lemode = '', $label='') {
		return $GLOBALS['bridgeBlockService']->renderIcon($icon, $lemode, $label);
	}
	public static function getCvPreviewLink() {
		return $GLOBALS['bridgeClientParams']->getCvPreviewLink();
	}

    public static function getBridgeImgUrl() {
		return $GLOBALS['bridgeClientParams']->getBridgeImgUrl();
	}
    public static function getBridgeCredentials() {
		return $GLOBALS['bridgeClientParams']->getBridgeCredentials();
	}
	public static function getCvDownloadLink() {
		return $GLOBALS['bridgeClientParams']->getCvDownloadLink();
	}

	public static function BridgeBreadcrumbs() {
		return $GLOBALS['bridgeCmsAbstractLayer']->BridgeBreadcrumbs();
	}

	public static function getElevationData($fiche) {
		return $GLOBALS['bridgeDataGetter']->getElevationData($fiche);
	}
	public static function getDataFiche($productCode='', $idFicheBridge='', $langueForcee = '') {
		return $GLOBALS['bridgeDataGetter']->getDataFiche($productCode, $idFicheBridge, $langueForcee);
	}

	public static function prepareFicheDataForRender($ficheData) {
		return $GLOBALS['bridgeDataGetter']->prepareFicheDataForRender($ficheData);
	}


}


