<?php

namespace Bridge\Weblibs\Joomla;

use Bridge\Weblibs\BridgeClientParamsInterface;
use Bridge\Weblibs\BridgeClientRendererInterface;
use Bridge\Weblibs\BridgeCmsAbstractLayerInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;


class BridgeClientRendererJoomla implements BridgeClientRendererInterface
{

    private BridgeClientParamsInterface $clientParams;
	private BridgeCmsAbstractLayerInterface $bridgeCmsAbstractLayer;

    public function __construct(BridgeClientParamsInterface $clientParams, BridgeCmsAbstractLayerInterface $bridgeCmsAbstractLayer)
	{
        $this->clientParams = $clientParams;
		$this->bridgeCmsAbstractLayer = $bridgeCmsAbstractLayer;
    }

    /**
     * Effectue le rendu d'un template avec des données passées
     * @param string $template
     * @param array $data
     * @return string Code HTML du rendu
     */
    public function renderTemplate(string $templatePath, array $data = array()) {
        ob_start();
        // $template = self::bridge_locate_template('templates-bridge/fiche/gabarits/' . $componentName . '.php');
        $template = $this->bridge_locate_template($templatePath);
        include($template);
        $html = ob_get_clean();
        return $html;
    }

    /**
     * Effectue le rendu d'un template de liste Ajax avec des données passées
     * @param array $data
     * @return string Code HTML du rendu
     */
    public function renderListeAjaxTemplate(array $listData = array()) {
        $this->loadListScriptsAndStyles();
        ob_start();
        // $template = self::bridge_locate_template('templates-bridge/fiche/gabarits/' . $componentName . '.php');
        $template = $this->bridge_locate_template('templates-bridge/ajax.php');
        include($template);
        $html = ob_get_clean();
        return $html;
    }

	/**
	 * Effectue le rendu d'un template de liste Ajax avec des données passées
	 * @param array $data
	 * @return string Code HTML du rendu
	 */
	public function renderListeTemplate(array $listData = array()) {
		$this->loadListScriptsAndStyles();
		ob_start();
		$template = $this->bridge_locate_template('templates-bridge/liste.php');
		include($template);
		$html = ob_get_clean();
		return $html;
	}

	/**
	 * Effectue le rendu d'un template de liste Ajax avec des données passées
	 * @param array $data
	 * @return string Code HTML du rendu
	 */
	public function renderFicheTemplate(array $ficheData = array()) {
		if (!empty($ficheData)) {
			$this->loadFicheScriptsAndStyles();
			ob_start();
			include $this->bridge_locate_template('templates-bridge/init-variables-globales-fiche.php');
			include $this->bridge_locate_template('templates-bridge/fiche/bridge-document-ready.php');
			include $this->bridge_locate_template('templates-bridge/fiche/' . $ficheData['ficheTemplate'] . '.php');
			$html = ob_get_clean();
			return $html;
		}
		return '';
	}

	/**
	 * Effectue le rendu d'un template de liste Ajax avec des données passées
	 * @param array $data
	 * @return string Code HTML du rendu
	 */
	public function renderMoteurTemplate(array $moteurData = array(), $template = 'moteur1') {
		if (!empty($moteurData)) {
			$this->loadListScriptsAndStyles();
			ob_start();
			include $this->bridge_locate_template('templates-bridge/init-variables-globales-moteur.php');
			include $this->bridge_locate_template('templates-bridge/fiche/bridge-document-ready.php');
			$template = $this->bridge_locate_template('templates-bridge/engine/' . $template . '.php');
			include($template);
			$html = ob_get_clean();
			return $html;
		}
		return '';
	}

	/**
	 * Effectue le rendu d'un template de liste Ajax avec des données passées
	 * @param array $data
	 * @return string Code HTML du rendu
	 */
	public function renderMapTemplate(array $mapPreparedData = array()) {
		if (!empty($mapPreparedData)) {
			$this->loadListScriptsAndStyles();
			ob_start();
			$template = $this->bridge_locate_template('templates-bridge/carto/map.php');
			include($template);
			$html = ob_get_clean();
			return $html;
		}
		return '';
	}


	/**
     * Charge une feuille de style css dans la page
     * @param $handle : id texte du css
     * @param string $src : url du css
     * @param array $deps : tableau de dépendances (liste d'id texte)
     * @param false $ver : version
     * @param string $media
     * @return mixed
     */
    public function BridgeEnqueueStyle($handle, $src = "", $deps = array(), $ver = false, $media = 'all') {
        return $this->bridgeCmsAbstractLayer->enqueueStyle($handle, $src, $deps, $ver, $media);
    }

    /**
     * Charge un script js dans la page
     * @param $name identifiant texte du script
     * @param $link URL du script
     * @return bool
     */
    public function BridgeEnqueueScript($handle, $src = "", $deps = array(), $ver = false, $in_footer = false ) {
        return $this->bridgeCmsAbstractLayer->enqueueScript($handle, $src, $deps, $ver, $in_footer);
    }

    /**
     * Retourne le header du theme front-end du site pour affichage avant le code de la fichede détail (WordPress)
     * @return mixed
     */
    public function getHeaderBridge($arg = null) {
        return $this->bridgeCmsAbstractLayer->getHeaderBridge($arg);
    }

    /**
     * Retourne le footer du theme front-end du site pour affichage après le code de la fichede détail (WordPress)
     * @return mixed
     */
    public function getFooterBridge() {
        return $this->bridgeCmsAbstractLayer->getFooterBridge();
    }

    /**
     * registerAllStyles
     * Enregistre tous les scripts utilisés par Bridge pour traiter l'affichage
     * Ils seront chargés plus tard
     */
    public function registerAllStyles() {
	    $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        $customCss = $this->clientParams->getCustomCssURl();
        if(!empty($customCss))
	        $wa->registerStyle('sit-custom-css', $customCss);

    }

    /**
     * Enregistre tous les scripts utilisés par Bridge pour traiter l'affichage
     * Ils seront chargés plus tard
     */
    public function registerAllScripts() {
	    $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        $customJs = $this->clientParams->getCustomJsURl();
        if(!empty($customJs))
	        $wa->registerScript('sit-custom-js', $customJs);
    }

    /**
     * Retourne un tableau des librairies Js utilisée pour afficher les listes / moteurs
     * @return array
     */
    public function getListScripts() {
        $libraries = array();
        $libraries[] = 'com_pylot_bridge.uikit-js';
        $libraries[] = 'com_pylot_bridge.fontawesome-js';
        // $libraries[] = 'fontawesome-all';
        $libraries[] = 'com_pylot_bridge.leaflet-js';
        $libraries[] = 'com_pylot_bridge.leaflet-fs-js';
        $libraries[] = 'com_pylot_bridge.leaflet-mc-js';
        $libraries[] = 'com_pylot_bridge.leaflet-control-button-js';
        $libraries[] = 'com_pylot_bridge.leaflet-easy-button-js';
        $libraries[] = 'com_pylot_bridge.togeojson-js';
        $libraries[] = 'com_pylot_bridge.dnc-leaflet-services-js';
        $libraries[] = 'com_pylot_bridge.mc-datepicker-js';
        $libraries[] = 'com_pylot_bridge.infinite-scroll-js';
        $libraries[] = 'com_pylot_bridge.plugin-sit-script-js';
        $libraries[] = 'com_pylot_bridge.sit-custom-js';
        $libraries[] = 'com_pylot_bridge.bridge-autocomplete-js';
        $libraries[] = 'com_pylot_bridge.bridge-moteur-js';
        $libraries[] = 'com_pylot_bridge.bridge-datepicker-js';
        $locale = $this->clientParams->getLanguageLocale();
		$libraries[] = 'com_pylot_bridge.bridge-datepicker-' . $locale;
        $libraries[] = 'com_pylot_bridge.infinite-scroll-ajax-js';
        return $libraries;
    }

    /**
     * Retourne un tableau des librairies css utilisée pour afficher les listes / moteurs
     * @return array
     */
    public function getListStyles() {
        $libraries = array();
        $libraries[] = 'com_pylot_bridge.uikit-css';
        $libraries[] = 'com_pylot_bridge.fontawesome-v6-all-css';
        $libraries[] = 'com_pylot_bridge.leaflet-css';
        $libraries[] = 'com_pylot_bridge.leaflet-fs-css';
        $libraries[] = 'com_pylot_bridge.leaflet-mc-css';
        $libraries[] = 'com_pylot_bridge.leaflet-mc-theme-css';
        $libraries[] = 'com_pylot_bridge.leaflet-easy-button-css';
        $libraries[] = 'com_pylot_bridge.leaflet-control-button-css';
        $libraries[] = 'com_pylot_bridge.mc-datepicker-css';
        $libraries[] = 'com_pylot_bridge.bridge-datepicker-css';
        //$libraries[] = 'infiniscroll-style';
        $libraries[] = 'com_pylot_bridge.bridge-autocomplete-css';
        $libraries[] = 'com_pylot_bridge.plugin-sit-style-css';
        $libraries[] = 'com_pylot_bridge.sit-custom-css';
        return $libraries;
    }

    /**
     * Charge tous les scripts et styles utilisés sur les listes
     */
    public function loadListScriptsAndStyles() {
        $styles = $this->getListStyles();
        $scripts = $this->getListScripts();

        foreach($styles as $style)
        {
	        $this->bridgeCmsAbstractLayer->enqueueStyle($style);
        }
        foreach($scripts as $script) {
	        $this->bridgeCmsAbstractLayer->enqueueScript($script);
        }

    }

    /**
     * Retourne un tableau des librairies Js utilisée pour afficher une fiche de détail
     * @return array
     */
    public function getFicheScripts() {
        $libraries = array();
        $libraries[] = 'com_pylot_bridge.uikit-js';
        $libraries[] = 'com_pylot_bridge.fontawesome-js';
        // $libraries[] = 'fontawesome-all';
        $libraries[] = 'com_pylot_bridge.leaflet-js';
        $libraries[] = 'com_pylot_bridge.leaflet-fs-js';
        $libraries[] = 'com_pylot_bridge.leaflet-mc-js';
        $libraries[] = 'com_pylot_bridge.leaflet-control-button-js';
        $libraries[] = 'com_pylot_bridge.leaflet-easy-button-js';
        $libraries[] = 'com_pylot_bridge.togeojson-js';
        $libraries[] = 'com_pylot_bridge.dnc-leaflet-services-js';
        $libraries[] = 'com_pylot_bridge.mc-datepicker-js';
        $libraries[] = 'com_pylot_bridge.infinite-scroll-js';
        $libraries[] = 'com_pylot_bridge.plugin-sit-script-js';
        $libraries[] = 'com_pylot_bridge.bridge-simple-list-map-loader-js';
        $libraries[] = 'com_pylot_bridge.sit-custom-js';
        $libraries[] = 'com_pylot_bridge.bridge-datepicker-js';
	    $locale = $this->clientParams->getLanguageLocale();
	    $libraries[] = 'com_pylot_bridge.bridge-datepicker-' . $locale;
        $libraries[] = 'com_pylot_bridge.modernizer_calendar-js';
        $libraries[] = 'com_pylot_bridge.calendario-js';

        return $libraries;
    }

    /**
     * Retourne un tableau des librairies CSS utilisée pour afficher une fiche de détail
     * @return array
     */
    public function getFicheStyles() {
        $libraries = array();
        $libraries[] = 'com_pylot_bridge.uikit-css';
        $libraries[] = 'com_pylot_bridge.fontawesome-v6-all-css';
        $libraries[] = 'com_pylot_bridge.leaflet-css';
        $libraries[] = 'com_pylot_bridge.leaflet-fs-css';
        $libraries[] = 'com_pylot_bridge.leaflet-mc-css';
        $libraries[] = 'com_pylot_bridge.leaflet-control-button-css';
        $libraries[] = 'com_pylot_bridge.leaflet-easy-button-css';
        $libraries[] = 'com_pylot_bridge.leaflet-mc-theme-css';
        $libraries[] = 'com_pylot_bridge.mc-datepicker-css';
        $libraries[] = 'com_pylot_bridge.bridge-datepicker-css';
        // $libraries[] = 'infiniscroll-style';
        $libraries[] = 'com_pylot_bridge.plugin-sit-style-css';
        $libraries[] = 'com_pylot_bridge.sit-custom-css-css';
        $libraries[] = 'com_pylot_bridge.calendar-css';
        $libraries[] = 'com_pylot_bridge.calendar-custom-css';

        return $libraries;
    }

    /**
     * Charge tous les scripts et styles utilisés sur les listes
     */
    public function loadFicheScriptsAndStyles() {
        $styles = $this->getFicheStyles();
        $scripts = $this->getFicheScripts();
        foreach($styles as $style)
	        $this->bridgeCmsAbstractLayer->enqueueStyle($style);
        foreach($scripts as $script)
	        $this->bridgeCmsAbstractLayer->enqueueScript($script);
    }

    /**
     * Locate template.
     *
     * Localise un fichier template demandé (prend en compte les dossiers d'override du theme)
     * Pour wordpress, le recherche s'effectue dans cet ordre :
     * 1. /themes/theme/templates/$template_name
     * 2. /themes/theme/$template_name
     * 3. /plugins/plugin/templates/$template_name.
     *
     * @param   string  $template_name          Template to load.
     * @param   string  $string $template_path  Path to templates.
     * @param   string  $default_path           Default path to template files.
     * @return  string                          Path to the template file.
     */
    public function bridge_locate_template( $template_name, $template_path = '', $default_path = '' ) {
        // Set variable to search in the templates folder of theme.
	    // $activeMenu = Factory::getApplication()->getMenu()->getActive();
		// print_r($activeMenu);
		// $activeTemplate = $activeMenu->template_style_id;

	    $app = Factory::getApplication();
		// récupère l’objet style de template actif (menu courant inclus)
	    $templateStyle  = $app->getTemplate(true); // objet avec id/template/params:contentReference[oaicite:0]{index=0}

	    $templateFolder = $templateStyle->template; // nom du dossier du template
		$activeTmeplatePath = JPATH_THEMES . '/' . $templateFolder;
        $tmpl = $activeTmeplatePath . '/com_pylot_bridge/' . $template_name;

        if ( ! file_exists( $tmpl ) ) {
            // If the override template does NOT exist, fallback to the default template.
            $tmpl = $this->clientParams->bridgeDirPath() . '/' . $template_name;
        }
        return $tmpl;
    }

    /**
     * Permet de localiser une feuille de style dynamique dans /public/css
     *
     * @param   string  $styleFileName          Feuille de style recherchée
     * @param   string  $styleFilePath          Chemin des styles
     * @param   string  $default_path           Chemin des styles par défaut
     * @return  string                          Chemin de la feuille de style recherchée
     */

    public function bridge_locate_style($styleFileName, $styleFilePath = '', $default_path = '') {
        $tmpl = Uri::root()  . '/media/comp_pylot_bridge/css/' . $styleFileName;
        return $tmpl;
    }

	/**
	 * Permet de déclarer une fonction de callback pour retrvailler du contenu dans les vues Bridge sans avoir à les overrider
	 * éuivalent à wordpress apply_filter
	 * @param $hookName : nom du hook
	 * @param $callBack : fonction de callback
	 * @param int $priority : priorité
	 * @param int $acceptedArgs : nombre d'arguments acceptés
	 */
	public function applyFilters($hookName, $callBack, $priority = 10, $acceptedArgs = 1) {
		// TODO : implémenter un système de hook filter pour Joomla
		return $callBack;
		// return apply_filters($hookName,$callBack,$priority,$acceptedArgs);
	}


	/**
	 * prepareListViewRenderer : utile uniquement pour Drupal et Symfony (pour le moment)
	 * Prépare l'affichage d'une liste dans une page (non ajax)
	 * Attache les scripts et CSS et retourne un tableau associatif contenant toutes les données qui seront utilisées dans les vues
	 * $data Objet data tel que renvoyé par BridgeUtils::prepareListdataForRender
	 * $theme nom du fichier twig initial à charger
	 * @return array tableau associatif contenant toutes les données qui seront utilisées dans les vues
	 */
	public function prepareListViewRenderer($data, $theme = 'liste_sit') {
		return $data;
	}

	/**
	 * prepareFicheViewRenderer : utile uniquement pour Drupal et Symfony (pour le moment)
	 * Prépare l'affichage d'une fiche dans une page (non ajax)
	 * Attache les scripts et CSS et retourne un tableau associatif contenant toutes les données qui seront utilisées dans les vues
	 * @param $dataFiche Objet data tel que renvoyé par BridgeUtils::prepareFichedataForRender
	 * @param $theme nom du fichier twig initial à charger
	 * @return array tableau associatif contenant toutes les données qui seront utilisées dans les vues
	 */
	public function prepareFicheViewRenderer($datafiche, $theme = 'fiche_sit_ajax') {
		return $datafiche;
	}
}
