if(window.bridgeToggleFullscreen === undefined || typeof window.bridgeToggleFullscreen !== 'function') {
  function bridgeToggleFullscreen(elem, togglButton) {
    elem = elem || document.documentElement;
    if (!document.fullscreenElement && !document.mozFullScreenElement &&
        !document.webkitFullscreenElement && !document.msFullscreenElement) {
      if (elem.requestFullscreen) {
        elem.requestFullscreen();
      } else if (elem.msRequestFullscreen) {
        elem.msRequestFullscreen();
      } else if (elem.mozRequestFullScreen) {
        elem.mozRequestFullScreen();
      } else if (elem.webkitRequestFullscreen) {
        elem.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
      }
    } else {
      if (document.exitFullscreen) {
        document.exitFullscreen();
      } else if (document.msExitFullscreen) {
        document.msExitFullscreen();
      } else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
      } else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
      }
    }
  }
}

jQuery(document).ready(function() {
  (function() {
    var showChar = 400;
    var ellipsestext = "...";

    jQuery(".truncate").each(function() {
      var content = jQuery(this).html();
      if (content.length > showChar) {
        var c = content.substr(0, showChar);
        var h = content;
        var html =
            '<div class="truncate-text truncated-text" style="display:block">' +
            c +
            '<span class="moreellipses">' +
            ellipsestext +
            '&nbsp;&nbsp;<a href="#truncate" class="moreless more">+</a></span></div><div class="truncate-text full-text" style="display:none">' +
            h +
            '<a href="#truncate" class="moreless less">-</a></div>';

        jQuery(this).html(html);
      }
    });

    jQuery(".moreless").click(function() {
      var thisEl = jQuery(this);
      /*      var cT = thisEl.closest(".truncate-text");
            jQuery(".truncate-text").hide(500);
            var tX = ".truncate-text";
      */
      if (thisEl.hasClass("less")) {
        jQuery(".truncate-text.full-text").hide(200);
        jQuery(".truncate-text.truncated-text").show(200);
        // cT.prev(tX).toggle();
        // cT.slideToggle();
      } else {
        jQuery(".truncate-text.full-text").show(200);
        jQuery(".truncate-text.truncated-text").hide(200);
        /*
        cT.toggle();
        cT.next(tX).fadeToggle();
         */
      }
      return true;
    });

    // gestion multimoteurs

    // gestion multimoteurs : montrer la section idoine si filtre de switch actif au chargement

    // Gestion du changement de switch
    jQuery('.switchMultiMoteur').change(function (e) {
      var targetSection = jQuery(this).find(":selected").attr('data-target-section');
      var moteurContainer = jQuery(this).closest('.bridge-moteur-sit');
      var moteurId = moteurContainer.attr('data-bridge-moteur-id');
      // Ne fonctionne que quand le moteur n'est pas coupé en 2
      // moteurContainer.find('.bridge-moteur-section').each(function (index) {
      // Patch DN 16/06 : bug lorsu'il y a plusieurs moteurs
      jQuery('.bridge-moteur-sit').each(function(indexmoteur) {
        jQuery(this).find('.bridge-moteur-section').each(function (index) {
          // * Pour afficher les sections par défaut
          if (index > 0 && targetSection != '*') {
            jQuery(this).hide();
          } else {
            if (index > 0 && targetSection === '*') {
              jQuery(this).show();
            }
          }
        });
      });
      // Ne fonctionne que quand le moteur n'est pas coupé en 2
      // moteurContainer.find('.moteur-section-' + targetSection).show();
      jQuery('.bridge-moteur-sit').find('.moteur-section-' + targetSection).show();
    });

    // Au chargement de la page, si un filtre est actif, on montre la section idoine
    jQuery('.switchMultiMoteur').each(function (idx) {
      var selectedSwitch = jQuery(this).val();
      if(selectedSwitch !== '') {
        var targetSection = jQuery(this).find(":selected").attr('data-target-section');
        var moteurContainer = jQuery(this).closest('.bridge-moteur-sit');
        var moteurId = moteurContainer.attr('data-bridge-moteur-id');
        // Ne fonctionne que quand le moteur n'est pas coupé en 2
        // moteurContainer.find('.bridge-moteur-section').each(function (index) {
        // Patch DN 16/06 : bug lorsu'il y a plusieurs moteurs
        jQuery('.bridge-moteur-sit').each(function(indexmoteur) {
          jQuery(this).find('.bridge-moteur-section').each(function (index) {
            // * Pour afficher les sections par défaut
            if (index > 0 && targetSection != '*') {
              jQuery(this).hide();
            } else {
              if (index > 0 && targetSection === '*') {
                jQuery(this).show();
              }
            }
          });

        });

        // Ne fonctionne que quand le moteur n'est pas coupé en 2
        // moteurContainer.find('.moteur-section-' + targetSection).show();
        jQuery('.bridge-moteur-sit').find('.moteur-section-' + targetSection).show();
      }
    });

    // Gestion des conditions d'affichage de sections de moteurs
    // Au chargement de la page on masque ce qui doit l'être
    jQuery('div[data-bridge-hiddendefault="true"]').hide();

    // Au chargement de la page
    jQuery(document).find('input[type="checkbox"][data-item-id], input[type="radio"][data-item-id], option[data-item-id]').each(function (e) {
      // console.log('multimoteur chargement initial');
      var itemId = jQuery(this).attr('data-item-id');
      if(this.checked || this.selected) {
        jQuery('div[data-bridge-sbic*="|' + itemId +'|"]').show(500);
        jQuery('div[data-bridge-hbic*="|' + itemId +'|"]').hide(500);
      } else {
        jQuery('div[data-bridge-sbiu*="|' + itemId +'|"]').show(500);
        jQuery('div[data-bridge-hbiu*="|' + itemId +'|"]').hide(500);
      }
    });

    // Au changement de contrôles de moteur
    jQuery(document).find('input[type="checkbox"][data-item-id], input[type="radio"][data-item-id], select').change(function (e) {
      // console.log('détéction multimoteur ca a change');
      if(this.nodeName === 'SELECT') {
        if(jQuery(this).find('option[data-item-id]').length === 0) {
          return ;
        }
      }
      jQuery(document).find('div[data-bridge-hiddendefault="true"]').hide();
      jQuery(document).find('input[type="checkbox"][data-item-id], input[type="radio"][data-item-id], option[data-item-id]').each(function (e) {
        var itemId = jQuery(this).attr('data-item-id');
        var isChecked = (this.checked || this.selected);
        if(isChecked) {
          jQuery('div[data-bridge-sbic*="|' + itemId +'|"]').show(500);
          jQuery('div[data-bridge-hbic*="|' + itemId +'|"]').hide(500);

          jQuery('div[data-bridge-sbiu*="|' + itemId +'|"]').hide(500);
          jQuery('div[data-bridge-hbiu*="|' + itemId +'|"]').show(500);
        } else {
          // TG : 23/08 : truc bizarre : a quoi sert les sbiu et hbiu ? A méditer...
          // ND 28/03/2024 : faut se réveiller bouddha :) HiddenByItemUnchecked et HiddenByItemChecked
          // Et les pipes c'est pas pour faire joli, c'est pour éviter les conflits entre les id
          jQuery('div[data-bridge-sbiu*="|' + itemId +'|"]').show(500);
          jQuery('div[data-bridge-hbiu*="|' + itemId +'|"]').hide(500);

          // ces lignes permettent de cacher les sous moteurs quand on décoche la case du moteur associé
          jQuery('div[data-bridge-hbic*="|' + itemId +'|"]').show(500);
          jQuery('div[data-bridge-sbic*="|' + itemId +'|"]').hide(500);
        }
      });
    });
  })();


  // ******** Carnet de voyage ********
  // bouton d'ajout
  const add_buttons = document.getElementsByClassName("add-to-cv-button");

  for(let i = 0; i < add_buttons.length; i++) {

    const button = add_buttons.item(i);

    button.onclick = addToSessionButtonClickFunction(button);
  }

  const observer = new MutationObserver( mutations => {
    mutations.forEach( mutation => {
      mutation.addedNodes.forEach( addedNode => {
        addedNode.childNodes.forEach( entry => {
          if(!entry.className || typeof entry.className !== "string" || !entry.className.includes("ficheproduit")) return;

          const allElements = document.getElementsByClassName("add-to-cv-button");

          for (let i = 0; i < allElements.length; i++) {
            const currentElement = allElements[i];
            if (typeof currentElement["onclick"] !== 'function') {
              currentElement.onclick = addToSessionButtonClickFunction(currentElement);
            }
          }
        });
      });
    });
  });

  observer.observe(document.body, { childList: true, subtree: true });

  // bouton de suppression
  const remove_buttons = document.getElementsByClassName("cv-delete-button");

  for(let i = 0; i < remove_buttons.length; i++) {

  const button = remove_buttons.item(i);

  button.addEventListener("click", () => {

      jQuery.ajax({
        url: ajaxurl,
        type: "POST",
        dataType: "json",
        data: {
          action: "bridge_remove_fiche_from_session_cv",
          id: button.id
        },
        success: () => {
          // remove line
          const row = document.getElementById(`row-${button.id}`);
          row.remove();
        },
        error: (err) => {
          console.error(err);
        }
      });
    });
  }


  /* Switchs d'affichage des listes modes carte/liste */
  window.bridgeMixedViewModes = ['view-mixed', 'view-list', 'view-maps'];

  document.querySelectorAll('.bridge-liste .bridge-view-toggle button').forEach(button => {
    button.addEventListener('click', () => {
      const mode = button.getAttribute('data-mode');
      const target = button.getAttribute('data-target-container');
      const container = document.getElementById(target);

      // Retirer la classe actuelle
      container.classList.remove(...window.bridgeMixedViewModes);

      // Ajouter la nouvelle classe
      container.classList.add(mode);

      // Gérer les boutons actifs
      // Find the sibling buttons from the parent group and toggle active state
      const group = button.closest('.bridge-view-toggle');
      const buttons = group ? group.querySelectorAll('button') : document.querySelectorAll('.bridge-liste .bridge-view-toggle button');
      buttons.forEach(btn => btn.classList.remove('active', 'uk-button-primary'));
      button.classList.add('active');
      button.classList.add('uk-button-primary');

      // ✅ Redraw après la mise à jour du DOM
      setTimeout(function() {
        do_bridge_init_carto();
        window.mapService.reDraw();
      },500);
    });
  });


  /* end ready */
});

(function() {
  var isBridgeDocumentReadyFired = false;
  var bridgeDocumentReadyQueue = [];

  function flushBridgeDocumentReadyQueue() {
    if (isBridgeDocumentReadyFired) {
      return;
    }

    isBridgeDocumentReadyFired = true;

    while (bridgeDocumentReadyQueue.length > 0) {
      var callback = bridgeDocumentReadyQueue.shift();

      try {
        callback();
      } catch (error) {
        setTimeout(function() {
          throw error;
        }, 0);
      }
    }
  }

  function enqueueBridgeDocumentReadyCallback(fn) {
    if (typeof fn !== 'function') {
      return;
    }

    if (isBridgeDocumentReadyFired) {
      fn();
      return;
    }

    bridgeDocumentReadyQueue.push(fn);
  }

  if (typeof window.wp !== 'undefined' && typeof window.wp.domReady === 'function') {
    window.wp.domReady(flushBridgeDocumentReadyQueue);
  }

  if (document.readyState === 'complete' || document.readyState === 'interactive') {
    setTimeout(flushBridgeDocumentReadyQueue, 0);
  } else {
    document.addEventListener('DOMContentLoaded', flushBridgeDocumentReadyQueue);
  }

  document.addEventListener('readystatechange', function() {
    if (document.readyState === 'interactive' || document.readyState === 'complete') {
      flushBridgeDocumentReadyQueue();
    }
  });

  window.bridgeDocumentReady = function(fn) {
    enqueueBridgeDocumentReadyCallback(fn);
  };
})();


/**
 *
 * @param {HTMLElement} button
 * @returns {Function}
 */
function addToSessionButtonClickFunction(button) {
  return () => {
    let city = button.getAttribute('data-sit-city');
    let id = button.getAttribute('data-sit-id');
    let name = button.getAttribute('data-sit-name');

    jQuery.ajax({
      url: ajaxurl,
      type: "POST",
      dataType: "json",
      data: {
        action: "bridge_add_fiche_to_session_cv",
        id,
        name,
        city
      },
      success: () => {

        const message = '<i class="far fa-check-circle"></i> ' + bridgeMsgAddedtoCv + '<br><a href="' + cvPreviewURL + '">'+bridgeTradsJs.voir_carnet+'</a>' ;

        UIkit.notification(message, {
          pos: 'bottom-left',
          status:'success',
          timeout: 5000
        })

        // en mode texte, on remplace le texte "ajouter" par "ajouté"
        const buutonDisplayMode = jQuery(button).attr('data-display-mode');

        if(buutonDisplayMode === 'text') {
          button.innerText = bridgeMsgAddedtoCv;
        }

        button.disabled = true;
      },
      error: (err) => {
        if(err.responseJSON.data === "Cette fiche est déjà dans le CV") {
          button.disabled = true;
        }
        else {
          console.error(err);

          if(err.responseJSON)
            console.error(err.responseJSON)
        }
      }
    });
  }
}
