<?php

/**
 * Modifie les variables avant leur rendu en twig lors d'un appel à la fonction twig bridge_include
 *
 * @param $variables
 *   Tableau associatif des variables passées au Twig inclus (contexte + variables ajoutées avec WITH)
 * @param $template
 *   Chemin du template twig chargé
 */
function hook_bridgetwigvariables_alter(&$variables, &$template) {
    // Injecter une variable lors de l'affichage d'un template donné
    if(strpos($template, '/liste/gabarits/specifique/mosl/carte2.html.twig') !== false) {
        $variables['moslAddItineraireButton'] = true;
    }

    // Remplacer à la volée un chemin de template par un autre qui "extends" le template original
    // A priori, ceci peut être fait sans hook en utilisant le module components
    if($template == '@pylot_bridge/templates-bridge-twig/fiche/specifique/mosl/blocks-mosl/book_link.html.twig') {
        $template = '@mon_plugin/fiche/blocks-mosl/book_link.html.twig';
        // Et dans mon plugin : extends '@pylot_bridge/templates-bridge-twig/fiche/specifique/mosl/blocks-mosl/book_link.html.twig'
        // puis redéfinition des blocks à surcharger
    }
}