<?php
namespace Bridge\Weblibs;



interface BridgeClientParamsInterface
{
    /**
     * Retourne un tableau de Groupes d'options de markup HTML pour les listes (titres, conteneurs, etc.)
     * @return array Tableau de Groupes d'options de markup HTML pour les listes
     */
    public function getMarkupOptionGroups();

    /**
     * @return array[] Tableau des options de balises HTML pour les listes déroulantes de sélection dans l'administration
     */
    public function getHtmlTagsForMarkupOptions() ;

    /**
     * Retourne un tableau des options de balises HTML recommandées pour les listes (titres, conteneurs, etc.)
     * @return array Tableau des options de balises HTML recommandées pour les listes
     */
    public function getRecommendedMarkupOptions();

    /**
     * Retourne l'URL relative pour les appels AJAX des templates front-end qui lancent la récupération des données des listes
     */
    public function getAjaxURL();

    /**
     * WORDPRESS : Met à jour un réglage de Bridge en base de données
     *
     * @param string $optionName
     * @param mixed $optionValue
     */
    public function bridgeUpdateOption($optionName, $optionValue);

    /**
     * @return string code de la langue courante sur 2 lettres
     */
    public function getLanguage();
    /**
     * @return string code de la langue courante sous la forme fr-FR ou en-GB (langue - pays)
     */
    public function getLanguageLocale();
    /**
     * DRUPAL : Fonction indiquant le préfixe de langue à ajouter aux liens URL - sans objet dans Wordpress
     */
    public function getLanguagePrefix();


    /**
     * @return mixed|string URL du serveur Pylot Bridge (application distante)
     */
    public function getBridgeUrl();

    /**
     * @return mixed|string URL du serveur Pylot Bridge (application distante)
     */
    public function getUrlBridge();

    /**
     * @return mixed|string URL de la feuille de styles personnalisée définie dans le paramètres de l'extension
     */
    public function getCustomCssURl();

    /**
     * @return mixed|string URL du script personnalisé défini dans le paramètres de l'extension
     */
    public function getCustomJsURl();

    /**
     * @return stdClass Paramètres de l'extension relatifs à l'affichage des cartes
     */
    public function getMapsDefaultSettings();

    /**
     * Wordpress : retourne le Chemin de base relatif à la réécriture des URL de taxonomies (hors permalien personnalisé)
     * @return false|mixed|string Chemin de base relatif à la réécriture des URL de taxonomies (hors permalien personnalisé)
     */
    public function getTaxonomyRootUrl();

    /**
     * Wordpress : retourne le chemin de base relatif à la réécriture des URL des fiches (hors permalien personnalisé)
     * @return false|mixed|string
     */
    public function getFicheRootUrl();

    /**
     * Retourne l'URL du dossier du plugin Pylot Bridge
     * @return string URL du dossier du plugin Pylot Bridge
     */
    public function bridgeDirUrl();

    /**
     * Retournre le chemin physique du dossier du plugin Pylot Bridge
     * @return string Chemin du dossier du plugin Pylot Bridge
     */
    public function bridgeDirPath();

    /**
     * Retourne le chemin physique du dossier des telmplates d'affichage du plugin Pylot Bridge
     * @return string URL du dossier des telmplates d'affichage du plugin Pylot Bridge
     */
    public function bridgeTemplatesPath();

    /**
     * Retourne l'URL du script php de resizer d'image Bridge
     * @return string URL du resizer d'image Bridge
     */
    public function getResizeImage();

    /**
     * Génère un lien d'image redimensionnée selon les paramètres passés
     * @param $url URL de la photo originale
     * @param string $mode mode de redimensonnement :
     * - ajust pour ajuster aux dimensions passées (ne déborde pas)
     * - remplir : pour remplir le cadre de dimensions passées
     * - deform : pour déformer l'image et forcer les dimensions exactes
     * @param string $width largeur souhaitée
     * @param string $height hauteur souhaitée
     * @param string $quality qualité de compresion (sur 100 pour le jpg et de 0 à 9 pour le png)
     * @param int $timeToCache durée de cache navigateur à indiquer dans l'en-tête http
     * @return string l'URL du service qui affiche les données d'image redimensionnée
     */
    public function getResizeImageLink(string $url, string $mode = "ajust", $width = "150",  $height = "150", $quality = "60", $timeToCache = "1800");

    /**
     * Retourne un objet contenant les paramètres de connexion au serveur Bridge (serveur et identifiants Bridge)
     *
     * @return object objets contenant les paramètres de connexion au serveur Bridge
     */
    public function getBridgeCredentials();

    /**
     * Permet de récupérer un token de connexion à l'API Bridge à partir d'identifiants
     *
     * @param string $url Url du serveur Bridge
     * @param string $login login Bridge
     * @param string $pw mot de passe Bridge
     * @throws \Exception
     * @return string token de connexion
     */
    public function getBridgeTokenFromCredentials(string $url, string $login, string $pw);

    /**
     * Permet de récupérer le token de connexion à l'API Bridge
     * @return string token de connexion à l'API Bridge
     * @throws \Exception
     */
    public function getBridgeToken(bool $useCache = false);

    /**
     * Retounre l'id de site Pylot Bridge telle qu'enregistré dans les paramètres
     * @return array|mixed|null id de site Pylot Bridge
     */
    public function getSiteBridge();

    /**
     * Retourne l'id du bock photos par défaut de Pylot Bridge tel qu'enregistré dans les paramètres
     * @return array|mixed|null id de bloc photos
     */
    public function getIdBlockPhotos();

    /**
     * Retourne un tableau contenant les paramètres généraux du plugin Pylot Bridge ainsi que des données d'environnement
     * @return array tablea de paramètres et de données d'environnement
     */
    public function getBridgeParameters();



	public function getNeedToImport();
	public function setNeedToImport($val);

	public function getCvPreviewLink();
	public function getCvDownloadLink();

	public function getLastImportLog();
	public function setLastImportLog($txt);
    public function getBridgeImgUrl();

    public function cachedFileGetContent(string $url, bool $use_include_path = false, $options = null, int $cacheTimeMinutes = 120);


}
