<?php

namespace Bridge\Weblibs\Joomla;

use Bridge\Weblibs\BridgeCmsAbstractLayerInterface;

use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\WebAsset\WebAssetItem;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Mail\MailerFactoryInterface;
use Joomla\CMS\Router\Route;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\CMS\WebAsset\WebAssetRegistry;
use Joomla\CMS\Language\LanguageHelper;

/**
 * Couche d'abstraction au CMS
 *
 *
 * @package    Plugin_SIT
 * @subpackage Plugin_SIT/includes
 * @author     DN Consultants <info@dnconsultants.fr>
 */

class BridgeCmsAbstractLayerJoomla implements BridgeCmsAbstractLayerInterface {

    /**
     * Retourne vrai si le script a été enregistré / chargé
     * @param $handle : clé texte du script
     * @param $list : statut à vérifier : enqueued, registered
     * @return mixed
     */
    public function scriptIs($handle, $list ) {
	    $wa = Factory::getApplication()->getDocument()->getWebAssetManager();

		$res = false;
	    if($list == 'enqueued' && $wa->assetExists('script', $handle) && $wa->isAssetActive('script', $handle) ) {
			$res = true;
	    } elseif($list == 'registered' && $wa->assetExists('script', $handle) ) {
		    $res = true;
	    }
        return $res;
    }
    /**
     * Ajouter un script JS à la page courante
     * Si src est absent, le handle du script doit faire référence à un script préalablement déclaré avec registerScript
     * @param $handle : id texte du script
     * @param string $src : url du script
     * @param array $deps : tableau de dépendances (liste d'id texte)
     * @param false $ver : version
     * @param false $in_footer : charger dans le footer
     * @return mixed
     */
    public function registerScript($handle, $src = "", $deps = array(), $ver = false, $in_footer = false ) {
	    $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
	    if (! $wa->assetExists('script', $handle) && $src !== '')
	    {
		    $wa->registerScript($handle, $src);
		    // $wa->add('script', new WebAssetItem($handle, $src, ['type' => 'script'], [], $deps));
	    }
		return true;
    }

    /**
     * Ajouter un script JS à la page courante
     * Si src est absent, le handle du script doit faire référence à un script préalablement déclaré avec registerScript
     * @param $handle : id texte du script
     * @param string $src : url du script
     * @param array $deps : tableau de dépendances (liste d'id texte)
     * @param false $ver : version
     * @param false $in_footer : charger dans le footer
     * @return mixed
     */
	private WebAssetRegistry $wr;
	private WebAssetManager $wa;
	private WebAssetItem $wi;
    public function enqueueScript($handle, $src = "", $deps = array(), $ver = false, $in_footer = false ) {

		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
	    $wr = $wa->getRegistry();
	    $wr->addRegistryFile( 'media/com_pylot_bridge/joomla.asset.json');

	    if ($wa->assetExists('script', $handle)) {
		    $wa->useScript($handle);
	    } else {
			if($src !== '') {
				$wa->registerScript($handle, $src);
			} else {
				$wr->addRegistryFile( 'media/com_pylot_bridge/joomla.asset.json');
				$wa->registerScript($handle);
			}
			if ($wr->exists('script', $handle)) {
				$wa->useScript($handle);
			}
		    // $wa->add('script', new WebAssetItem($handle, $src, ['type' => 'script'], [], $deps));
		    $wa->useScript($handle);
	    }
		return true;
    }

    /**
     * Référencer une feuille de style CSS : associer un id texte à une URL
     * Si src est absent, le handle du css doit faire référence à un fichier préalablement déclaré avec registerStyle
     * @param $handle : id texte du css
     * @param string $src : url du css
     * @param array $deps : tableau de dépendances (liste d'id texte)
     * @param false $ver : version
     * @param string $media
     * @return mixed
     */
    public function registerStyle($handle, $src = "", $deps = array(), $ver = false, $media = 'all' ) {
	    $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
	    $wr = $wa->getRegistry();
	    $wr->addRegistryFile( 'media/com_pylot_bridge/joomla.asset.json');
	    if ($wa->assetExists('style', $handle)) {
		    // $wa->useStyle($handle);
	    } elseif($src !== '') {
		    $wa->registerStyle($handle, $src);
		    // $wa->useStyle($handle);
	    } else {
		    $wa->registerStyle($handle);
	    }

		return true;
    }

    /**
     * Ajouter une feuille de style CSS à la page courante
     * Si src est absent, le handle du css doit faire référence à un fichier préalablement déclaré avec registerStyle
     * @param $handle : id texte du css
     * @param string $src : url du css
     * @param array $deps : tableau de dépendances (liste d'id texte)
     * @param false $ver : version
     * @param string $media
     * @return mixed
     */
    public function enqueueStyle($handle, $src = "", $deps = array(), $ver = false, $media = 'all' ) {
	    $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
	    $wr = $wa->getRegistry();
	    $wr->addRegistryFile( 'media/com_pylot_bridge/joomla.asset.json');
	    if ($wa->assetExists('style', $handle)) {
		    $wa->useStyle($handle);
	    } else {
		    $wa->registerStyle($handle, $src);
			// $wa->add('style', new WebAssetItem($handle, $src, ['type' => 'style'], [], $deps));
		    $wa->useStyle($handle);
	    }
		return true;
	    // return wp_enqueue_style($handle, $src, $deps, $ver, $media);
    }

    /**
     * @return string Retourne le code de la langue courante (2 lettres en minuscules / fr par défaut)
     */
    public function getCurrentLanguage()
    {
	    $locale =  Factory::getapplication()->getLanguage()->getTag();
	    $ret = strtolower(substr($locale, 0, 2));
		return $ret;
    }

    /**
     * @return string Retourne le code de la langue courante sous la forme fr-FR ou en-GB (langue - pays)
     */
    public function getCurrentLanguageLocale()
    {
	    return Factory::getapplication()->getLanguage()->getTag();
    }

    /**
     * Retourne le code de langue d'un post donné (wordpress)
     * @param int $postId numéro de post
     * @return string
     */
    public function getPostLanguage($postId)
    {
	    // TODO : Voir si besoin pour Joomla
        return 'fr';
    }

    /**
     * Définit le code de langue d'un post donné (surtout pour WordPress qui ne gère pas nativement le multilingue
     * @param $postId : id du post
     * @return string code de langue sur 2 lettres
     */
    public function setPostLanguage($postId, $lang)
    {
	    // TODO : Voir si besoin pour Joomla
        return true;
    }

    /**
     * Sauvegarde les traductions d'un produit (WordPress)
     * @param array $translationsArray tableau associatif $lang => $postId ('fr' => 4)
     */
    public function savePostTranslations($translationsArray)
    {
	    // TODO : Voir si besoin pour Joomla
        return true;
    }

    /**
     * Définit le code de langue d'un post donné (WordPress)
     * @param $termId : id du terme
     * @return bool
     */
    public function setTermLanguage($termId, $lang)
    {
	    // TODO : Voir si besoin pour Joomla
        return true;
    }

    /**
     * Retourne la langue d'un terme (WordPress)
     * @param $termId : id du terme
     * @return string code de langue
     */
    public function getTermLanguage($termId)
    {
	    // TODO : Voir si besoin pour Joomla
        return 'fr';
    }

    /**
     * Retourne la langue d'un terme de taxonomie (WordPress)
     * ND 12/09/2022 : après recherche dans le code cette fonction n'est jamais utilisée
     * @param $termId : id du terme
     * @return array taleau associatif lang => id de terme
     */
    public function getTermTranslations($termId)
    {
	    // TODO : Voir si besoin pour Joomla
        $trans = array();
        return $trans;
    }

    /**
     * Sauvegarde les traductions d'un terme (Wordpress)
     * @param array $translationsArray tableau associatif $lang => $termId ('fr' => 4)
     */
    public function saveTermTranslations($translationsArray)
    {
	    // TODO : Voir si besoin pour Joomla
        return true;
    }

    /**
     * Retourne la liste des langues actives
     * @return string[] tableau de codes de langues
     */
    public function getLanguagesList()
    {
	    $langs = array('fr');
	    $languages = LanguageHelper::getLanguages();
		if(is_array($languages) && !empty($languages)) {
			foreach($languages as $language) {
				if($language->sef != 'fr') {
					$langs[] = $language->sef;
				}
			}
		}
        return $langs;
    }

    /**
     * Retourne le permalien associé à une weblist
     * @param $term_id : id de term lié à la lweblist
     * @param string $lang : langue en cours
     * @return string : Début de l'URL pour la réécriture des liens vers les fiches de la liste'
     */
    public function getPermalinkFromTermId($term_id, $lang = '')
    {
	    if (empty($lang))
		    $lang = $this->getCurrentLanguage();
	    $db    = Factory::getContainer()->get('DatabaseDriver');
	    $query = "SELECT * FROM #__pylot_bridge_rubriques WHERE id=" . $term_id . " AND lang='" . $lang . "';";
	    $db->setQuery($query);
	    // Load the results
	    $terms = $db->loadObjectList();

	    $permalink = '';
	    $term      = null;
	    if (count($terms) > 0)
	    {
		    $term      = $terms[0];
		    $permalink = $term->permalink;
		    if ($permalink != '')
		    {
			    return str_replace('//', '/', $permalink . '/');
		    }
	    }
	    $taxonomy = 'rubrique_sit_primaire';

	    $langUpper = strtoupper($lang);


	    if (!empty($term->destination_weblist))
	    {
		    $db    = Factory::getContainer()->get('DatabaseDriver');
		    $query = "SELECT * FROM #__pylot_bridge_rubriques WHERE id=" . $term_id . " AND lang='" . $lang . "';";
		    $db->setQuery($query);
		    // Load the results
		    $terms2 = $db->loadObjectList();
		    if (count($terms2) > 0)
		    {
			    $permalink = $terms2[0]->permalink;
			    if (!empty($permalink))
			    {
				    return str_replace('//', '/', $permalink . '/');
			    }
			    else
			    {
				    return "#errDest#Term" . $term_id . "#" . count($terms) . "#__#" . $term_id . "#";
			    }
		    }
	    }
    }

    public function get_site_url() {
        return Uri::root();
    }

    public function getPostPermalink($postId) {
	    // Utiliser plutôt la fonction bridgeClientContentJoomla->getMainTermLinkFromProductCode
	    $params = ComponentHelper::getParams('com_pylot_bridge');
	    $defaultMenuId = $params->get('fiche_root_url');
	    if(!empty($defaultMenuId)) {
		    $postLink = Route::_("index.php?Itemid=" . $defaultMenuId . "&option=com_pylot_bridge&view=bridgefichessit&id=" . $postId);
	    } else {
		    $postLink =  Route::_('index.php?option=com_pylot_bridge&view=bridgefichessit&id=' . $postId);
	    }

	    return $postLink;
    }

    /**
     * Retourne le header du theme front-end du site pour affichage avant le code de la fichede détail (WordPress)
     * @return mixed
     */
    public function getHeaderBridge($arg = null) {
	    // TODO : Voir si besoin pour Joomla
		return '';
        // return get_header($arg);
    }

    /**
     * Retourne le footer du theme front-end du site pour affichage après le code de la fichede détail (WordPress)
     * @return mixed
     */
    public function getFooterBridge() {
	    // TODO : Voir si besoin pour Joomla
		return '';
		// return get_footer();
    }



    /**
     * Renvoie une reponse http Json d'erreur
     * @param mixed|null $data données à renvoyer en Json
     * @param int|null $status_code code HTTP à renvoyer
     * @param int $options options d'après les specifications de la fonction wp_send_json_error
     */
    public function sendJsonError( $data = null, int $status_code = null, int $options = 0) {
	    $response = array( 'success' => false );
		$response['data'] = $data;
	    if ( ! headers_sent() ) {
		    header( 'Content-Type: application/json; charset=UTF8' );
	    }

		echo json_encode( $response );
		die();
    }

    /**
     * Renvoie une reponse http Json de succes
     * @param mixed|null $data données à renvoyer en Json
     * @param int|null $status_code code HTTP à renvoyer
     * @param int $options options d'après les specifications de la fonction wp_send_json_success
     */
    public function sendJsonSuccess( $data = null, int $status_code = null, int $options = 0) {
	    $response = array( 'success' => true );
	    $response['data'] = $data;
	    if ( ! headers_sent() ) {
		    header( 'Content-Type: application/json; charset=UTF8' );
	    }

	    echo json_encode( $response );
	    die();
    }

    /**
     * Renvoie une reponse http Json de succes
     * @param mixed|null $data données à renvoyer en Json
     * @param int|null $status_code code HTTP à renvoyer
     * @param int $options options d'après les specifications de la fonction wp_send_json_success
     */
    public function sendJson( $data = null, int $status_code = null, int $options = 0) {
	    if ( ! headers_sent() ) {
		    header( 'Content-Type: application/json; charset=UTF8' );
	    }

	    echo json_encode( $data );
	    die();
    }

    /**
     * Permet de déclarer une fonction de callback pour insérer du contenu dans les vues Bridge sans avoir à les overrider
     * éuivalent à wordpress add_action
     * @param $hookName : nom du hook
     * @param $callBack : fonction de callback
     * @param int $priority : priorité
     * @param int $acceptedArgs : nombre d'arguments acceptés
     */
    public function addDisplayHook($hookName, $callBack, $priority = 10, $acceptedArgs = 1) {
	    // TODO : Voir si besoin pour Joomla
		// add_action($hookName, $callBack, $priority, $acceptedArgs);
    }

    /**
     * Permet d'insérer un hook d'affichage dans les templates
     * @param string $hookName
     * @param mixed $args
     */
    public function doDisplayHook($hookName, ...$arg) {
	    // TODO : Voir si besoin pour Joomla
        // do_action($hookName, $arg);
    }

     /**
     * Permet de déclarer une fonction de callback pour retrvailler du contenu dans les vues Bridge sans avoir à les overrider
     * éuivalent à wordpress apply_filter
     * @param $hookName : nom du hook
     * @param $callBack : fonction de callback
     * @param int $priority : priorité
     * @param int $acceptedArgs : nombre d'arguments acceptés
     */
    public function applyFilters($hookName, $callBack, $priority = 10, $acceptedArgs = 1) {
	    // TODO : Voir si besoin pour Joomla
		// return apply_filters($hookName,$callBack,$priority,$acceptedArgs);
    }

    /**
     * Permet de déclarer une fonction de callback pour retrvailler du contenu dans les vues Bridge sans avoir à les overrider
     * éuivalent à wordpress apply_filter
     * @param $hookName : nom du hook
     * @param $callBack : fonction de callback
     * @param int $priority : priorité
     * @param int $acceptedArgs : nombre d'arguments acceptés
     */
    public function addFilter($hookName, $callBack, $priority = 10, $acceptedArgs = 1) {
	    // TODO : Voir si besoin pour Joomla
		// return add_filter($hookName,$callBack,$priority,$acceptedArgs);
    }

    /**
     * @return false|mixed|string Chemin de base relatif à la réécriture des URL des fiches (hors permalien personnalisé)
     */
    public function getFicheRewritePattern()
    {
	    // TODO : Voir si besoin pour Joomla
	    return '';
		/*
        $options = get_option('reglages_sit_avance_option');
        if (!empty($options['fiche_rewrite_pattern'])) {
            $temp = $options['fiche_rewrite_pattern'];
            return $temp;
        } else {
            return '/(.*)[/]?$';
        }
		*/
    }

    /**
     * Fonction pour WordPress : indique si on se trouve actuellement sur une page de taxonomie SIT
     * @return bool True si on est sur une page de taxonomie SIT
     *
     */
    public function IsFicheSitTaxonomy(){
	    // TODO : Voir si besoin pour Joomla
        return true;
	    // return is_tax( get_object_taxonomies( 'fiche_sit' ) );
        // Pareil normalement
        // return is_tax( 'rubrique_sit_primaire' );
    }

    /**
     * @return bool true si on est sur une page de fiche SIT
     */
    public function IsFicheSit() {
	    // TODO : Voir si besoin pour Joomla
	    return true;
        // Patch nicolas 27/04/21 : c'est un underscore !
        // return is_singular( array( 'fiche_sit' ) );
    }

    /**
     * fonction appelée depuis un modèle de fiche
     * Retourne le code HTML du fil d'Ariane affiché dans les fiches
     * @param string $delimiter délimiteur d'entrées
     * @param string $home texte pour l'entrée 'Accueil'
     * @param int $showCurrent mettre 1 pour afficher l'entre courante
     * @param string $before texte à afficher avant l'élément courant
     * @param string $after texte à afficher après l'élément courant
     *
     * @return string code HTML du fil d'Ariane affiché dans les fiches
     */
    public function BridgeBreadcrumbs($delimiter = '&raquo;',$home = '', $showCurrent = 1,$before = '<span class="current">',$after = '</span>',$showOnHome = true)
    {
	    // TODO : Voir si besoin pour Joomla
        return '';
    }

    /* Permet de trier un tableau */

    public function bridge_array_sort($array, $on, $order=SORT_ASC)
    {
        return $array;
    }


	public function _n($singular, $plural, $number, $domain = 'default') {
		return Text::plural($singular, $number);
	}
	public function _nmp($keyStr, $singular, $plural, $number, $domain = 'default') {
		return Text::plural($keyStr, $number);
	}

	public function __( $text, $domain = 'default' ) {
		return Text::_(strtoupper($text));
	}

	public function __mp($keyStr, $text, $domain = 'default') {
		// On ignore $text et domain qui ne concernent que Wordpress
		return Text::_(strtoupper($keyStr));
	}



	public function esc_attr($text) {
		return htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
	}
	public function esc_html($text) {
		return htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
	}

	public function esc_js($text) {
		$safe_text = $this->esc_html($text);
		$safe_text = preg_replace( '/&#(x)?0*(?(1)27|39);?/i', "'", stripslashes( $safe_text ) );
		$safe_text = str_replace( "\r", '', $safe_text );
		$safe_text = str_replace( "\n", '\\n', addslashes( $safe_text ) );
		return $safe_text;
	}

	public function sendMail($to, $subject, $message, $headers = '', $attachments = array())
	{
		if(empty($to) || empty($subject) || empty($message))
			return false;
		$mailer = Factory::getContainer()->get(MailerFactoryInterface::class)->createMailer();
		$replyTo = '';
		if(!empty($headers) && is_array($headers)) {
			foreach($headers as $header) {
				if(strpos(strtolower($header), 'reply-to:') !== false) {
					$replyTo = trim(mb_substr($header, 9));
				}
			}
		}
		if(!empty($replyTo))
			$mailer->addReplyTo($replyTo);
		$mailer->addRecipient($to);
		$mailer->setSubject($subject);
		$mailer->setBody($message);
		$mailer->isHtml(true);
		return $mailer->send();
	}

	public function send404Error($text = '') {
		Factory::getApplication()->setHeader('Status', '404', true);
	}
}
