<?php

namespace Bridge\Weblibs\Wordpress;

use Bridge\Weblibs\BridgeClientContentInterface;

class BridgeClientContentWordpress implements BridgeClientContentInterface
{

	private $bridgeCmsAbstractLayer;

	public function __construct(BridgeCmsAbstractLayerWordpress $bridgeCmsAbstractLayer) {
		$this->bridgeCmsAbstractLayer = $bridgeCmsAbstractLayer;
	}
    /**
     *  Retourne L'id d'une fiche Bridge pour un produit lui même
     * @param int|string $productCode
     * @param int|string $idFicheBridge
     * @return int|string id fiche issu de l'API Bridge ou '' si non trouvé
     */
    public function getIdficheBridge($productCode='', $idFicheBridge='') {
        global $post;

        // Récupération depuis le contexte
        if($idFicheBridge === '')
            $idFicheBridge = get_query_var('idFicheBridge');
        if($productCode === '' && !empty($post)) {
            $productCode = get_post_meta($post->ID, 'bridge_productCode', true);
            // TODO : ne pas extraire la rubrique d'ici mais plutôt de l'URL actuelle (passage du numéro de fiche SIT et Weblist ID)
            $terms = get_the_terms($post->ID, 'rubrique_sit_primaire');

            // Normalement, le modèle de fiche est issu des règles de réécriture mises en place à l'import
            // Si jamais il n'y en a pas (appel depuis /fiche-sit/slug ou pas de fiche saisie dans la weblist
            if (empty($idFicheBridge) && !empty($terms)) {
                foreach ($terms as $term) {
                    $idFiche = get_term_meta($term->term_id, 'weblist_ficheId', true);
                    if (!empty($idFiche)) {
                        $idFicheBridge = $idFiche;
                        break;
                    }
                }
            }
        }
        $postId = null;
        // ajout 29/06/22 : si pas de modèle de fiche passé, on essaie de retrouver le modèle associé à la première weblist attaché à la fiche
        if(empty($idFicheBridge)) {
            if(!empty($productCode)) {
                $postId = $this->getPostIdFromProductCode($productCode);
            } elseif(!empty($post)) {
                $postId = $post->ID;
            }

            if(isset($postId) && $postId !== false && !empty($postId)) {
                $terms = get_the_terms($postId, 'rubrique_sit_primaire');
                // Normalement, le modèle de fiche est issu des règles de réécriture mises en place à l'import
                // Si jamais il n'y en a pas (appel depuis /fiche-sit/slug ou pas de fiche saisie dans la weblist
                if (empty($idFicheBridge) && !empty($terms)) {
                    foreach ($terms as $term) {
                        $idFiche = get_term_meta($term->term_id, 'weblist_ficheId', true);
                        if (!empty($idFiche)) {
                            $idFicheBridge = $idFiche;
                            break;
                        }
                    }
                }
            }
        }
        return $idFicheBridge;
    }

	/**
	 * Retourne l'objet term du CMS courant associé à une liste Bridge
	 * @param int $webListId ID de weblist issu de l'appel à Bridge
	 * @param string $lang langue de récupération
	 * @return object|null Objet term du CMS
	 */
	public function getTermFromListId(int $webListId, string $lang = '')
	{
		if(empty($lang)) {
			$lang = $this->bridgeCmsAbstractLayer->getCurrentLanguage();
		}

		// GTranslate
		$dataGT = get_option('GTranslate');
		$isGTranslate = false;
		if(isset($dataGT) && !empty($dataGT) && class_exists('GTranslate')) {
			// En mode Gtranslate on a pas de posts traduits => on force le FR
			$lang = 'fr';
			$isGTranslate = true;
		}

		$langUpper = strtoupper($lang);
		$term = null;
		// On cherche si le term (catégorie) existe
		// patch 02/21 : plus qu'une seule catégorie
		$taxonomy = 'rubrique_sit_primaire';
		$args = array(
			'hide_empty' => false, // also retrieve terms which are not used yet
			'meta_query' => array(
				array(
					'key'       => 'weblist_id',
					'value'     => $webListId,
					'compare'   => '='
				)
			),
			'taxonomy'  => $taxonomy,
		);
		$term = null;
		$terms = get_terms( $args );
		if(count($terms) > 0) {
			foreach($terms as $termTemp) {
				$tempLang = $this->bridgeCmsAbstractLayer->getTermLanguage($termTemp->term_id);
				$deb = $termTemp->term_id;
				if($isGTranslate || $tempLang == $lang) {
					$deb="OOKOKOKOKO" . $tempLang . '-' . $lang;
					$term = $termTemp;
					break;
				} else {
					$deb="NON" . $tempLang . '-' . $lang;
				}
			}
		}

		return $term;
	}

	/**
	 * Retourne l'objet term du CMS courant associé à une liste Bridge
	 * @param int $webListId ID de weblist issu de l'appel à Bridge
	 * @param string $lang langue de récupération
	 * @return object|null Objet term du CMS
	 */
	public function getTermFromId(int $id, string $lang = '')
	{
		$taxonomy = 'rubrique_sit_primaire';
		return get_term_by('term_id', $id, $taxonomy);
	}

    /**
     * Retourne le chemin URL d'une liste Bridge (pour créer des liens vers les fiches et vers les listes)
     * @param object $webList objet weblist issu de l'appel à Bridge
     * @return array|string|string[] Portion d'URL de la liste
     */
    public function getListPermalink(object $webList) {
	    $term = null;

	    // Update 23/01/2023 : on supporte les listes sans id créées à la volée => lien automatique
	    if(!isset($webList->id) || empty($webList->id) || $webList->permalinkUrl == 'RUBRIQUE_PRINCIPALE') {
		    return 'RUBRIQUE_PRINCIPALE';
	    }

		if(isset($webList->id) && !empty($webList->id)) {
		    $term = $this->getTermFromListId($webList->id);
	    }
	    if(isset($term)) {
		    $permalink = $this->bridgeCmsAbstractLayer->getPermalinkFromTermId($term->term_id);
		    if(isset($_REQUEST['EETR'])) {
			    echo "PERMALINK : $permalink";
		    }
		    return $permalink;
	    } else {
		    $termid = 'pas de terme => veuillez lancer un import';
		    if(isset($_REQUEST['EETR'])) {
			    echo "PAS DE TERME !!!";
		    }
		    if(is_object($term) && isset($term->term_id))
			    $termid = $term->term_id;
		    return "#err" . $webList->id . "#" . $termid . "#";
	    }

    }

	public function getAllTerms($langfilter = '')
	{
		return get_terms(array(
			'taxonomy' => 'rubrique_sit_primaire',
			'hide_empty' => false
		));
	}

	public function getWebListIdFromTermObject($term)
	{
		return get_term_meta($term->term_id, 'weblist_id', true);
	}

	public function deleteTermObject(object $term)
	{
		return wp_delete_term($term->term_id, 'rubrique_sit_primaire');
	}

	/**
	 * Créé un nouveau terme dans le CMS
	 * @param   string  $termName
	 * @param   string  $termSlug
	 * @param   string|null  $termDescription
	 * @param   object  $webList
	 * @param   string  $lang
	 *
	 * @return mixed objet term du CMS
	 *
	 * @since version 1.0.0
	 */
	public function createTerm(string $termName, string $termSlug, $termDescription, object $webList, $permalink = '', string $lang = 'fr')
	{
		$options = array(
			"description" => $termDescription,
			"slug" => $termSlug,
			"parent" => 0
		);
		// $this->setLog($lang . ' - Création de la catégorie ' . $title);
		$term = wp_insert_term($termName, 'rubrique_sit_primaire', $options);
		if ($lang != 'fr')
			$this->bridgeCmsAbstractLayer->setTermLanguage($term['term_id'], $lang);

		wp_update_term($term['term_id'], 'rubrique_sit_primaire', array(
			"slug" => $termSlug,
			'parent' => 0,
			'name' => $termName,
			'description' => $termDescription,
			'hierarchical' => true
		));

		if (!empty($permalink)) {
			if (substr($permalink, -1, 1) == '/')
				$permalink = substr($permalink, 0, -1);
			if (substr($permalink, 0, 1) == '/')
				$permalink = substr($permalink, 1);
			update_term_meta($term['term_id'], 'permalien', $permalink);
		} else {
			delete_term_meta($term['term_id'], 'permalien');
		}

		// On mémorise l'id de weblist dans le meta du terme
		update_term_meta($term['term_id'], 'weblist_id', $webList->id);

		update_term_meta($term['term_id'], 'weblist_ficheId', $webList->ficheId);
		update_term_meta($term['term_id'], 'weblist_destinationWebListId', $webList->destinationWebListId);
		update_term_meta($term['term_id'], 'weblist_doNotCreateRewriteRuleForList', $webList->doNotCreateRewriteRuleForList);
		update_term_meta($term['term_id'], 'weblist_permalinkIsCanonical', $webList->permalinkIsCanonical);


		return $term;
	}

	public function updateTermFromWebList(object $term, string $termName, string $termSlug, $termDescription, object $webList, $permalink = '', string $lang = 'fr') {
		wp_update_term($term['term_id'], 'rubrique_sit_primaire', array(
			"slug" => $termSlug,
			'parent' => 0,
			'name' => $termName,
			'description' => $termDescription,
			'hierarchical' => true
		));

		if (!empty($permalink)) {
			if (substr($permalink, -1, 1) == '/')
				$permalink = substr($permalink, 0, -1);
			if (substr($permalink, 0, 1) == '/')
				$permalink = substr($permalink, 1);
			update_term_meta($term['term_id'], 'permalien', $permalink);
		} else {
			delete_term_meta($term['term_id'], 'permalien');
		}

		// On mémorise l'id de weblist dans le meta du terme
		update_term_meta($term['term_id'], 'weblist_id', $webList->id);

		update_term_meta($term['term_id'], 'weblist_ficheId', $webList->ficheId);
		update_term_meta($term['term_id'], 'weblist_destinationWebListId', $webList->destinationWebListId);
		update_term_meta($term['term_id'], 'weblist_doNotCreateRewriteRuleForList', $webList->doNotCreateRewriteRuleForList);
		update_term_meta($term['term_id'], 'weblist_permalinkIsCanonical', $webList->permalinkIsCanonical);
	}

    /**
     * Permet de récupérer l'url d'une fiche d'après son productCode
     * @param int|string $productCode champ productCode de Bridge
     * @return string URL de la fiche
     */
    public function getPostLinkFromProductCode($productCode) {
        global $wpdb;
        $lang = $this->bridgeCmsAbstractLayer->getCurrentLanguage();
        $permalink = '';

		// Paramètre spécifique à l'extension GTranslate : on revoit le premier post trouvé
	    $isGTranslate = false;
	    $dataGT = get_option('GTranslate');
	    if(isset($dataGT) && !empty($dataGT) && class_exists('GTranslate')){
		    // En mode Gtranslate on a pas de posts traduits => on force le FR
		    $isGTranslate = true;
	    }

        $sql = "SELECT post_id FROM $wpdb->postmeta WHERE meta_key = 'bridge_productCode' AND  meta_value LIKE " . $productCode;
        $temp = $wpdb->get_results($sql);
        $res = array();
        for ($i = 0; $i < count($temp); $i++) {
            if ($isGTranslate || $this->bridgeCmsAbstractLayer->getPostLanguage($temp[$i]->post_id) == $lang)
                $res = $temp[$i]->post_id;
        }
        if(isset($res) && !empty($res)) {
            $permalink = $this->bridgeCmsAbstractLayer->getPostPermalink($res);
        }
        if(isset($permalink) && $permalink!='')
            return $permalink;

        return "#ErrorPermaLink#";
    }

    /**
     * Permet de récupérer un Id de post à partir d'un numéro de produit SIT
     * @param string|int $productCode champ productCode de Bridge
     * @return string URL de la fiche
     */
    public function getPostIdFromProductCode($productCode) {
        global $wpdb;
        $lang = $this->bridgeCmsAbstractLayer->getCurrentLanguage();
	    // Paramètre spécifique à l'extension GTranslate : on revoit le premier post trouvé
	    $isGTranslate = false;
	    $dataGT = get_option('GTranslate');
	    if(isset($dataGT) && !empty($dataGT) && class_exists('GTranslate')){
		    // En mode Gtranslate on a pas de posts traduits => on force le FR
		    $isGTranslate = true;
	    }

        $sql = "SELECT post_id FROM $wpdb->postmeta WHERE meta_key = 'bridge_productCode' AND  meta_value LIKE " . $productCode;
        $temp = $wpdb->get_results($sql);
        $res = false;
        for ($i = 0; $i < count($temp); $i++) {
            if ($isGTranslate || $this->bridgeCmsAbstractLayer->getPostLanguage($temp[$i]->post_id) == $lang) {
                $res = $temp[$i]->post_id;
                return $res;
            }
        }

        return $res;
    }

    /**
     * Wordpress : Permet de récupérer le lien de la rubrique principale d'une fiche
     * @param int $productCode code SIT de la fiche
     * @param string $productSlug slug de la fiche (pour éviter une récupération en BDD si on l'a sous la main)
     * @return string Lien vers la fiche dans sa rubrique principale ou lien par défaut sinon
     */
    public function getMainTermLinkFromProductCode($productCode, $productSlug = '') {

        $link = '';
        $postId = $this->getPostIdFromProductCode($productCode);
        if(!empty($postId)) {
            $mainTermId = get_post_meta($postId, 'rubrique_principale', true);
            if(!empty($mainTermId)) {
                if(empty($productSlug)) {
                    $productSlug = get_post_field('post_name', $postId);
                }
                $tempPermalink = $this->bridgeCmsAbstractLayer->getPermalinkFromTermId($mainTermId);
                $link = '/' . $tempPermalink . $productSlug;
            }
        }
        // Voiture balais : s'il n'existe pas de liste cochée 'Rubrique principale' contenant cette fiche
        // On renvoit le permalien par défaut de la fiche
        if(empty($link)) {
            $link = $this->getPostLinkFromProductCode($productCode);
        }

        return $link;
    }

    /**
     * Permet de récupérer le lien vers une fiche)
     * @param int $productCode code SIT de la fiche
     * @param string $productSlug slug de la fiche (pour éviter une récupération en BDD si on l'a sous la main)
     * @param string $permalink Permalink de la liste courante (Wordpress réécritures d'URL)
     * @return string Lien vers la fiche dans sa rubrique principale ou lien par défaut sinon
     */
    public function getProductStandardLink($productCode, $productSlug = '', $permalink = '') {
		// Paramètre spécifique à l'extension GTranslate
	    $dataGT = get_option('GTranslate');
	    $isGTranslate = false;
	    if(isset($dataGT) && !empty($dataGT) && class_exists('GTranslate')){
		    // En mode Gtranslate on a pas de posts traduits => on force le FR
		    $isGTranslate = true;
	    }
        if(!empty($productSlug) && !empty($permalink) && $isGTranslate) {
            // Cas spécial pour GTranslate
	        $postId = self::getPostIdFromProductCode($productCode);
	        $post = get_post($postId);
	        $link = '/'.$permalink. $post->post_name;
			return $link;
        } elseif(!empty($productSlug) && !empty($permalink)) {
            // Cas normal d'utilisation pour wordpress
            return '/'.$permalink. $productSlug;
        } else {
            // Sinon lien par défaut
            return $this->getPostLinkFromProductCode($productCode);
        }
    }

    /**
     * Retourne l'ID de la fiche Bridge associée à un post
     *
     * @param int $postId
     * @return nuull|int id de fiche Bridge reliée au post (préférence pour la rubrique principale)
     */
    public function getFicheIdFromPostId(int $postId) {
        // TODO : ne pas extraire la rubrique d'ici mais plutôt de l'URL actuelle (passage du numéro de fiche SIT et Weblist ID)
        $terms = get_the_terms($postId, 'rubrique_sit_primaire');
        $idFicheBridge = null;
        // Normalement, le modèle de fiche est issu des règles de réécriture mises en place à l'import
        // Si jamais il n'y en a pas (appel depuis /fiche-sit/slug ou pas de fiche saisie dans la weblist
        if (!empty($terms)) {
            $debugTrace[] = 'Zone 3 - terms : ' . var_export($terms, true);
            // Patch 14/06/2023 : on prend la fiche de la rubrique principale en priorité
            $idFicheBridgeParDepit = '';
            $hasRubriquePrincipale = false;
            $nomsRubriques = [];
            $nomsRubriquesPrincipales = [];
            foreach ($terms as $term) {
                $idFiche = get_term_meta($term->term_id, 'weblist_ficheId', true);
                $rubriquePrincipale = get_term_meta($term->term_id, 'weblist_permalinkIsCanonical', true);
                if($rubriquePrincipale == true && !empty($idFiche)) {
                    if($hasRubriquePrincipale) {
                        $debugTrace[] = 'Zone 3,3 - Attention, il y a plusieurs rubriques principales - idFiche : ' . $idFiche;
                    }
                    $nomsRubriquesPrincipales[] = $term->term_id . '-' . $term->name;
                    $hasRubriquePrincipale = true;
                    $idFicheBridge = $idFiche;
                    $debugTrace[] = 'Zone 3,5 - on prend la fiche de la rubrique principale - idFiche : ' . $idFiche;
                } else if (!empty($idFiche) ) {
                    $idFicheBridgeParDepit = $idFiche;
                    $nomsRubriques[] = $term->term_id . '-' . $term->name;
                }
            }

            if($hasRubriquePrincipale) {
                $debugTrace[] = 'Zone 3,9 - rubriques principales : ' . implode(', ', $nomsRubriquesPrincipales);
                $debugTrace[] = 'Zone 3,91 - autres rubriques (non utilisées) : ' . implode(', ', $nomsRubriques);
            }
            // S'il n'y a pas de rubrique principale, on se rabat par dépit sur la fiche de la dernière webList
            if($hasRubriquePrincipale === false && !empty($idFicheBridgeParDepit)) {
                $debugTrace[] = 'Zone 4 - on prend une fiche en dépit de rubrique principale - idFiche : ' . $idFiche;
                $debugTrace[] = 'Zone 4,1 - rubriques par dépit : ' . implode(', ', $nomsRubriques);
                $idFicheBridge = $idFicheBridgeParDepit;
            }
	        /*
				$debugTrace[] = 'Zone 9 - postId : ' . $postId;
				$terms = get_the_terms($postId, 'rubrique_sit_primaire');
				$debugTrace[] = 'Zone 9 bis terms : ' . var_export($terms, true);
				// Normalement, le modèle de fiche est issu des règles de réécriture mises en place à l'import
				// Si jamais il n'y en a pas (appel depuis /fiche-sit/slug ou pas de fiche saisie dans la weblist
				if (empty($idFicheBridge) && !empty($terms)) {
					$debugTrace[] = 'Zone 10';
					foreach ($terms as $term) {
						$idFiche = get_term_meta($term->term_id, 'weblist_ficheId', true);
						$debugTrace[] = 'Zone 11 - term_id : ' . $term->term_id . ' - idFiche : ' . var_export($idFiche, true);
						if (!empty($idFiche)) {
							$idFicheBridge = $idFiche;
							break;
						}
					}
				}
*/
        }
        return $idFicheBridge;
    }

	public function deletePost($postId) {
		$this->delete_post_attachments($postId);
		return wp_delete_post($postId, true);
	}

    /**
     * Alias de get_query_var pour wordpress
     * @param string $var
     * @return mixed
     */
    public function getQueryVar(string $var) {
        return get_query_var($var);
    }

    /**
     * Retourne le code produit d'un post ous la forme de chaine
     * @param int $postId
     * @return string code produit
     */
    public function getProductCodeFromPostId(int $postId) {
        return get_post_meta($postId, 'bridge_productCode', true);
    }

    /**
     * Récupère le post courant (Wordpress)
     * @return null|int id du post courant
     */
    public function getCurrentPostId() {
        global $post;
        if(!empty($post)) {
            return $post->ID;
        } else {
            return null;
        }
    }

	public function getPostObjectFrom($field, $value, $lang) {
		// TODO : refactorer l'import Wordpress et mettre à jour cette fonction et compléter la librairie selon les besoins
	}

	public function createPostFromBridgeProduct($product, $lang) {
		// TODO : refactorer l'import Wordpress et mettre à jour cette fonction et compléter la librairie selon les besoins
	}

	public function updatePostFromBridgeProduct($postId, $product, $lang) {
		// TODO : refactorer l'import Wordpress et mettre à jour cette fonction et compléter la librairie selon les besoins
	}
}
